/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.settings.SearchSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class TableRowFilter
extends ResultPanelModel {
    private final TableLineFilter FILTER;
    private TableLineFilter junkFilter = AllowFilter.instance();
    private final List HIDDEN;
    private int _numSources;

    public TableRowFilter(TableLineFilter f) {
        if (f == null) {
            throw new NullPointerException("null filter");
        }
        this.FILTER = f;
        this.HIDDEN = new ArrayList(150);
        this._numSources = 0;
    }

    public boolean isSorted() {
        return super.isSorted() || SearchSettings.moveJunkToBottom();
    }

    public int getFilteredSources() {
        return super.getTotalSources();
    }

    public int getTotalSources() {
        return this.getFilteredSources() + this._numSources;
    }

    public int addNewResult(TableLine tl, SearchResult sr) {
        if (SearchSettings.hideJunk()) {
            int added = super.addNewResult(tl, sr);
            if (!this.junkFilter.allow(tl)) {
                int row = this.getRow(tl);
                this.remove(row);
                this.METADATA.remove(tl);
                this._numSources += tl.getLocationCount();
                return 0;
            }
            return added;
        }
        if (SearchSettings.moveJunkToBottom()) {
            boolean wasNotJunk = this.junkFilter.allow(tl);
            int added = super.addNewResult(tl, sr);
            if (wasNotJunk && !this.junkFilter.allow(tl)) {
                int row = this.getRow(tl);
                this.remove(row);
                return super.add(tl, this.getSortedPosition(tl));
            }
            return added;
        }
        return super.addNewResult(tl, sr);
    }

    public int add(DataLine line, int row) {
        TableLine tl = (TableLine)line;
        boolean isNotJunk = this.junkFilter.allow(tl);
        boolean allow = this.allow(tl);
        if (isNotJunk || !SearchSettings.hideJunk()) {
            if (allow) {
                return super.add(line, row);
            }
            this.HIDDEN.add(tl);
            if (this._useMetadata) {
                this.METADATA.addNew(tl);
            }
            this._numSources += tl.getLocationCount();
        } else {
            this._numSources += tl.getLocationCount();
        }
        return -1;
    }

    protected void simpleClear() {
        this._numSources = 0;
        this.HIDDEN.clear();
        super.simpleClear();
    }

    void filtersChanged() {
        this.rebuild();
        this.fireTableDataChanged();
    }

    void setJunkFilter(TableLineFilter junkFilter) {
        this.junkFilter = junkFilter != null ? junkFilter : AllowFilter.instance();
    }

    private boolean allow(TableLine line) {
        return this.FILTER.allow(line);
    }

    private void rebuild() {
        int i;
        ArrayList existing = new ArrayList(this._list);
        ArrayList hidden = new ArrayList(this.HIDDEN);
        this.simpleClear();
        this.setUseMetadata(false);
        if (this.isSorted()) {
            for (i = 0; i < existing.size(); ++i) {
                this.addSorted((DataLine)existing.get(i));
            }
        } else {
            for (i = 0; i < existing.size(); ++i) {
                this.add((DataLine)existing.get(i));
            }
        }
        HashMap<URN, TableLine> mergeMap = new HashMap<URN, TableLine>();
        for (int i2 = 0; i2 < hidden.size(); ++i2) {
            TableLine tl = (TableLine)hidden.get(i2);
            SearchResult sr = (SearchResult)tl.getInitializeObject();
            URN urn = sr.getRemoteFileDesc().getSHA1Urn();
            TableLine tableLine = (TableLine)mergeMap.get(urn);
            if (tableLine == null) {
                mergeMap.put(urn, tl);
                continue;
            }
            tableLine.addNewResult(sr, this.METADATA);
        }
        if (this.isSorted()) {
            Iterator it = mergeMap.values().iterator();
            while (it.hasNext()) {
                this.addSorted((DataLine)it.next());
            }
        } else {
            Iterator it = mergeMap.values().iterator();
            while (it.hasNext()) {
                this.add((DataLine)it.next());
            }
        }
        this.setUseMetadata(true);
    }
}

