/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.tables.DataLine;
import java.util.HashMap;

public class HashBasedDataLineModel
extends BasicDataLineModel {
    protected HashMap _indexes = new HashMap();

    public HashBasedDataLineModel(Class dataLineClass) {
        super(dataLineClass);
    }

    protected int forceAdd(DataLine dl, int row) {
        this._indexes.put(dl.getInitializeObject(), new Integer(row));
        int addedAt = super.add(dl, row);
        this.remapIndexes(addedAt + 1);
        return addedAt;
    }

    public int add(DataLine dl, int row) {
        Object init = dl.getInitializeObject();
        if (this._indexes.containsKey(init)) {
            return -1;
        }
        this._indexes.put(init, new Integer(row));
        int addedAt = super.add(dl, row);
        this.remapIndexes(addedAt + 1);
        return addedAt;
    }

    public void remove(int row) {
        Object init = this.get(row).getInitializeObject();
        this._indexes.remove(init);
        super.remove(row);
        this.remapIndexes(row);
    }

    public int getRow(Object o) {
        Integer idx = (Integer)this._indexes.get(o);
        if (idx == null) {
            return -1;
        }
        return idx;
    }

    public void doResort() {
        super.doResort();
        this._indexes.clear();
        this.remapIndexes(0);
    }

    public boolean contains(Object o) {
        return this._indexes.containsKey(o);
    }

    public void clear() {
        this._indexes.clear();
        super.clear();
    }

    public void remapIndexes(int start) {
        int end = this.getRowCount();
        for (int i = start; i < end; ++i) {
            this._indexes.put(this.get(i).getInitializeObject(), new Integer(i));
        }
    }

    public void initializeObjectChanged(Object old, Object now) {
        Object val = this._indexes.remove(old);
        this._indexes.put(now, val);
    }
}

