/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.AWTEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class TableDragRecognitionWrapper
implements MouseInputListener,
DragSourceListener {
    private boolean dndArmed = false;
    private final LimeJTable table;
    private final MouseDragGestureRecognizer delegate;
    private MouseEvent storedPress = null;
    private static final Field consumed;

    TableDragRecognitionWrapper(LimeJTable table, MouseDragGestureRecognizer wrappee) {
        this.table = table;
        this.delegate = wrappee;
    }

    public void mouseClicked(MouseEvent e) {
        this.dndArmed = false;
        this.delegate.mouseClicked(e);
        if (this.storedPress != null && this.storedPress.isConsumed()) {
            this.storedPress = TableDragRecognitionWrapper.unconsume(this.storedPress);
            this.table.processMouseEvent(this.storedPress);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.storedPress == e) {
            return;
        }
        this.dndArmed = false;
        this.storedPress = e;
        if (this.table.isPointSelected(e.getPoint()) && SwingUtilities.isLeftMouseButton(e)) {
            this.dndArmed = true;
            e.consume();
            this.delegate.mousePressed(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dndArmed = false;
        this.delegate.mouseReleased(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.delegate.mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        this.delegate.mouseExited(e);
    }

    private boolean isOSXAndDnDIsBroken() {
        return CommonUtils.isMacOSX() && CommonUtils.getJavaVersion().compareTo("1.4.2_05") < 0;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dndArmed) {
            int row;
            if (this.isOSXAndDnDIsBroken() && (row = this.table.rowAtPoint(e.getPoint())) != -1) {
                this.table.setSelectedRow(row);
            }
            e.consume();
        }
        this.delegate.mouseDragged(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.delegate.mouseDragged(e);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dndArmed = false;
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    private static MouseEvent unconsume(MouseEvent e) {
        try {
            if (consumed != null) {
                consumed.setBoolean(e, false);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return e;
    }

    static {
        Field f = null;
        try {
            f = AWTEvent.class.getDeclaredField("consumed");
        }
        catch (NoSuchFieldException nsfe) {
            ErrorService.error(nsfe);
        }
        if (f != null) {
            f.setAccessible(true);
        }
        consumed = f;
    }
}

