/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.upload.UploadDataLine;

final class UploadModel
extends BasicDataLineModel {
    UploadModel() {
        super(UploadDataLine.class);
    }

    public DataLine createDataLine() {
        return new UploadDataLine();
    }

    public int update(Object o) {
        Uploader uploader = (Uploader)o;
        int end = this.getRowCount();
        for (int i = 0; i < end; ++i) {
            UploadDataLine ud = (UploadDataLine)this.get(i);
            if (ud.getFileIndex() != uploader.getIndex() || !ud.getHost().equals(uploader.getHost()) || !ud.isInactive()) continue;
            ud.initialize(o);
            this.fireTableRowsUpdated(i, i);
            return i;
        }
        return -1;
    }

    int countActiveUploads() {
        int size = this.getRowCount();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            UploadDataLine ud = (UploadDataLine)this.get(i);
            if (ud.isInactive()) continue;
            ++count;
        }
        return count;
    }

    int getCurrentUploads() {
        int size = this.getRowCount();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            UploadDataLine dd = (UploadDataLine)this.get(i);
            if (!dd.isUploading()) continue;
            ++count;
        }
        return count;
    }

    double getActiveUploadsBandwidth() {
        int size = this.getRowCount();
        double count = 0.0;
        for (int i = 0; i < size; ++i) {
            UploadDataLine dd = (UploadDataLine)this.get(i);
            if (!dd.isUploading()) continue;
            count += Math.max(dd.getSpeed(), 0.0);
        }
        return count;
    }

    public Object refresh() {
        int size = this.getRowCount();
        boolean inactiveUploadPresent = false;
        for (int i = 0; i < size; ++i) {
            UploadDataLine ud = (UploadDataLine)this.get(i);
            ud.update();
            inactiveUploadPresent |= ud.isInactive();
        }
        this.fireTableRowsUpdated(0, size);
        return inactiveUploadPresent ? Boolean.TRUE : Boolean.FALSE;
    }

    void clearCompleted() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            UploadDataLine line = (UploadDataLine)this.get(i);
            if (!line.isInactive()) continue;
            this.remove(i);
        }
    }
}

