/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.licenses.PublishedCCLicense;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

public class CCRDFOuptut
implements FileEventListener {
    private final String CCPUBLISHER_TITLE = GUIMediator.getStringResource("CC_RDFOUTPUT_TITLE");
    private static final int DIALOG_WIDTH = 480;
    private static final int DIALOG_HEIGHT = 280;
    private final JLabel RDF_OUTPUT_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_RDF_OUTPUT"));
    private final JTextArea RDF_OUTPUT = new JTextArea();
    private final JScrollPane OUPUT_PANE = new JScrollPane(this.RDF_OUTPUT);
    private JDialog _dialog;
    private final FileDesc _fd;
    private final String _holder;
    private final String _title;
    private final String _year;
    private final String _description;
    private final String _url;
    private final int _type;
    private boolean _isEventHandled;

    public CCRDFOuptut(FileDesc fd, String holder, String title, String year, String description, String url, int type) {
        this._fd = fd;
        this._holder = holder;
        this._title = title;
        this._year = year;
        this._description = description;
        this._url = url;
        this._type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFileEvent(FileManagerEvent evt) {
        if (!evt.isChangeEvent() || evt.getFileDescs() == null || evt.getFileDescs().length == 0) {
            return;
        }
        if (this._fd.equals(evt.getFileDescs()[0])) {
            CCRDFOuptut cCRDFOuptut = this;
            synchronized (cCRDFOuptut) {
                if (this._isEventHandled) {
                    return;
                }
                this._isEventHandled = true;
            }
            this.init();
            FileDesc newFD = evt.getFileDescs()[1];
            String RDFString = PublishedCCLicense.getRDFRepresentation(this._holder, this._title, this._year, this._description, newFD.getSHA1Urn().httpStringValue(), this._type);
            this.RDF_OUTPUT.setText(RDFString);
            this._dialog.setLocationRelativeTo(MessageService.getParentComponent());
            this._dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    CCRDFOuptut.this.finish();
                }
            });
            this._dialog.setVisible(true);
        }
    }

    public void init() {
        this._dialog = new JDialog((Frame)GUIMediator.getAppFrame(), true);
        GUIUtils.addHideAction((JComponent)this._dialog.getContentPane());
        this._dialog.setResizable(false);
        this._dialog.setTitle(this.CCPUBLISHER_TITLE);
        JPanel publishPanel = new JPanel(new GridBagLayout());
        publishPanel.setOpaque(false);
        GridBagConstraints con = new GridBagConstraints();
        publishPanel.add((Component)this.RDF_OUTPUT_LABEL, con);
        con.insets = new Insets(2, 2, 2, 2);
        con.gridy = 1;
        JLabel uriLabel = new JLabel(this._url);
        uriLabel.setForeground(Color.BLUE);
        publishPanel.add((Component)uriLabel, con);
        this.RDF_OUTPUT.setEditable(false);
        this.RDF_OUTPUT.setBorder(new LineBorder(new Color(153, 153, 153)));
        this.RDF_OUTPUT.setLineWrap(true);
        this.OUPUT_PANE.setMinimumSize(new Dimension(450, 100));
        this.OUPUT_PANE.setPreferredSize(new Dimension(450, 100));
        con.gridy = 2;
        con.insets = new Insets(20, 2, 2, 2);
        publishPanel.add((Component)this.OUPUT_PANE, con);
        con.gridy = 3;
        con.insets = new Insets(10, 2, 2, 2);
        JButton copyButton = new JButton(GUIMediator.getStringResource("CC_PUBLISHER_COPY_BUTTON"));
        copyButton.setPreferredSize(new Dimension(120, 20));
        copyButton.addActionListener(new CopyButtonListener());
        publishPanel.add((Component)copyButton, con);
        JButton finishButton = new JButton(GUIMediator.getStringResource("CC_RDF_FINISH_LABEL"));
        finishButton.addActionListener(new FinishButtonListener());
        con.gridy = 4;
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(470, 2));
        publishPanel.add((Component)separator, con);
        con.gridy = 5;
        con.anchor = 13;
        con.insets = new Insets(10, 2, 2, 2);
        publishPanel.add((Component)finishButton, con);
        publishPanel.setPreferredSize(new Dimension(470, 270));
        this._dialog.getContentPane().add(publishPanel);
        this._dialog.setSize(new Dimension(480, 280));
    }

    private void finish() {
        this._dialog.setVisible(false);
        this._dialog.dispose();
    }

    private class FinishButtonListener
    implements ActionListener {
        private FinishButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CCRDFOuptut.this.finish();
        }
    }

    private class CopyButtonListener
    implements ActionListener {
        private CopyButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(CCRDFOuptut.this.RDF_OUTPUT.getText()), null);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
    }
}

