/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorPanel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class DocumentEditor
extends MetaEditorPanel {
    private JLabel titleLabel;
    private LimeTextField titleTextField;
    private JLabel topicLabel;
    private LimeTextField topicTextField;
    private JCheckBox topicCheckBox;
    private JLabel authorLabel;
    private LimeTextField authorTextField;
    private JCheckBox authorCheckBox;
    private JLabel licenseTypeLabel;
    private JComboBox licenseTypeComboBox;
    private JCheckBox licenseTypeCheckBox;
    private JLabel licenseLabel;
    private LimeTextField licenseTextField;
    private JCheckBox licenseCheckBox;
    private String title = null;
    private boolean titleEdited = false;

    public DocumentEditor(FileDesc[] fds, LimeXMLSchema schema, LimeXMLDocument document) {
        super(fds, schema, document);
        super.setName(MetaEditorUtil.getStringResource("documents__document"));
        this.init();
        this.initFields();
        this.setMultiEdit(fds.length > 1);
        ComboBoxValue val = (ComboBoxValue)this.licenseTypeComboBox.getSelectedItem();
        if (val == null || !val.equals(new ComboBoxValue("creativecommons.org/licenses/"))) {
            this.licenseTextField.setVisible(false);
            this.licenseLabel.setVisible(false);
            this.licenseCheckBox.setVisible(false);
        }
        this.titleTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                DocumentEditor.this.titleEdited = true;
            }
        });
    }

    public void setMultiEdit(boolean multiEdit) {
        super.setMultiEdit(multiEdit);
        this.titleLabel.setEnabled(!multiEdit);
        this.titleTextField.setEnabled(!multiEdit);
    }

    public boolean hasChanged() {
        return this.titleEdited || super.hasChanged();
    }

    protected void prepareSave() {
        String text;
        if (this.title != null && (text = this.titleTextField.getText().trim()).equals("")) {
            this.titleTextField.setText(this.title);
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.titleLabel = new JLabel(MetaEditorUtil.getStringResource("documents__document__title__"));
        this.add((Component)this.titleLabel, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.titleTextField = new LimeTextField(24);
        this.add((Component)this.titleTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.authorLabel = new JLabel(MetaEditorUtil.getStringResource("documents__document__author__"));
        this.add((Component)this.authorLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.authorCheckBox = new JCheckBox();
        this.add((Component)this.authorCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.authorTextField = new LimeTextField(24);
        this.add((Component)this.authorTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        this.topicLabel = new JLabel(MetaEditorUtil.getStringResource("documents__document__topic__"));
        this.add((Component)this.topicLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.topicCheckBox = new JCheckBox();
        this.add((Component)this.topicCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        this.topicTextField = new LimeTextField(24);
        this.add((Component)this.topicTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseTypeLabel = new JLabel(MetaEditorUtil.getStringResource("images__image__licensetype__"));
        this.add((Component)this.licenseTypeLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseTypeCheckBox = new JCheckBox();
        this.add((Component)this.licenseTypeCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseTypeComboBox = new JComboBox();
        this.add((Component)this.licenseTypeComboBox, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseLabel = new JLabel(MetaEditorUtil.getStringResource("images__image__license__"));
        this.add((Component)this.licenseLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseCheckBox = new JCheckBox();
        this.add((Component)this.licenseCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseTextField = new LimeTextField(24);
        this.licenseTextField.setEnabled(false);
        this.add((Component)this.licenseTextField, gbc);
    }

    protected void initFields() {
        this.addComponent("documents__document__title__", this.titleTextField);
        this.addComponent("documents__document__topic__", this.topicCheckBox, this.topicTextField);
        this.addComponent("documents__document__author__", this.authorCheckBox, this.authorTextField);
        this.addComponent("documents__document__licensetype__", this.licenseTypeCheckBox, this.licenseTypeComboBox);
        this.addComponent("documents__document__license__", this.licenseCheckBox, this.licenseTextField);
        super.initFields();
    }
}

