/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.xml.MetaEditorFrame;
import com.limegroup.gnutella.gui.xml.editor.ApplicationTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.CCPublisherTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.DocumentTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.ImageTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.MetaDataSaver;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.PublisherMetaDataSaver;
import com.limegroup.gnutella.gui.xml.editor.VideoTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.audio.AudioTabbedPane;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MetaEditor
extends JDialog {
    private FileDesc[] fds;
    private String fileName;
    private Frame parent;
    private Component relativeToComponent = null;
    private JButton advancedButton;
    private JButton cancelButton;
    private JButton okButton;
    private JTabbedPane tabbedPane;

    public MetaEditor(Frame parent, FileDesc fd, String fileName, boolean publish) {
        this(parent, new FileDesc[]{fd}, fileName, publish);
    }

    public MetaEditor(Frame parent, FileDesc[] fds, String fileName, boolean publish) {
        super(parent, true);
        this.parent = parent;
        this.fds = fds;
        this.fileName = fileName;
        this.initComponents(publish);
        if (CommonUtils.isMacOSX()) {
            this.tabbedPane.setFocusable(false);
        }
        this.advancedButton.setText(GUIMediator.getStringResource("META_EDITOR_ADVANCED_BUTTON_LABEL"));
        this.okButton.setText(GUIMediator.getStringResource("META_EDITOR_OK_BUTTON_LABEL"));
        this.cancelButton.setText(GUIMediator.getStringResource("META_EDITOR_CANCEL_BUTTON_LABEL"));
        if (fds.length == 1) {
            this.setTitle(fds[0].getFile().getName());
        } else {
            this.advancedButton.setEnabled(false);
            this.setTitle(GUIMediator.getStringResource("META_EDITOR_MULTIPLE_FILE_INFO_LABEL"));
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.requestFocus();
        this.okButton.updateUI();
        this.cancelButton.updateUI();
        this.advancedButton.updateUI();
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this.pack();
    }

    private JTabbedPane createTabbedPane(boolean publish) {
        MetaEditorTabbedPane tabbedPane = null;
        if (publish) {
            if (LimeXMLUtils.isFilePublishable(this.fileName)) {
                tabbedPane = new CCPublisherTabbedPane(this.fds);
            }
            return tabbedPane;
        }
        if (MediaType.getAudioMediaType().matches(this.fileName)) {
            tabbedPane = new AudioTabbedPane(this.fds);
        } else if (MediaType.getVideoMediaType().matches(this.fileName)) {
            tabbedPane = new VideoTabbedPane(this.fds);
        } else if (MediaType.getProgramMediaType().matches(this.fileName)) {
            tabbedPane = new ApplicationTabbedPane(this.fds);
        } else if (MediaType.getImageMediaType().matches(this.fileName)) {
            tabbedPane = new ImageTabbedPane(this.fds);
        } else if (MediaType.getDocumentMediaType().matches(this.fileName)) {
            tabbedPane = new DocumentTabbedPane(this.fds);
        }
        return tabbedPane;
    }

    private void initComponents(boolean publish) {
        this.tabbedPane = this.createTabbedPane(publish);
        JPanel buttonPanel1 = new JPanel();
        JPanel cancelOKPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        JPanel spacer1 = new JPanel();
        JPanel advancedPanel = new JPanel();
        this.advancedButton = new JButton();
        JPanel spacer2 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setCursor(new Cursor(0));
        this.setLocationRelativeTo(this);
        this.setName("MetaEditorDialog");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MetaEditor.this.doWindowClose(evt);
            }
        });
        this.tabbedPane.setMinimumSize(null);
        this.tabbedPane.setNextFocusableComponent(this.okButton);
        this.tabbedPane.setPreferredSize(null);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        buttonPanel1.setLayout(new BorderLayout());
        buttonPanel1.setMinimumSize(new Dimension(264, 40));
        buttonPanel1.setPreferredSize(new Dimension(0, 40));
        cancelOKPanel.setLayout(new GridBagLayout());
        this.cancelButton.setText("Cancel");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setNextFocusableComponent(this.advancedButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MetaEditor.this.doCancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        cancelOKPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.setNextFocusableComponent(this.cancelButton);
        this.okButton.setSelected(true);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MetaEditor.this.doOK(evt);
            }
        });
        cancelOKPanel.add((Component)this.okButton, new GridBagConstraints());
        cancelOKPanel.add((Component)spacer1, new GridBagConstraints());
        buttonPanel1.add((Component)cancelOKPanel, "East");
        advancedPanel.setLayout(new GridBagLayout());
        this.advancedButton.setText("Advanced");
        this.advancedButton.setFocusPainted(false);
        this.advancedButton.setNextFocusableComponent(this.okButton);
        this.advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MetaEditor.this.doAdvanced(evt);
            }
        });
        this.advancedButton.setVisible(!publish);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        advancedPanel.add((Component)this.advancedButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        advancedPanel.add((Component)spacer2, gridBagConstraints);
        buttonPanel1.add((Component)advancedPanel, "West");
        this.getContentPane().add((Component)buttonPanel1, "South");
        this.pack();
    }

    public void setLocationRelativeTo(Component c) {
        this.relativeToComponent = c;
        super.setLocationRelativeTo(c);
    }

    public MetaDataSaver getMetaDataSaver() {
        if (this.tabbedPane instanceof CCPublisherTabbedPane) {
            return new PublisherMetaDataSaver((CCPublisherTabbedPane)this.tabbedPane, this.fds);
        }
        return new MetaDataSaver((MetaEditorTabbedPane)this.tabbedPane, this.fds);
    }

    private void doAdvanced(ActionEvent evt) {
        MetaEditorFrame frame = new MetaEditorFrame(this.fds[0], this.fileName, this.parent);
        this.setVisible(false);
        this.dispose();
        if (this.relativeToComponent != null) {
            frame.setLocationRelativeTo(this.relativeToComponent);
        }
        frame.setVisible(true);
        frame.dispose();
    }

    private void doWindowClose(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void doOK(ActionEvent evt) {
        if (!this.getMetaDataSaver().saveMetaData()) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void doCancel(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

