/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MetaEditorUtil {
    private static final Log LOG = LogFactory.getLog(MetaEditorUtil.class);
    private static final HashMap XSD_MESSAGEBUNDLE_BRIDGE = new HashMap();
    private static final Object EMPTY_VALUE;

    private MetaEditorUtil() {
    }

    public static boolean contains(String resource) {
        return XSD_MESSAGEBUNDLE_BRIDGE.containsKey(resource);
    }

    public static String getStringResource(String resourceKey) {
        String rscKey = (String)XSD_MESSAGEBUNDLE_BRIDGE.get(resourceKey);
        Assert.that(rscKey != null, "Unknown resourceKey: " + resourceKey);
        return GUIMediator.getStringResource(rscKey);
    }

    public static String getKind(File file) {
        String name = file.getName();
        if (LimeXMLUtils.isMP3File(name)) {
            return GUIMediator.getStringResource("META_EDITOR_MP3_KIND_LABEL");
        }
        if (LimeXMLUtils.isM4AFile(name)) {
            return GUIMediator.getStringResource("META_EDITOR_MP4_KIND_LABEL");
        }
        if (LimeXMLUtils.isOGGFile(name)) {
            return GUIMediator.getStringResource("META_EDITOR_OGG_KIND_LABEL");
        }
        return null;
    }

    public static LimeXMLDocument[] intersection(FileDesc[] fds, String schemaURI) {
        if (schemaURI != null) {
            schemaURI = schemaURI.toLowerCase(Locale.US);
        }
        HashMap map = new HashMap();
        block0: for (int i = 0; i < fds.length; ++i) {
            List docs = fds[i].getLimeXMLDocuments();
            if (docs.isEmpty()) {
                map.clear();
                break;
            }
            Iterator it = docs.iterator();
            while (it.hasNext()) {
                LimeXMLDocument doc = (LimeXMLDocument)it.next();
                String uri = doc.getSchemaURI().toLowerCase(Locale.US);
                if (schemaURI != null && !schemaURI.equals(uri)) continue;
                HashMap intersectionMap = (HashMap)map.get(uri);
                if (intersectionMap == null) {
                    intersectionMap = new HashMap();
                    map.put(uri, intersectionMap);
                }
                MetaEditorUtil.intersection(doc, intersectionMap);
                if (schemaURI == null) continue;
                continue block0;
            }
        }
        ArrayList<LimeXMLDocument> docs = new ArrayList<LimeXMLDocument>(map.size());
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String uri = (String)entry.getKey();
            Set intersection = MetaEditorUtil.clean((Map)entry.getValue()).entrySet();
            if (intersection.isEmpty()) continue;
            LimeXMLSchema schema = LimeXMLSchemaRepository.instance().getSchema(uri);
            if (schema == null) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("LimeXMLSchema for " + uri + " is null");
                continue;
            }
            boolean atLeastOneKnownFieldName = false;
            HashSet<String> fieldNames = new HashSet<String>(Arrays.asList(schema.getCanonicalizedFieldNames()));
            Iterator intr = intersection.iterator();
            while (intr.hasNext()) {
                entry = intr.next();
                if (!fieldNames.contains(entry.getKey()) || entry.getValue() == null) continue;
                atLeastOneKnownFieldName = true;
                break;
            }
            if (atLeastOneKnownFieldName) {
                docs.add(new LimeXMLDocument(intersection, uri));
                continue;
            }
            if (!LOG.isErrorEnabled()) continue;
            LOG.error("All fields of " + intersection + " are unknown for Schema " + schema);
        }
        return docs.toArray(new LimeXMLDocument[0]);
    }

    private static Map intersection(LimeXMLDocument doc, Map intersectionMap) {
        Set nameValueSet = doc.getNameValueSet();
        Iterator it = nameValueSet.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object current = intersectionMap.get(key);
            if (current == EMPTY_VALUE) continue;
            if (current == null || current.equals(value)) {
                intersectionMap.put(key, value);
                continue;
            }
            intersectionMap.put(key, EMPTY_VALUE);
        }
        HashSet keys = new HashSet(intersectionMap.keySet());
        keys.removeAll(doc.getNameSet());
        Iterator it2 = keys.iterator();
        while (it2.hasNext()) {
            intersectionMap.put(it2.next(), EMPTY_VALUE);
        }
        return intersectionMap;
    }

    private static Map clean(Map intersectionMap) {
        Iterator it = intersectionMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() != EMPTY_VALUE) continue;
            it.remove();
        }
        return intersectionMap;
    }

    public static LimeXMLDocument merge(LimeXMLDocument currentDoc, LimeXMLDocument newDoc) {
        Map.Entry entry;
        if (!currentDoc.getSchemaURI().equalsIgnoreCase(newDoc.getSchemaURI())) {
            throw new IllegalArgumentException("Current XML document and new XML document must be of the same type!");
        }
        HashMap map = new HashMap();
        Iterator it = currentDoc.getNameValueSet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            map.put(entry.getKey(), entry);
        }
        it = newDoc.getNameValueSet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            map.put(entry.getKey(), entry);
        }
        return new LimeXMLDocument(map.values(), currentDoc.getSchemaURI());
    }

    static {
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio", "META_EDITOR_AUDIO_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__title__", "META_EDITOR_TITLE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__artist__", "META_EDITOR_ARTIST_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__album__", "META_EDITOR_ALBUM_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__genre__", "META_EDITOR_GENRE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__year__", "META_EDITOR_YEAR_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__type__", "META_EDITOR_TYPE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__track__", "META_EDITOR_TRACK_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__language__", "META_EDITOR_LANGUAGE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__seconds__", "META_EDITOR_SECONDS_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__bitrate__", "META_EDITOR_BITRATE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__comments__", "META_EDITOR_COMMENTS_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__SHA1__", "META_EDITOR_SHA1_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__price__", "META_EDITOR_PRICE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__link__", "META_EDITOR_LINK_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__action__", "META_EDITOR_ACTION_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__license__", "META_EDITOR_LICENSE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video", "META_EDITOR_VIDEO_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__title__", "META_EDITOR_TITLE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__type__", "META_EDITOR_TYPE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__year__", "META_EDITOR_YEAR_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__rating__", "META_EDITOR_RATING_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__length__", "META_EDITOR_LENGTH_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__comments__", "META_EDITOR_COMMENTS_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__license__", "META_EDITOR_LICENSE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__licensetype__", "META_EDITOR_LICENSETYPE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__action__", "META_EDITOR_ACTION_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__director__", "META_EDITOR_DIRECTOR_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__studio__", "META_EDITOR_STUDIO_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__language__", "META_EDITOR_LANGUAGE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__stars__", "META_EDITOR_STARS_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__producer__", "META_EDITOR_PRODUCER_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__subtitles__", "META_EDITOR_SUBTITLES_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document", "META_EDITOR_DOCUMENT_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__title__", "META_EDITOR_TITLE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__topic__", "META_EDITOR_TOPIC_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__author__", "META_EDITOR_AUTHOR_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__license__", "META_EDITOR_LICENSE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__licensetype__", "META_EDITOR_LICENSETYPE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application", "META_EDITOR_APPLICATION_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__name__", "META_EDITOR_NAME_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__publisher__", "META_EDITOR_PUBLISHER_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__platform__", "META_EDITOR_PLATFORM_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__licensetype__", "META_EDITOR_LICENSETYPE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__license", "META_EDITOR_LICENSE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image", "META_EDITOR_IMAGE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__title__", "META_EDITOR_TITLE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__description__", "META_EDITOR_DESCRIPTION_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__artist__", "META_EDITOR_ARTIST_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__license__", "META_EDITOR_LICENSE_LABEL");
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__licensetype__", "META_EDITOR_LICENSETYPE_LABEL");
        EMPTY_VALUE = new Object();
    }
}

