/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IpPort;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class HandshakeResponse {
    public static final int OK = 200;
    public static final String OK_MESSAGE = "OK";
    public static final int CRAWLER_CODE = 593;
    public static final String CRAWLER_MESSAGE = "Hi";
    public static final int SHIELDED = 503;
    public static final int SLOTS_FULL = 503;
    public static final int DEFAULT_BAD_STATUS_CODE = 503;
    public static final String DEFAULT_BAD_STATUS_MESSAGE = "Service Not Available";
    public static final int LOCALE_NO_MATCH = 577;
    public static final String LOCALE_NO_MATCH_MESSAGE = "Service Not Available";
    private final int STATUS_CODE;
    private final String STATUS_MESSAGE;
    private final Properties HEADERS;
    private Boolean _supportsGGEP;
    private final boolean GOOD_LEAF;
    private final boolean GOOD_ULTRAPEER;
    private final int DEGREE;
    private final boolean HIGH_DEGREE;
    private final boolean ULTRAPEER_QRP;
    private final byte MAX_TTL;
    private final boolean DYNAMIC_QUERY;
    private final boolean ULTRAPEER;
    private final boolean LEAF;
    private final boolean DEFLATE_ENCODED;
    private final boolean PROBE_QUERIES;
    private final boolean PONG_CACHING;
    private final boolean GUESS_CAPABLE;
    private final boolean IS_CRAWLER;
    private final boolean IS_LIMEWIRE;
    private final boolean IS_OLD_LIMEWIRE;
    private final boolean NO_REQUERYING;
    private final String LOCALE_PREF;
    private final int LISTEN_PORT;
    private static final int NUM_X_TRY_ULTRAPEER_HOSTS = 10;
    private static final HandshakeResponse EMPTY_RESPONSE = new HandshakeResponse(new Properties());

    protected HandshakeResponse(Properties headers) {
        this(200, OK_MESSAGE, headers);
    }

    protected HandshakeResponse(int code, String message) {
        this(code, message, new Properties());
    }

    HandshakeResponse(int code, String message, Properties headers) {
        this.STATUS_CODE = code;
        this.STATUS_MESSAGE = message;
        this.HEADERS = headers;
        this.DEGREE = HandshakeResponse.extractIntHeaderValue(this.HEADERS, "X-Degree", 6);
        this.HIGH_DEGREE = this.getNumIntraUltrapeerConnections() >= 15;
        this.ULTRAPEER_QRP = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Ultrapeer-Query-Routing", 0.1f);
        this.MAX_TTL = HandshakeResponse.extractByteHeaderValue(this.HEADERS, "X-Max-TTL", (byte)4);
        this.DYNAMIC_QUERY = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Dynamic-Querying", 0.1f);
        this.PROBE_QUERIES = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Ext-Probes", 0.1f);
        this.NO_REQUERYING = HandshakeResponse.isFalseValue(this.HEADERS, "X-Requeries");
        this.IS_LIMEWIRE = HandshakeResponse.extractStringHeaderValue(headers, "User-Agent").toLowerCase().startsWith("limewire");
        this.GOOD_ULTRAPEER = this.isHighDegreeConnection() && this.isUltrapeerQueryRoutingConnection() && this.getMaxTTL() < 5 && this.isDynamicQueryConnection();
        this.GOOD_LEAF = this.GOOD_ULTRAPEER && (this.IS_LIMEWIRE || this.NO_REQUERYING);
        this.ULTRAPEER = HandshakeResponse.isTrueValue(this.HEADERS, "X-Ultrapeer");
        this.LEAF = HandshakeResponse.isFalseValue(this.HEADERS, "X-Ultrapeer");
        this.DEFLATE_ENCODED = HandshakeResponse.isStringValue(this.HEADERS, HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        this.PONG_CACHING = HandshakeResponse.isVersionOrHigher(headers, "Pong-Caching", 0.1f);
        this.GUESS_CAPABLE = HandshakeResponse.isVersionOrHigher(headers, "X-Guess", 0.1f);
        this.IS_CRAWLER = HandshakeResponse.isVersionOrHigher(headers, "Crawler", 0.1f);
        this.IS_OLD_LIMEWIRE = this.IS_LIMEWIRE && this.oldVersion(HandshakeResponse.extractStringHeaderValue(headers, "User-Agent"));
        String loc = HandshakeResponse.extractStringHeaderValue(headers, "X-Locale-Pref");
        this.LOCALE_PREF = loc.equals("") ? ApplicationSettings.DEFAULT_LOCALE.getValue() : loc;
        this.LISTEN_PORT = HandshakeResponse.extractIntHeaderValueAfter(headers, "Listen-IP", ":", -1);
    }

    private boolean oldVersion(String userAgent) {
        StringTokenizer tok = new StringTokenizer(userAgent, "/.");
        int major = -1;
        int minor = -1;
        boolean ret = false;
        boolean error = false;
        if (tok.countTokens() < 3) {
            return false;
        }
        try {
            String str = tok.nextToken();
            str = tok.nextToken();
            major = Integer.parseInt(str);
            str = tok.nextToken();
            minor = Integer.parseInt(str);
        }
        catch (NumberFormatException nfx) {
            error = true;
        }
        if (!error && (major < 3 || major == 3 && minor < 4)) {
            ret = true;
        }
        return ret;
    }

    public static HandshakeResponse createEmptyResponse() {
        return EMPTY_RESPONSE;
    }

    public static HandshakeResponse createResponse(Properties headers) {
        return new HandshakeResponse(headers);
    }

    public static HandshakeResponse createRemoteResponse(String line, Properties headers) throws IOException {
        int code = HandshakeResponse.extractCode(line);
        if (code == -1) {
            throw new IOException("could not parse status code: " + line);
        }
        String message = HandshakeResponse.extractMessage(line);
        if (message == null) {
            throw new IOException("could not parse status message: " + line);
        }
        return new HandshakeResponse(code, message, headers);
    }

    static HandshakeResponse createAcceptIncomingResponse(HandshakeResponse response, Properties headers) {
        return new HandshakeResponse(HandshakeResponse.addXTryHeader(response, headers));
    }

    static HandshakeResponse createAcceptOutgoingResponse(Properties headers) {
        return new HandshakeResponse(headers);
    }

    static HandshakeResponse createCrawlerResponse() {
        Properties headers = new Properties();
        headers.put("User-Agent", CommonUtils.getHttpServer());
        headers.put("X-Ultrapeer", "" + RouterService.isSupernode());
        List leaves = RouterService.getConnectionManager().getInitializedClientConnections();
        headers.put("Leaves", HandshakeResponse.createEndpointString(leaves, leaves.size()));
        List ultrapeers = RouterService.getConnectionManager().getInitializedConnections();
        headers.put("Peers", HandshakeResponse.createEndpointString(ultrapeers, ultrapeers.size()));
        return new HandshakeResponse(593, CRAWLER_MESSAGE, headers);
    }

    static HandshakeResponse createUltrapeerRejectIncomingResponse(HandshakeResponse hr, HandshakeStatus status) {
        return new HandshakeResponse(503, status.getMessage(), HandshakeResponse.addXTryHeader(hr, new Properties()));
    }

    static HandshakeResponse createRejectOutgoingResponse(HandshakeStatus status) {
        return new HandshakeResponse(503, status.getMessage(), new Properties());
    }

    static HandshakeResponse createLeafRejectIncomingResponse(HandshakeResponse hr, HandshakeStatus status) {
        return new HandshakeResponse(503, status.getMessage(), HandshakeResponse.addXTryHeader(hr, new Properties()));
    }

    static HandshakeResponse createLeafRejectOutgoingResponse(HandshakeStatus status) {
        return new HandshakeResponse(503, status.getMessage());
    }

    static HandshakeResponse createLeafRejectLocaleOutgoingResponse() {
        return new HandshakeResponse(577, "Service Not Available");
    }

    private static String createEndpointString(Collection hosts) {
        return HandshakeResponse.createEndpointString(hosts, 10);
    }

    private static String createEndpointString(Collection hosts, int limit) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = hosts.iterator();
        for (int i = 0; iter.hasNext() && i < limit; ++i) {
            IpPort host = (IpPort)iter.next();
            sb.append(host.getAddress());
            sb.append(":");
            sb.append(host.getPort());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static int extractCode(String line) {
        int statusMessageIndex = line.indexOf(" ");
        if (statusMessageIndex == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(line.substring(0, statusMessageIndex).trim());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String extractMessage(String line) {
        int statusMessageIndex = line.indexOf(" ");
        if (statusMessageIndex == -1) {
            return null;
        }
        return line.substring(statusMessageIndex).trim();
    }

    private static Properties addXTryHeader(HandshakeResponse hr, Properties headers) {
        Collection hosts = RouterService.getPreferencedHosts(hr.isUltrapeer(), hr.getLocalePref(), 10);
        headers.put("X-Try-Ultrapeers", HandshakeResponse.createEndpointString(hosts));
        return headers;
    }

    public int getStatusCode() {
        return this.STATUS_CODE;
    }

    public String getStatusMessage() {
        return this.STATUS_MESSAGE;
    }

    public boolean notOKStatusCode() {
        return this.STATUS_CODE != 200;
    }

    public boolean isAccepted() {
        return this.STATUS_CODE == 200;
    }

    public String getStatusLine() {
        return new String(this.STATUS_CODE + " " + this.STATUS_MESSAGE);
    }

    public Properties props() {
        return this.HEADERS;
    }

    public String getProperty(String prop) {
        return this.HEADERS.getProperty(prop);
    }

    public String getUserAgent() {
        return this.HEADERS.getProperty("User-Agent");
    }

    public byte getMaxTTL() {
        return this.MAX_TTL;
    }

    public String getXTryUltrapeers() {
        return HandshakeResponse.extractStringHeaderValue(this.HEADERS, "X-Try-Ultrapeers");
    }

    public boolean hasXTryUltrapeers() {
        return HandshakeResponse.headerExists(this.HEADERS, "X-Try-Ultrapeers");
    }

    public boolean hasLeafGuidance() {
        return HandshakeResponse.isFalseValue(this.HEADERS, "X-Ultrapeer-Needed");
    }

    public int getNumIntraUltrapeerConnections() {
        return this.DEGREE;
    }

    public boolean isHighDegreeConnection() {
        return this.HIGH_DEGREE;
    }

    public boolean isLimeWire() {
        return this.IS_LIMEWIRE;
    }

    public boolean isOldLimeWire() {
        return this.IS_OLD_LIMEWIRE;
    }

    public boolean isGoodLeaf() {
        return this.GOOD_LEAF;
    }

    public boolean isDeflateEnabled() {
        return this.DEFLATE_ENCODED;
    }

    public boolean isDeflateAccepted() {
        return ConnectionSettings.ENCODE_DEFLATE.getValue() && HandshakeResponse.containsStringValue(this.HEADERS, HeaderNames.ACCEPT_ENCODING, HeaderNames.DEFLATE_VALUE);
    }

    public boolean isGoodUltrapeer() {
        return this.GOOD_ULTRAPEER;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return this.ULTRAPEER_QRP;
    }

    public boolean isLeaf() {
        return this.LEAF;
    }

    public boolean isUltrapeer() {
        return this.ULTRAPEER;
    }

    public boolean isGUESSCapable() {
        return this.GUESS_CAPABLE;
    }

    public boolean isGUESSUltrapeer() {
        return this.isGUESSCapable() && this.isUltrapeer();
    }

    public boolean isTempConnection() {
        String value = this.HEADERS.getProperty("X-Temp-Connection");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public boolean supportsGGEP() {
        if (this._supportsGGEP == null) {
            String value = this.HEADERS.getProperty("GGEP");
            this._supportsGGEP = new Boolean(value != null);
        }
        return this._supportsGGEP;
    }

    public float supportsVendorMessages() {
        String value = this.HEADERS.getProperty("Vendor-Message");
        if (value != null && !value.equals("")) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public boolean supportsPongCaching() {
        return this.PONG_CACHING;
    }

    public String getVersion() {
        return this.HEADERS.getProperty("X-Version");
    }

    public boolean isQueryRoutingEnabled() {
        return HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Query-Routing", 0.1f);
    }

    public boolean isDynamicQueryConnection() {
        return this.DYNAMIC_QUERY;
    }

    public boolean supportsProbeQueries() {
        return this.PROBE_QUERIES;
    }

    public boolean isCrawler() {
        return this.IS_CRAWLER;
    }

    public String getLocalePref() {
        return this.LOCALE_PREF;
    }

    public int getListeningPort() {
        return this.LISTEN_PORT;
    }

    private static boolean headerExists(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        return value != null;
    }

    private static boolean isTrueValue(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    private static boolean isFalseValue(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("false");
    }

    private static boolean isStringValue(Properties headers, String headerName, String headerValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase(headerValue);
    }

    private static boolean containsStringValue(Properties headers, String headerName, String headerValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        if (value.equalsIgnoreCase(headerValue)) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase(headerValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVersionOrHigher(Properties headers, String headerName, float minVersion) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        try {
            Float f = new Float(value);
            return f.floatValue() >= minVersion;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static int extractIntHeaderValue(Properties headers, String headerName, int defaultValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static int extractIntHeaderValueAfter(Properties headers, String headerName, String token, int defaultValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return defaultValue;
        }
        int idx = value.indexOf(token) + 1;
        if (idx == 0 || idx == value.length()) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value.substring(idx));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static byte extractByteHeaderValue(Properties headers, String headerName, byte defaultValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Byte.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static String extractStringHeaderValue(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return "";
        }
        return value;
    }

    public String toString() {
        return "<" + this.STATUS_CODE + ", " + this.STATUS_MESSAGE + ">" + this.HEADERS;
    }
}

