/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeSupport;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.http.WriteHeadersIOState;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.statistics.HandshakingStat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Properties;

public abstract class WriteHandshakeState
extends WriteHeadersIOState {
    protected final HandshakeSupport support;

    protected WriteHandshakeState(HandshakeSupport support) {
        super(BandwidthStat.GNUTELLA_HEADER_UPSTREAM_BANDWIDTH);
        this.support = support;
    }

    static class WriteRequestState
    extends WriteHandshakeState {
        private Properties request;

        WriteRequestState(HandshakeSupport support, Properties request) {
            super(support);
            this.request = request;
        }

        protected ByteBuffer createOutgoingData() {
            StringBuffer sb = new StringBuffer();
            this.support.appendConnectLine(sb);
            this.support.appendHeaders(this.request, sb);
            return ByteBuffer.wrap(sb.toString().getBytes());
        }

        protected void processWrittenHeaders() {
        }
    }

    static class WriteResponseState
    extends WriteHandshakeState {
        private HandshakeResponder responder;
        private HandshakeResponse response;
        private boolean outgoing;

        WriteResponseState(HandshakeSupport support, HandshakeResponder responder, boolean outgoing) {
            super(support);
            this.responder = responder;
            this.outgoing = outgoing;
        }

        protected ByteBuffer createOutgoingData() throws IOException {
            HandshakeResponse theirResponse = this.outgoing ? this.support.getReadHandshakeRemoteResponse() : this.support.getReadHandshakeResponse();
            this.response = this.responder.respond(theirResponse, this.outgoing);
            StringBuffer sb = new StringBuffer();
            this.support.appendResponse(this.response, sb);
            return ByteBuffer.wrap(sb.toString().getBytes());
        }

        protected void processWrittenHeaders() throws IOException {
            block10: {
                block9: {
                    if (!this.outgoing) break block9;
                    switch (this.response.getStatusCode()) {
                        case 200: {
                            HandshakingStat.SUCCESSFUL_OUTGOING.incrementStat();
                            break block10;
                        }
                        case 503: {
                            HandshakingStat.OUTGOING_CLIENT_REJECT.incrementStat();
                            throw NoGnutellaOkException.CLIENT_REJECT;
                        }
                        case 577: {
                            throw NoGnutellaOkException.CLIENT_REJECT_LOCALE;
                        }
                        default: {
                            HandshakingStat.OUTGOING_CLIENT_UNKNOWN.incrementStat();
                            throw NoGnutellaOkException.createClientUnknown(this.response.getStatusCode());
                        }
                    }
                }
                switch (this.response.getStatusCode()) {
                    case 200: 
                    case 593: {
                        break;
                    }
                    case 503: {
                        HandshakingStat.INCOMING_CLIENT_REJECT.incrementStat();
                        throw NoGnutellaOkException.CLIENT_REJECT;
                    }
                    default: {
                        HandshakingStat.INCOMING_CLIENT_UNKNOWN.incrementStat();
                        throw NoGnutellaOkException.createClientUnknown(this.response.getStatusCode());
                    }
                }
            }
        }
    }
}

