/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.DirectByteBufferCache;
import com.limegroup.gnutella.io.HeapByteBufferCache;
import java.nio.ByteBuffer;

public class ByteBufferCache {
    private final DirectByteBufferCache DIRECT = new DirectByteBufferCache();
    private final HeapByteBufferCache HEAP = new HeapByteBufferCache();

    public ByteBuffer getDirect() {
        return this.DIRECT.get();
    }

    public ByteBuffer getHeap() {
        return this.HEAP.get();
    }

    public ByteBuffer getHeap(int size) {
        return this.HEAP.get(size);
    }

    public long getHeapCacheSize() {
        return this.HEAP.getByteSize();
    }

    public void release(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            this.DIRECT.put(buffer);
        } else {
            this.HEAP.put(buffer);
        }
    }

    public void clearCache() {
        this.DIRECT.clear();
        this.HEAP.clear();
    }
}

