/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.io.AcceptChannelObserver;
import com.limegroup.gnutella.io.ByteBufferCache;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.IOErrorObserver;
import com.limegroup.gnutella.io.NBThrottle;
import com.limegroup.gnutella.io.ReadObserver;
import com.limegroup.gnutella.io.ReadTimeout;
import com.limegroup.gnutella.io.ReadWriteObserver;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.TimeoutController;
import com.limegroup.gnutella.io.Timeoutable;
import com.limegroup.gnutella.io.WriteObserver;
import com.limegroup.gnutella.util.ManagedThread;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NIODispatcher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(NIODispatcher.class);
    private static final NIODispatcher INSTANCE = new NIODispatcher();
    private static final long SPIN_AMOUNT = 5000L;
    private static final int MAX_IGNORES = 5;
    private static final long CACHE_CLEAR_INTERVAL = 30000L;
    private final Thread dispatchThread;
    private final Object Q_LOCK = new Object();
    private final Map OTHER_SELECTORS = new HashMap();
    private final List POLLERS = new ArrayList();
    private Collection LATER = new LinkedList();
    private final List THROTTLE = new ArrayList();
    private final TimeoutController TIMEOUTER = new TimeoutController();
    private final ByteBufferCache BUFFER_CACHE = new ByteBufferCache();
    private Selector primarySelector = null;
    private long iteration = 0L;
    private volatile boolean wokeup = false;
    private long lastCacheClearTime;

    public static final NIODispatcher instance() {
        return INSTANCE;
    }

    private NIODispatcher() {
        boolean failed = false;
        try {
            this.primarySelector = Selector.open();
        }
        catch (IOException iox) {
            failed = true;
        }
        if (!failed) {
            this.dispatchThread = new ManagedThread(this, "NIODispatcher");
            this.dispatchThread.start();
        } else {
            this.dispatchThread = null;
        }
    }

    public boolean isRunning() {
        return this.dispatchThread != null;
    }

    public boolean isDispatchThread() {
        return Thread.currentThread() == this.dispatchThread;
    }

    public ByteBufferCache getBufferCache() {
        return this.BUFFER_CACHE;
    }

    public int getNumPendingTimeouts() {
        return this.TIMEOUTER.getNumPendingTimeouts();
    }

    public void addThrottle(final NBThrottle t) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.THROTTLE.add(t);
        } else {
            this.invokeLater(new Runnable(){

                public void run() {
                    NIODispatcher.this.THROTTLE.add(t);
                }
            });
        }
    }

    public void register(SelectableChannel channel, IOErrorObserver attachment) {
        this.register(channel, attachment, 0, 0);
    }

    public void registerAccept(SelectableChannel channel, AcceptChannelObserver attachment) {
        this.register(channel, attachment, 16, 0);
    }

    public void registerConnect(SelectableChannel channel, ConnectObserver attachment, int timeout) {
        this.register(channel, attachment, 8, timeout);
    }

    public void registerRead(SelectableChannel channel, ReadObserver attachment) {
        this.register(channel, attachment, 1, 0);
    }

    public void registerWrite(SelectableChannel channel, WriteObserver attachment) {
        this.register(channel, attachment, 4, 0);
    }

    public void registerReadWrite(SelectableChannel channel, ReadWriteObserver attachment) {
        this.register(channel, attachment, 5, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(SelectableChannel channel, IOErrorObserver handler, int op, int timeout) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.registerImpl(this.getSelectorFor(channel), channel, op, handler, timeout);
        } else {
            Object object = this.Q_LOCK;
            synchronized (object) {
                this.LATER.add(new RegisterOp(channel, handler, op, timeout));
            }
            this.wakeup();
        }
    }

    public void interestWrite(SelectableChannel channel, boolean on) {
        this.interest(channel, 4, on);
    }

    public void interestRead(SelectableChannel channel, boolean on) {
        this.interest(channel, 1, on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interest(SelectableChannel channel, int op, boolean on) {
        block9: {
            try {
                int oldOps;
                Selector sel = this.getSelectorFor(channel);
                SelectionKey sk = channel.keyFor(sel);
                if (sk == null || !sk.isValid()) break block9;
                Object object = sk.attachment();
                synchronized (object) {
                    if ((op & 1) == 1) {
                        ((Attachment)sk.attachment()).changeReadStatus(on);
                    }
                    oldOps = sk.interestOps();
                    if (on) {
                        sk.interestOps(oldOps | op);
                    } else {
                        sk.interestOps(oldOps & ~op);
                    }
                }
                if (on && (oldOps & op) != op) {
                    this.wakeup();
                }
            }
            catch (CancelledKeyException ignored) {
                // empty catch block
            }
        }
    }

    private Selector getSelectorFor(SelectableChannel channel) {
        Selector sel = (Selector)this.OTHER_SELECTORS.get(channel.getClass());
        if (sel == null) {
            return this.primarySelector;
        }
        return sel;
    }

    public void shutdown(Shutdownable handler) {
        handler.shutdown();
    }

    public void attach(SelectionKey key, IOErrorObserver attachment) {
        key.attach(new Attachment(attachment));
    }

    public void registerSelector(final Selector newSelector, final Class channelClass) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.POLLERS.add(newSelector);
            this.OTHER_SELECTORS.put(channelClass, newSelector);
        } else {
            this.invokeLater(new Runnable(){

                public void run() {
                    NIODispatcher.this.POLLERS.add(newSelector);
                    NIODispatcher.this.OTHER_SELECTORS.put(channelClass, newSelector);
                }
            });
        }
    }

    public void removeSelector(final Selector selector) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.POLLERS.remove(selector);
            this.OTHER_SELECTORS.remove(selector);
        } else {
            this.invokeLater(new Runnable(){

                public void run() {
                    NIODispatcher.this.POLLERS.remove(selector);
                    NIODispatcher.this.OTHER_SELECTORS.remove(selector);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runner) {
        if (Thread.currentThread() == this.dispatchThread) {
            runner.run();
        } else {
            Object object = this.Q_LOCK;
            synchronized (object) {
                this.LATER.add(runner);
            }
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeReallyLater(Runnable runner) {
        Object object = this.Q_LOCK;
        synchronized (object) {
            this.LATER.add(runner);
        }
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(final Runnable future) throws InterruptedException {
        if (Thread.currentThread() == this.dispatchThread) {
            future.run();
        } else {
            Runnable waiter;
            Runnable runnable = waiter = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    future.run();
                    4 var1_1 = this;
                    synchronized (var1_1) {
                        this.notify();
                    }
                }
            };
            synchronized (runnable) {
                Object object = this.Q_LOCK;
                synchronized (object) {
                    this.LATER.add(waiter);
                }
                this.wakeup();
                waiter.wait();
            }
        }
    }

    public IOErrorObserver attachment(Object proxyAttachment) {
        return ((Attachment)proxyAttachment).attachment;
    }

    private void cancel(SelectionKey sk, Shutdownable handler) {
        sk.cancel();
        if (handler != null) {
            handler.shutdown();
        }
    }

    private void processAccept(long now, SelectionKey sk, AcceptChannelObserver handler, Attachment proxy) throws IOException {
        ServerSocketChannel ssc;
        SocketChannel channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling accept: " + handler);
        }
        if ((channel = (ssc = (ServerSocketChannel)sk.channel()).accept()) == null) {
            return;
        }
        if (channel.isOpen()) {
            channel.configureBlocking(false);
            handler.handleAcceptChannel(channel);
        } else {
            try {
                channel.close();
            }
            catch (IOException err) {
                LOG.error("SocketChannel.close()", err);
            }
        }
    }

    private void processConnect(long now, SelectionKey sk, ConnectObserver handler, Attachment proxy) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling connect: " + handler);
        }
        SocketChannel channel = (SocketChannel)sk.channel();
        proxy.clearTimeout();
        boolean finished = channel.finishConnect();
        if (finished) {
            sk.interestOps(0);
            handler.handleConnect(channel.socket());
        } else {
            this.cancel(sk, handler);
        }
    }

    private void processRead(long now, ReadObserver handler, Attachment proxy) throws IOException {
        proxy.updateReadTimeout(now);
        handler.handleRead();
    }

    private void processWrite(long now, WriteObserver handler, Attachment proxy) throws IOException {
        handler.handleWrite();
    }

    private void registerImpl(Selector selector, SelectableChannel channel, int op, IOErrorObserver attachment, int timeout) {
        try {
            Attachment guard = new Attachment(attachment);
            SelectionKey key = channel.register(selector, op, guard);
            guard.setKey(key);
            if (timeout != 0) {
                guard.addTimeout(System.currentTimeMillis(), timeout);
            } else if ((op & 1) != 0) {
                guard.changeReadStatus(true);
            }
        }
        catch (IOException iox) {
            attachment.handleIOException(iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPendingTasks() {
        Collection localLater;
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.THROTTLE.size(); ++i) {
            ((NBThrottle)this.THROTTLE.get(i)).tick(now);
        }
        Object object = this.Q_LOCK;
        synchronized (object) {
            localLater = this.LATER;
            this.LATER = new LinkedList();
        }
        if (now > this.lastCacheClearTime + 30000L) {
            this.BUFFER_CACHE.clearCache();
            this.lastCacheClearTime = now;
        }
        if (!localLater.isEmpty()) {
            Iterator i = localLater.iterator();
            while (i.hasNext()) {
                Runnable item = (Runnable)i.next();
                try {
                    item.run();
                }
                catch (Throwable t) {
                    LOG.error(t);
                    ErrorService.error(t);
                }
            }
        }
    }

    private Collection pollOtherSelectors() {
        Set<SelectionKey> ret = null;
        boolean growable = false;
        for (int i = 0; i < this.POLLERS.size(); ++i) {
            Set<SelectionKey> selected;
            Selector sel = (Selector)this.POLLERS.get(i);
            int n = 0;
            try {
                n = sel.selectNow();
            }
            catch (IOException iox) {
                LOG.error("Error performing secondary select", iox);
            }
            if (n == 0 || (selected = sel.selectedKeys()).isEmpty()) continue;
            if (ret == null) {
                ret = selected;
                continue;
            }
            if (!growable) {
                growable = true;
                ret = new HashSet<SelectionKey>(ret);
                ret.addAll(selected);
                continue;
            }
            ret.addAll(selected);
        }
        return ret == null ? Collections.EMPTY_SET : ret;
    }

    private void readyThrottles(Collection keys) {
        for (int i = 0; i < this.THROTTLE.size(); ++i) {
            ((NBThrottle)this.THROTTLE.get(i)).selectableKeys(keys);
        }
    }

    private void wakeup() {
        if (!this.wokeup && Thread.currentThread() != this.dispatchThread) {
            this.wokeup = true;
            this.primarySelector.wakeup();
        }
    }

    private void process() throws ProcessingException, SpinningException {
        boolean checkTime = false;
        long startSelect = -1L;
        int zeroes = 0;
        int ignores = 0;
        while (true) {
            Set<SelectionKey> allKeys;
            this.runPendingTasks();
            Collection polled = this.pollOtherSelectors();
            boolean immediate = !polled.isEmpty();
            try {
                if (!immediate && checkTime) {
                    startSelect = System.currentTimeMillis();
                }
                if (!immediate) {
                    this.primarySelector.select(100L);
                } else {
                    this.primarySelector.selectNow();
                }
            }
            catch (NullPointerException err) {
                LOG.warn("npe", err);
                continue;
            }
            catch (CancelledKeyException err) {
                LOG.warn("cancelled", err);
                continue;
            }
            catch (IOException iox) {
                throw new ProcessingException(iox);
            }
            Set<SelectionKey> keys = this.primarySelector.selectedKeys();
            if (!immediate && !this.wokeup) {
                if (keys.isEmpty()) {
                    long now = System.currentTimeMillis();
                    if (startSelect == -1L) {
                        LOG.trace("No keys selected, starting spin check.");
                        checkTime = true;
                    } else if (startSelect + 30L >= now) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Spinning detected, current spins: " + zeroes);
                        }
                        if ((long)zeroes++ > 5000L) {
                            throw new SpinningException();
                        }
                    } else {
                        checkTime = false;
                        startSelect = -1L;
                        zeroes = 0;
                        ignores = 0;
                    }
                    this.TIMEOUTER.processTimeouts(now);
                    continue;
                }
                if (checkTime && ++ignores > 5) {
                    checkTime = false;
                    zeroes = 0;
                    startSelect = -1L;
                    ignores = 0;
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Selected keys: (" + keys.size() + "), polled: (" + polled.size() + ").");
            }
            if (immediate) {
                allKeys = new HashSet<SelectionKey>(keys.size() + polled.size());
                allKeys.addAll(keys);
                allKeys.addAll(polled);
            } else {
                allKeys = keys;
            }
            this.readyThrottles(allKeys);
            long now = System.currentTimeMillis();
            Iterator it = allKeys.iterator();
            while (it.hasNext()) {
                SelectionKey sk = (SelectionKey)it.next();
                this.process(now, sk, sk.attachment(), 65535);
            }
            keys.clear();
            ++this.iteration;
            this.TIMEOUTER.processTimeouts(now);
            this.wokeup = false;
        }
    }

    void process(long now, SelectionKey sk, Object proxyAttachment, int allowedOps) {
        Attachment proxy = (Attachment)proxyAttachment;
        IOErrorObserver attachment = proxy.attachment;
        if (proxy.lastMod <= this.iteration) {
            proxy.handled = 0;
        }
        proxy.lastMod = this.iteration + 1L;
        if (sk.isValid()) {
            try {
                try {
                    int notHandled = ~proxy.handled;
                    int readyOps = sk.readyOps();
                    if ((allowedOps & readyOps & notHandled & 0x10) != 0) {
                        this.processAccept(now, sk, (AcceptChannelObserver)attachment, proxy);
                        proxy.handled |= 16;
                    } else if ((allowedOps & readyOps & notHandled & 8) != 0) {
                        this.processConnect(now, sk, (ConnectObserver)attachment, proxy);
                        proxy.handled |= 8;
                    } else {
                        if ((allowedOps & readyOps & notHandled & 1) != 0) {
                            this.processRead(now, (ReadObserver)attachment, proxy);
                            proxy.handled |= 1;
                        }
                        if ((allowedOps & readyOps & notHandled & 4) != 0) {
                            this.processWrite(now, (WriteObserver)attachment, proxy);
                            proxy.handled |= 4;
                        }
                    }
                }
                catch (CancelledKeyException err) {
                    LOG.warn("Ignoring cancelled key", err);
                }
                catch (IOException iox) {
                    LOG.warn("IOX processing", iox);
                    try {
                        sk.cancel();
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                    attachment.handleIOException(iox);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t, "Unhandled exception while dispatching");
                this.safeCancel(sk, attachment);
            }
        } else {
            if (LOG.isErrorEnabled()) {
                LOG.error("SelectionKey cancelled for: " + attachment);
            }
            this.safeCancel(sk, attachment);
        }
    }

    private void safeCancel(SelectionKey sk, Shutdownable attachment) {
        try {
            this.cancel(sk, attachment);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void swapSelector() {
        Selector oldSelector = this.primarySelector;
        Set<SelectionKey> oldKeys = Collections.EMPTY_SET;
        try {
            if (oldSelector != null) {
                oldKeys = oldSelector.keys();
            }
        }
        catch (ClosedSelectorException ignored) {
            LOG.warn("error getting keys", ignored);
        }
        try {
            this.primarySelector = Selector.open();
        }
        catch (IOException iox) {
            LOG.error("Can't make a new selector!!!", iox);
            throw new RuntimeException(iox);
        }
        Iterator i = oldKeys.iterator();
        while (i.hasNext()) {
            try {
                SelectionKey key = (SelectionKey)i.next();
                SelectableChannel channel = key.channel();
                Attachment attachment = (Attachment)key.attachment();
                int ops = key.interestOps();
                try {
                    SelectionKey newKey = channel.register(this.primarySelector, ops, attachment);
                    attachment.setKey(newKey);
                }
                catch (IOException iox) {
                    attachment.attachment.handleIOException(iox);
                }
            }
            catch (CancelledKeyException ignored) {
                LOG.warn("key cancelled while swapping", ignored);
            }
        }
        try {
            if (oldSelector != null) {
                oldSelector.close();
            }
        }
        catch (IOException ignored) {
            LOG.warn("error closing old selector", ignored);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.primarySelector == null) {
                        this.primarySelector = Selector.open();
                    }
                    this.process();
                }
            }
            catch (SpinningException spin) {
                LOG.warn("selector is spinning!", spin);
                this.swapSelector();
                continue;
            }
            catch (ProcessingException uhoh) {
                LOG.warn("unknown exception while selecting", uhoh);
                this.swapSelector();
                continue;
            }
            catch (IOException iox) {
                LOG.error("Unable to create a new Selector!!!", iox);
                throw new RuntimeException(iox);
            }
            catch (Throwable err) {
                LOG.error("Error in Selector!", err);
                ErrorService.error(err);
                this.swapSelector();
                continue;
            }
            break;
        }
    }

    private static class ProcessingException
    extends Exception {
        public ProcessingException() {
        }

        public ProcessingException(Throwable t) {
            super(t);
        }
    }

    private static class SpinningException
    extends Exception {
    }

    private class RegisterOp
    implements Runnable {
        private final SelectableChannel channel;
        private final IOErrorObserver handler;
        private final int op;
        private final int timeout;

        RegisterOp(SelectableChannel channel, IOErrorObserver handler, int op, int timeout) {
            this.channel = channel;
            this.handler = handler;
            this.op = op;
            this.timeout = timeout;
        }

        public void run() {
            NIODispatcher.this.registerImpl(NIODispatcher.this.getSelectorFor(this.channel), this.channel, this.op, this.handler, this.timeout);
        }
    }

    class Attachment
    implements Timeoutable {
        private final IOErrorObserver attachment;
        private long lastMod;
        private int handled;
        private SelectionKey key;
        private boolean timeoutActive = false;
        private long storedTimeoutLength = Long.MAX_VALUE;
        private long storedExpireTime = Long.MAX_VALUE;

        Attachment(IOErrorObserver attachment) {
            this.attachment = attachment;
        }

        public String toString() {
            return "Attachment for: " + this.attachment;
        }

        synchronized void clearTimeout() {
            this.timeoutActive = false;
        }

        synchronized void updateReadTimeout(long now) {
            if (this.attachment instanceof ReadTimeout) {
                long timeoutLength = ((ReadTimeout)((Object)this.attachment)).getReadTimeout();
                if (timeoutLength != 0L) {
                    long expireTime = now + timeoutLength;
                    if (expireTime < this.storedExpireTime || this.storedExpireTime == -1L || this.storedExpireTime < now) {
                        this.addTimeout(now, timeoutLength);
                    } else {
                        this.storedExpireTime = expireTime;
                        this.storedTimeoutLength = timeoutLength;
                        this.timeoutActive = true;
                    }
                } else {
                    this.clearTimeout();
                }
            }
        }

        synchronized void changeReadStatus(boolean reading) {
            if (reading) {
                this.updateReadTimeout(System.currentTimeMillis());
            } else {
                this.clearTimeout();
            }
        }

        synchronized void addTimeout(long now, long timeoutLength) {
            this.timeoutActive = true;
            this.storedTimeoutLength = timeoutLength;
            this.storedExpireTime = now + timeoutLength;
            NIODispatcher.this.TIMEOUTER.addTimeout(this, now, timeoutLength);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyTimeout(long now, long expireTime, long timeoutLength) {
            boolean cancel = false;
            long timeToUse = 0L;
            Attachment attachment = this;
            synchronized (attachment) {
                if (this.timeoutActive) {
                    if (expireTime == this.storedExpireTime) {
                        cancel = true;
                        this.timeoutActive = false;
                        timeToUse = this.storedTimeoutLength;
                        this.storedExpireTime = -1L;
                    } else if (expireTime < this.storedExpireTime) {
                        NIODispatcher.this.TIMEOUTER.addTimeout(this, now, this.storedExpireTime - now);
                    } else {
                        this.storedExpireTime = -1L;
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Ignoring extra timeout for: " + this.attachment);
                        }
                    }
                } else {
                    this.storedExpireTime = -1L;
                    this.storedTimeoutLength = -1L;
                }
            }
            if (cancel) {
                NIODispatcher.this.cancel(this.key, this.attachment);
                this.attachment.handleIOException(new SocketTimeoutException("operation timed out (" + timeToUse + ")"));
            }
        }

        public void setKey(SelectionKey key) {
            this.key = key;
        }
    }
}

