/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.AbstractNBSocket;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.SocketInterestReadAdapter;
import com.limegroup.gnutella.io.SocketInterestWriteAdapter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;

public class NIOSocket
extends AbstractNBSocket {
    private final SocketChannel channel;
    private final Socket socket;
    private InetAddress connectedTo;
    private int port;

    NIOSocket(Socket s) {
        this.channel = s.getChannel();
        this.socket = s;
        this.setInitialReader();
        this.setInitialWriter();
        NIODispatcher.instance().register(this.channel, this);
        this.connectedTo = s.getInetAddress();
        this.port = s.getPort();
    }

    public NIOSocket() throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.init();
        this.setInitialReader();
        this.setInitialWriter();
    }

    public NIOSocket(InetAddress addr, int port) throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.init();
        this.setInitialReader();
        this.setInitialWriter();
        this.connect(new InetSocketAddress(addr, port));
    }

    public NIOSocket(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.init();
        this.setInitialReader();
        this.setInitialWriter();
        this.bind(new InetSocketAddress(localAddr, localPort));
        this.connect(new InetSocketAddress(addr, port));
    }

    public NIOSocket(String addr, int port) throws UnknownHostException, IOException {
        this(InetAddress.getByName(addr), port);
    }

    public NIOSocket(String addr, int port, InetAddress localAddr, int localPort) throws IOException {
        this(InetAddress.getByName(addr), port, localAddr, localPort);
    }

    private void init() throws IOException {
        this.channel.configureBlocking(false);
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.socket.bind(endpoint);
    }

    public boolean connect(SocketAddress addr, int timeout, ConnectObserver observer) {
        InetSocketAddress a = (InetSocketAddress)addr;
        this.connectedTo = a.getAddress();
        this.port = a.getPort();
        return super.connect(addr, timeout, observer);
    }

    public InetAddress getInetAddress() {
        return this.connectedTo;
    }

    public int getPort() {
        return this.port;
    }

    protected InterestReadChannel getBaseReadChannel() {
        return new SocketInterestReadAdapter(this.channel);
    }

    protected InterestWriteChannel getBaseWriteChannel() {
        return new SocketInterestWriteAdapter(this.channel);
    }

    protected void shutdownImpl() {
        try {
            this.shutdownInput();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            this.shutdownOutput();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException ignored) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public InetAddress getLocalAddress() {
        try {
            return this.socket.getLocalAddress();
        }
        catch (Error osxSucks) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                return null;
            }
        }
        catch (UnsupportedAddressTypeException uate) {
            SocketAddress localAddr = this.socket.getLocalSocketAddress();
            throw new RuntimeException("wrong address type: " + (localAddr == null ? null : localAddr.getClass()), uate);
        }
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public void sendUrgentData(int data) {
        throw new UnsupportedOperationException("No urgent data.");
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public String toString() {
        return "NIOSocket::" + this.connectedTo + ", channel: " + this.channel.toString();
    }
}

