/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.AbstractLicense;
import com.limegroup.gnutella.licenses.CCConstants;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseCache;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CCLicense
extends AbstractLicense {
    private static final Log LOG = LogFactory.getLog(CCLicense.class);
    private static final long serialVersionUID = 8213994964631107858L;
    private transient String license;
    private Map allWorks;

    CCLicense(String license, URI uri) {
        super(uri);
        this.license = license;
    }

    public String getLicense() {
        return this.license;
    }

    public URL getLicenseDeed(URN urn) {
        Details details = this.getDetails(urn);
        if (details == null || details.licenseURL == null) {
            return this.guessLicenseDeed();
        }
        return details.licenseURL;
    }

    private URL guessLicenseDeed() {
        return CCConstants.guessLicenseDeed(this.license);
    }

    public boolean isValid(URN urn) {
        return this.getDetails(urn) != null;
    }

    public License copy(String license, URI licenseURI) {
        CCLicense newL = null;
        try {
            newL = (CCLicense)this.clone();
            newL.license = license;
            newL.licenseLocation = licenseURI;
        }
        catch (CloneNotSupportedException error) {
            ErrorService.error(error);
        }
        return newL;
    }

    public String getLicenseDescription(URN urn) {
        Iterator i;
        List permitted = Collections.EMPTY_LIST;
        List prohibited = Collections.EMPTY_LIST;
        List required = Collections.EMPTY_LIST;
        Details details = this.getDetails(urn);
        if (details != null) {
            permitted = details.permitted;
            prohibited = details.prohibited;
            required = details.required;
        }
        StringBuffer sb = new StringBuffer();
        if (permitted != null && !permitted.isEmpty()) {
            sb.append("Permitted: ");
            i = permitted.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        if (prohibited != null && !prohibited.isEmpty()) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append("Prohibited: ");
            i = prohibited.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        if (required != null && !required.isEmpty()) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append("Required: ");
            i = required.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        if (sb.length() == 0) {
            sb.append("Permissions unknown.");
        }
        return sb.toString();
    }

    protected void clear() {
        if (this.allWorks != null) {
            this.allWorks.clear();
        }
    }

    protected String getBody(String url) {
        return this.locateRDF(super.getBody(url));
    }

    private void addWork(URN urn, String licenseURL) {
        URL url = null;
        try {
            url = new URL(licenseURL);
        }
        catch (MalformedURLException murl) {
            LOG.warn("Unable to make licenseURL out of: " + licenseURL, murl);
        }
        Details details = this.getDetails(urn);
        if (details != null) {
            URL guessed;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found existing details item for URN: " + urn);
            }
            if (url != null && (guessed = this.guessLicenseDeed()) != null && guessed.equals(url)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating license URL to be: " + url);
                }
                details.licenseURL = url;
            }
            return;
        }
        details = new Details(url);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding new " + details + " for urn: " + urn);
        }
        if (this.allWorks == null) {
            this.allWorks = new HashMap(1);
        }
        this.allWorks.put(urn, details);
    }

    private Details getDetails(URN urn) {
        if (this.allWorks == null) {
            return null;
        }
        Details details = (Details)this.allWorks.get(urn);
        if (details != null) {
            return details;
        }
        if (urn != null) {
            return (Details)this.allWorks.get(null);
        }
        return (Details)this.allWorks.values().iterator().next();
    }

    private List getDetailsForLicenseURL(URL url) {
        if (this.allWorks == null || url == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Details> details = new LinkedList<Details>();
        Iterator i = this.allWorks.values().iterator();
        while (i.hasNext()) {
            Details detail = (Details)i.next();
            if (detail.licenseURL == null || !url.equals(detail.licenseURL)) continue;
            details.add(detail);
        }
        return details;
    }

    private String locateRDF(String body) {
        if (body == null || body.trim().equals("")) {
            return null;
        }
        int startRDF = body.indexOf("<rdf:RDF");
        if (startRDF >= body.length() - 1) {
            return null;
        }
        int endRDF = body.indexOf("rdf:RDF", startRDF + 6);
        if (startRDF == -1 || endRDF == -1) {
            return null;
        }
        if ((endRDF = body.indexOf(62, endRDF)) == -1) {
            return null;
        }
        return body.substring(startRDF, endRDF + 1);
    }

    protected void parseDocumentNode(Node doc, boolean liveData) {
        Node child;
        int i;
        NodeList children = doc.getChildNodes();
        if (liveData) {
            for (i = 0; i < children.getLength(); ++i) {
                child = children.item(i);
                if (!child.getNodeName().equals("Work")) continue;
                this.parseWorkItem(child);
            }
        }
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!child.getNodeName().equals("License")) continue;
            this.parseLicenseItem(child);
        }
        if (liveData) {
            this.updateLicenseDetails();
        }
    }

    protected void parseWorkItem(Node work) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Parsing work item.");
        }
        NamedNodeMap attributes = work.getAttributes();
        Node about = attributes.getNamedItem("rdf:about");
        URN expectedURN = null;
        if (about != null) {
            try {
                expectedURN = URN.createSHA1Urn(about.getNodeValue());
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        NodeList children = work.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node resource;
            Node child = children.item(i);
            if (!child.getNodeName().equals("license") || (resource = (attributes = child.getAttributes()).getNamedItem("rdf:resource")) == null) continue;
            this.addWork(expectedURN, resource.getNodeValue());
        }
    }

    protected void parseLicenseItem(Node license) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Parsing license item.");
        }
        NamedNodeMap attributes = license.getAttributes();
        Node about = attributes.getNamedItem("rdf:about");
        List details = Collections.EMPTY_LIST;
        if (about != null) {
            String value = about.getNodeValue();
            try {
                details = this.getDetailsForLicenseURL(new URL(value));
            }
            catch (MalformedURLException murl) {
                LOG.warn("Unable to create license URL for: " + value, murl);
            }
        }
        if (!details.iterator().hasNext()) {
            return;
        }
        LinkedList required = null;
        LinkedList prohibited = null;
        LinkedList permitted = null;
        NodeList children = license.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equalsIgnoreCase("requires")) {
                if (required == null) {
                    required = new LinkedList();
                }
                this.addPermission(required, child);
                continue;
            }
            if (name.equalsIgnoreCase("permits")) {
                if (permitted == null) {
                    permitted = new LinkedList();
                }
                this.addPermission(permitted, child);
                continue;
            }
            if (!name.equalsIgnoreCase("prohibits")) continue;
            if (prohibited == null) {
                prohibited = new LinkedList();
            }
            this.addPermission(prohibited, child);
        }
        Iterator i = details.iterator();
        while (i.hasNext()) {
            Details detail = (Details)i.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting license details for " + details);
            }
            detail.required = required;
            detail.prohibited = prohibited;
            detail.permitted = permitted;
        }
    }

    private void addPermission(List permissions, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node resource = attributes.getNamedItem("rdf:resource");
        if (resource != null) {
            String value = resource.getNodeValue();
            int slash = value.lastIndexOf(47);
            if (slash != -1 && slash != value.length() - 1) {
                String permission = value.substring(slash + 1);
                if (!permissions.contains(permission)) {
                    permissions.add(permission);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Added permission: " + permission);
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn("Duplicate permission: " + permission + "!");
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.trace("Unable to find permission name: " + value);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("No resource item for permission.");
        }
    }

    private void updateLicenseDetails() {
        if (this.allWorks == null) {
            return;
        }
        Iterator i = this.allWorks.values().iterator();
        while (i.hasNext()) {
            Details details = (Details)i.next();
            if (details.isDescriptionAvailable() || details.licenseURL == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating licenseURL for :" + details);
            }
            String url = details.licenseURL.toExternalForm();
            Object data = LicenseCache.instance().getData(url);
            String body = null;
            if (data != null && data instanceof String) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using cached data for url: " + url);
                }
                body = this.locateRDF((String)data);
            } else {
                body = this.getBody(url);
                if (body != null) {
                    LicenseCache.instance().addData(url, body);
                } else {
                    LOG.debug("Couldn't retrieve license details from url: " + url);
                }
            }
            if (body == null) continue;
            this.parseXML(body, false);
        }
    }

    private static class Details
    implements Serializable {
        private static final long serialVersionUID = -1719502030054241350L;
        URL licenseURL;
        List required;
        List permitted;
        List prohibited;

        Details() {
        }

        Details(URL url) {
            this.licenseURL = url;
        }

        boolean isDescriptionAvailable() {
            return this.required != null || this.permitted != null || this.prohibited != null;
        }

        public String toString() {
            return "details:: license: " + this.licenseURL;
        }
    }
}

