/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.BadCCLicense;
import com.limegroup.gnutella.licenses.CCLicense;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseCache;
import com.limegroup.gnutella.licenses.NamedLicense;
import com.limegroup.gnutella.licenses.UnknownLicense;
import com.limegroup.gnutella.licenses.WeedLicense;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LicenseFactory {
    private static final Log LOG = LogFactory.getLog(LicenseFactory.class);
    public static final String WEED_NAME = "Weed License";
    public static final String CC_NAME = "Creative Commons License";
    public static final String UNKNOWN_NAME = "Unknown License";

    private LicenseFactory() {
    }

    public static boolean isVerifiedAndValid(URN urn, String licenseString) {
        URI uri = LicenseFactory.getLicenseURI(licenseString);
        return uri != null && LicenseCache.instance().isVerifiedAndValid(urn, uri);
    }

    public static String getLicenseName(String licenseString) {
        if (LicenseFactory.isCCLicense(licenseString)) {
            return CC_NAME;
        }
        if (LicenseFactory.isWeedLicense(licenseString)) {
            return WEED_NAME;
        }
        if (LicenseFactory.isUnknownLicense(licenseString)) {
            return UNKNOWN_NAME;
        }
        return null;
    }

    public static License create(String licenseString) {
        if (licenseString == null) {
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to create license from: " + licenseString);
        }
        License license = null;
        URI uri = LicenseFactory.getLicenseURI(licenseString);
        if (uri != null) {
            license = LicenseCache.instance().getLicense(licenseString, uri);
        }
        if (license == null) {
            if (LicenseFactory.isCCLicense(licenseString)) {
                license = uri != null ? new CCLicense(licenseString, uri) : new BadCCLicense(licenseString);
            } else if (LicenseFactory.isWeedLicense(licenseString) && uri != null) {
                license = new WeedLicense(uri);
            } else if (LicenseFactory.isUnknownLicense(licenseString)) {
                license = new UnknownLicense();
            }
        }
        if (license != null && license instanceof NamedLicense) {
            ((NamedLicense)license).setLicenseName(LicenseFactory.getLicenseName(licenseString));
        }
        return license;
    }

    private static boolean isCCLicense(String s) {
        return s.indexOf("verify at") != -1;
    }

    private static boolean isWeedLicense(String s) {
        return s.startsWith("http://www.shmedlic.com/license/3play.aspx");
    }

    private static boolean isUnknownLicense(String s) {
        return s.startsWith("licensed: ");
    }

    public static void persistCache() {
        LicenseCache.instance().persistCache();
    }

    static URI getLicenseURI(String license) {
        if (license == null) {
            return null;
        }
        URI uri = LicenseFactory.getCCLicenseURI(license);
        if (uri == null) {
            uri = LicenseFactory.getWeedLicenseURI(license);
        }
        return uri;
    }

    private static URI getCCLicenseURI(String license) {
        int verifyAt = license.indexOf("verify at");
        if (verifyAt == -1) {
            return null;
        }
        int urlStart = verifyAt + "verify at".length();
        if (urlStart >= license.length()) {
            return null;
        }
        String url = license.substring(urlStart).trim();
        URI uri = null;
        try {
            uri = new URI(url.toCharArray());
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http")) {
                throw new URIException("Invalid scheme: " + scheme);
            }
            String authority = uri.getAuthority();
            if (authority == null || authority.equals("") || authority.indexOf(32) != -1) {
                throw new URIException("Invalid authority: " + authority);
            }
        }
        catch (URIException e) {
            uri = null;
            LOG.error("Unable to create URI", e);
        }
        return uri;
    }

    private static URI getWeedLicenseURI(String license) {
        int lainfo = license.indexOf("http://www.shmedlic.com/license/3play.aspx");
        if (lainfo == -1) {
            return null;
        }
        int cidx = license.indexOf(" cid: ");
        int vidx = license.indexOf(" vid: ");
        if (cidx == -1 || vidx == -1) {
            LOG.debug("No cid or vid, bailing.");
            return null;
        }
        int cend = license.indexOf(" ", cidx += " cid: ".length());
        int vend = license.indexOf(" ", vidx += " vid: ".length());
        if (cend == -1 && vend == -1) {
            LOG.debug("No endings for both cid & vid, bailing");
            return null;
        }
        if (cend == -1) {
            cend = license.length();
        }
        if (vend == -1) {
            vend = license.length();
        }
        String cid = license.substring(cidx, cend).trim();
        String vid = license.substring(vidx, vend).trim();
        if (cid.length() == 0 || vid.length() == 0) {
            LOG.debug("cid or vid is empty, bailing");
            return null;
        }
        if (cid.startsWith(" vid: ".trim()) || vid.startsWith(" cid: ".trim())) {
            LOG.debug("cid starts with vid, or vice versa, bailing.");
            return null;
        }
        return WeedLicense.buildURI(cid, vid);
    }
}

