/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class Message
implements Serializable,
Comparable {
    public static final byte F_PING = 0;
    public static final byte F_PING_REPLY = 1;
    public static final byte F_PUSH = 64;
    public static final byte F_QUERY = -128;
    public static final byte F_QUERY_REPLY = -127;
    public static final byte F_ROUTE_TABLE_UPDATE = 48;
    public static final byte F_VENDOR_MESSAGE = 49;
    public static final byte F_VENDOR_MESSAGE_STABLE = 50;
    public static final byte F_UDP_CONNECTION = 65;
    public static final int N_UNKNOWN = -1;
    public static final int N_TCP = 1;
    public static final int N_UDP = 2;
    public static final int N_MULTICAST = 3;
    private byte[] guid;
    private final byte func;
    private byte ttl;
    private byte hops;
    private int length;
    private int priority = 0;
    private final long creationTime = System.currentTimeMillis();
    private final int network;

    public static byte[] makeGuid() {
        return GUID.makeGuid();
    }

    protected void repOk() {
        Assert.that(this.guid.length == 16);
        Assert.that(this.func == 0 || this.func == 1 || this.func == 64 || this.func == -128 || this.func == -127 || this.func == 49 || this.func == 50 || this.func == 65, "Bad function code");
        if (this.func == 64) {
            Assert.that(this.length == 26, "Bad push length: " + this.length);
        }
        Assert.that(this.ttl >= 0, "Negative TTL: " + this.ttl);
        Assert.that(this.hops >= 0, "Negative hops: " + this.hops);
        Assert.that(this.length >= 0, "Negative length: " + this.length);
    }

    protected Message(byte func, byte ttl, int length) {
        this(func, ttl, length, -1);
    }

    protected Message(byte func, byte ttl, int length, int network) {
        this(Message.makeGuid(), func, ttl, 0, length, network);
    }

    protected Message(byte[] guid, byte func, byte ttl, byte hops, int length) {
        this(guid, func, ttl, hops, length, -1);
    }

    protected Message(byte[] guid, byte func, byte ttl, byte hops, int length, int network) {
        if (guid.length != 16) {
            throw new IllegalArgumentException("invalid guid length: " + guid.length);
        }
        this.guid = guid;
        this.func = func;
        this.ttl = ttl;
        this.hops = hops;
        this.length = length;
        this.network = network;
    }

    public void writeQuickly(OutputStream out) throws IOException {
        out.write(this.guid, 0, 16);
        out.write(this.func);
        out.write(this.ttl);
        out.write(this.hops);
        ByteOrder.int2leb(this.length, out);
        this.writePayload(out);
    }

    public void write(OutputStream out, byte[] buf) throws IOException {
        System.arraycopy(this.guid, 0, buf, 0, this.guid.length);
        buf[16] = this.func;
        buf[17] = this.ttl;
        buf[18] = this.hops;
        ByteOrder.int2leb(this.length, buf, 19);
        out.write(buf);
        this.writePayload(out);
    }

    public void write(OutputStream out) throws IOException {
        this.write(out, new byte[23]);
    }

    protected abstract void writePayload(OutputStream var1) throws IOException;

    public int getNetwork() {
        return this.network;
    }

    public boolean isMulticast() {
        return this.network == 3;
    }

    public boolean isUDP() {
        return this.network == 2;
    }

    public boolean isTCP() {
        return this.network == 1;
    }

    public boolean isUnknownNetwork() {
        return this.network == -1;
    }

    public byte[] getGUID() {
        return this.guid;
    }

    public byte getFunc() {
        return this.func;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte ttl) throws IllegalArgumentException {
        if (ttl < 0) {
            throw new IllegalArgumentException("invalid TTL: " + ttl);
        }
        this.ttl = ttl;
    }

    protected void setGUID(GUID guid) {
        this.guid = guid.bytes();
    }

    public void setHops(byte hops) throws IllegalArgumentException {
        if (hops < 0) {
            throw new IllegalArgumentException("invalid hops: " + hops);
        }
        this.hops = hops;
    }

    public byte getHops() {
        return this.hops;
    }

    public int getLength() {
        return this.length;
    }

    protected void updateLength(int l) {
        this.length = l;
    }

    public int getTotalLength() {
        return 23 + this.length;
    }

    public byte hop() {
        this.hops = (byte)(this.hops + 1);
        if (this.ttl > 0) {
            byte by = this.ttl;
            this.ttl = (byte)(by - 1);
            return by;
        }
        return this.ttl;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public abstract Message stripExtendedPayload();

    public int compareTo(Object message) {
        Message m = (Message)message;
        return m.getPriority() - this.getPriority();
    }

    public String toString() {
        return "{guid=" + new GUID(this.guid).toString() + ", ttl=" + this.ttl + ", hops=" + this.hops + ", priority=" + this.getPriority() + "}";
    }

    public abstract void recordDrop();
}

