/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.util.CountingOutputStream;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.MultiRRIterator;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeadPong
extends VendorMessage {
    private static final Log LOG = LogFactory.getLog(HeadPong.class);
    private static UploadManager _uploadManager = RouterService.getUploadManager();
    private static FileManager _fileManager = RouterService.getFileManager();
    private static final int PACKET_SIZE = 580;
    private static final byte FILE_NOT_FOUND = 0;
    private static final byte COMPLETE_FILE = 1;
    private static final byte PARTIAL_FILE = 2;
    private static final byte FIREWALLED = 4;
    private static final byte DOWNLOADING = 8;
    private static final byte CODES_MASK = 15;
    private static final byte BUSY = 127;
    public static final int VERSION = 1;
    private byte _features;
    private IntervalSet _ranges;
    private Set _altLocs;
    private Set _pushLocs;
    private int _queueStatus;
    private boolean _fileFound;
    private boolean _completeFile;
    private byte[] _vendorId;
    private boolean _isFirewalled;
    private boolean _isDownloading;

    protected HeadPong(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 24, version, payload);
        if (payload == null || payload.length < 2) {
            throw new BadPacketException("bad payload");
        }
        if (version == 1 && payload[1] > 15) {
            throw new BadPacketException("invalid payload for version " + version);
        }
        try {
            DataInputStream dais = new DataInputStream(new ByteArrayInputStream(payload));
            this._features = (byte)(dais.readByte() & 0x1F);
            byte code = dais.readByte();
            if (code == 0) {
                return;
            }
            this._fileFound = true;
            if ((code & 4) == 4) {
                this._isFirewalled = true;
            }
            this._vendorId = new byte[4];
            dais.readFully(this._vendorId);
            this._queueStatus = dais.readByte();
            if ((code & 1) == 1) {
                this._completeFile = true;
            } else {
                if ((code & 8) == 8) {
                    this._isDownloading = true;
                }
                if ((this._features & 1) == 1) {
                    this._ranges = this.readRanges(dais);
                }
            }
            if ((this._features & 4) == 4) {
                this._pushLocs = this.readPushLocs(dais);
            }
            if ((this._features & 2) == 2) {
                this._altLocs = this.readLocs(dais);
            }
        }
        catch (IOException oops) {
            throw new BadPacketException(oops.getMessage());
        }
    }

    public HeadPong(HeadPing ping) {
        super(F_LIME_VENDOR_ID, 24, 1, HeadPong.derivePayload(ping));
        this.setGUID(new GUID(ping.getGUID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] derivePayload(HeadPing ping) {
        boolean didNotSendRanges;
        boolean didNotSendPushAltLocs;
        boolean didNotSendAltLocs;
        ByteArrayOutputStream baos;
        block28: {
            baos = new ByteArrayOutputStream();
            CountingOutputStream caos = new CountingOutputStream(baos);
            DataOutputStream daos = new DataOutputStream(caos);
            int retCode = 0;
            URN urn = ping.getUrn();
            FileDesc desc = _fileManager.getFileDescForUrn(urn);
            didNotSendAltLocs = false;
            didNotSendPushAltLocs = false;
            didNotSendRanges = false;
            try {
                AlternateLocationCollection col;
                byte features = ping.getFeatures();
                features = (byte)(features & 0xFFFFFFEF);
                daos.write(features);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("writing features " + features);
                }
                if (desc == null) {
                    LOG.debug("we do not have the file");
                    daos.write(0);
                    return baos.toByteArray();
                }
                if (!RouterService.acceptedIncomingConnection()) {
                    retCode = 4;
                }
                if (desc instanceof IncompleteFileDesc) {
                    retCode = (byte)(retCode | 2);
                    IncompleteFileDesc idesc = (IncompleteFileDesc)desc;
                    if (idesc.isActivelyDownloading()) {
                        retCode = (byte)(retCode | 8);
                    }
                } else {
                    retCode = (byte)(retCode | 1);
                }
                daos.write(retCode);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("our return code is " + retCode);
                }
                daos.write(F_LIME_VENDOR_ID);
                int queueSize = _uploadManager.getNumQueuedUploads();
                int queueStatus = queueSize == UploadSettings.UPLOAD_QUEUE_SIZE.getValue() ? 127 : (queueSize > 0 ? (int)((byte)queueSize) : (int)((byte)(_uploadManager.uploadsInProgress() - UploadSettings.HARD_MAX_UPLOADS.getValue())));
                daos.writeByte(queueStatus);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("our queue status is " + queueStatus);
                }
                if (retCode == 2 && ping.requestsRanges()) {
                    boolean bl = didNotSendRanges = !HeadPong.writeRanges(caos, desc);
                }
                if (ping.requestsPushLocs()) {
                    AlternateLocationCollection push;
                    boolean FWTOnly;
                    boolean bl = FWTOnly = (features & 8) == 8;
                    if (FWTOnly) {
                        AlternateLocationCollection alternateLocationCollection = push = RouterService.getAltlocManager().getPush(urn, true);
                        synchronized (alternateLocationCollection) {
                            didNotSendPushAltLocs = !HeadPong.writePushLocs(caos, push.iterator());
                        }
                    }
                    push = RouterService.getAltlocManager().getPush(urn, true);
                    AlternateLocationCollection fwt = RouterService.getAltlocManager().getPush(urn, false);
                    AlternateLocationCollection alternateLocationCollection = push;
                    synchronized (alternateLocationCollection) {
                        AlternateLocationCollection alternateLocationCollection2 = fwt;
                        synchronized (alternateLocationCollection2) {
                            didNotSendPushAltLocs = !HeadPong.writePushLocs(caos, new MultiRRIterator(new Iterator[]{push.iterator(), fwt.iterator()}));
                        }
                    }
                }
                if (!ping.requestsAltlocs()) break block28;
                AlternateLocationCollection alternateLocationCollection = col = RouterService.getAltlocManager().getDirect(urn);
                synchronized (alternateLocationCollection) {
                    didNotSendAltLocs = !HeadPong.writeLocs(caos, col.iterator());
                }
            }
            catch (IOException impossible) {
                ErrorService.error(impossible);
            }
        }
        byte[] ret = baos.toByteArray();
        if (didNotSendRanges) {
            LOG.debug("not sending ranges");
            ret[0] = (byte)(ret[0] & 0xFFFFFFFE);
        }
        if (didNotSendAltLocs) {
            LOG.debug("not sending altlocs");
            ret[0] = (byte)(ret[0] & 0xFFFFFFFD);
        }
        if (didNotSendPushAltLocs) {
            LOG.debug("not sending push altlocs");
            ret[0] = (byte)(ret[0] & 0xFFFFFFFB);
        }
        return ret;
    }

    public boolean hasFile() {
        return this._fileFound;
    }

    public boolean hasCompleteFile() {
        return this.hasFile() && this._completeFile;
    }

    public IntervalSet getRanges() {
        return this._ranges;
    }

    public Set getAltLocs() {
        return this._altLocs;
    }

    public Set getPushLocs() {
        return this._pushLocs;
    }

    public Set getAllLocsRFD(RemoteFileDesc original) {
        IpPort current;
        Iterator iter;
        HashSet<RemoteFileDesc> ret = new HashSet<RemoteFileDesc>();
        if (this._altLocs != null) {
            iter = this._altLocs.iterator();
            while (iter.hasNext()) {
                current = (IpPort)iter.next();
                ret.add(new RemoteFileDesc(original, current));
            }
        }
        if (this._pushLocs != null) {
            iter = this._pushLocs.iterator();
            while (iter.hasNext()) {
                current = (PushEndpoint)iter.next();
                ret.add(new RemoteFileDesc(original, (PushEndpoint)current));
            }
        }
        return ret;
    }

    public void updateRFD(RemoteFileDesc rfd) {
        if (this.isBusy()) {
            rfd.setRetryAfter(60);
        }
        rfd.setQueueStatus(this.getQueueStatus());
        rfd.setAvailableRanges(this.getRanges());
        rfd.setSerializeProxies();
    }

    public String getVendor() {
        return new String(this._vendorId);
    }

    public boolean isFirewalled() {
        return this._isFirewalled;
    }

    public int getQueueStatus() {
        return this._queueStatus;
    }

    public boolean isBusy() {
        return this._queueStatus >= 127;
    }

    public boolean isDownloading() {
        return this._isDownloading;
    }

    public boolean isGGEPPong() {
        return (this._features & 0x10) != 0;
    }

    public String toString() {
        return "HeadPong: isGGEP " + this.isGGEPPong() + " hasFile " + this.hasFile() + " hasCompleteFile " + this.hasCompleteFile() + " isDownloading " + this.isDownloading() + " isFirewalled " + this.isFirewalled() + " queue rank " + this.getQueueStatus() + " \nranges " + this.getRanges() + " \nalts " + this.getAltLocs() + " \npushalts " + this.getPushLocs();
    }

    private final IntervalSet readRanges(DataInputStream dais) throws IOException {
        int rangeLength = dais.readUnsignedShort();
        byte[] ranges = new byte[rangeLength];
        dais.readFully(ranges);
        return IntervalSet.parseBytes(ranges);
    }

    private final Set readPushLocs(DataInputStream dais) throws IOException, BadPacketException {
        int size = dais.readUnsignedShort();
        byte[] altlocs = new byte[size];
        dais.readFully(altlocs);
        HashSet ret = new HashSet();
        ret.addAll(NetworkUtils.unpackPushEPs(new ByteArrayInputStream(altlocs)));
        return ret;
    }

    private final Set readLocs(DataInputStream dais) throws IOException, BadPacketException {
        int size = dais.readUnsignedShort();
        byte[] altlocs = new byte[size];
        dais.readFully(altlocs);
        HashSet ret = new HashSet();
        ret.addAll(NetworkUtils.unpackIps(altlocs));
        return ret;
    }

    private static final boolean writeRanges(CountingOutputStream caos, FileDesc desc) throws IOException {
        DataOutputStream daos = new DataOutputStream(caos);
        LOG.debug("adding ranges to pong");
        IncompleteFileDesc ifd = (IncompleteFileDesc)desc;
        byte[] ranges = ifd.getRangesAsByte();
        if (caos.getAmountWritten() + 2 + ranges.length <= 580) {
            LOG.debug("added ranges");
            daos.writeShort((short)ranges.length);
            caos.write(ranges);
            return true;
        }
        LOG.debug("ranges will not fit :(");
        return false;
    }

    private static final boolean writePushLocs(CountingOutputStream caos, Iterator pushlocs) throws IOException {
        if (!pushlocs.hasNext()) {
            return false;
        }
        int available = (580 - (caos.getAmountWritten() + 2)) / 47;
        if (available == 0) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying to add up to " + available + " push locs to pong");
        }
        long now = System.currentTimeMillis();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (pushlocs.hasNext() && available > 0) {
            PushAltLoc loc = (PushAltLoc)pushlocs.next();
            if (loc.getPushAddress().getProxies().isEmpty()) {
                pushlocs.remove();
                continue;
            }
            if (loc.canBeSent(0)) {
                baos.write(loc.getPushAddress().toBytes());
                --available;
                loc.send(now, 0);
                continue;
            }
            if (loc.canBeSentAny()) continue;
            pushlocs.remove();
        }
        if (baos.size() == 0) {
            LOG.debug("did not send any push locs");
            return false;
        }
        LOG.debug("adding push altlocs");
        ByteOrder.short2beb((short)baos.size(), caos);
        baos.writeTo(caos);
        return true;
    }

    private static final boolean writeLocs(CountingOutputStream caos, Iterator altlocs) throws IOException {
        if (!altlocs.hasNext()) {
            return false;
        }
        int toSend = (580 - (caos.getAmountWritten() + 2)) / 6;
        if (toSend == 0) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying to add up to " + toSend + " locs to pong");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int sent = 0;
        long now = System.currentTimeMillis();
        while (altlocs.hasNext() && sent < toSend) {
            DirectAltLoc loc = (DirectAltLoc)altlocs.next();
            if (loc.canBeSent(0)) {
                loc.send(now, 0);
                baos.write(loc.getHost().getInetAddress().getAddress());
                ByteOrder.short2leb((short)loc.getHost().getPort(), baos);
                ++sent;
                continue;
            }
            if (loc.canBeSentAny()) continue;
            altlocs.remove();
        }
        LOG.debug("adding altlocs");
        ByteOrder.short2beb((short)baos.size(), caos);
        baos.writeTo(caos);
        return true;
    }
}

