/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class UDPConnectBackVendorMessage
extends VendorMessage {
    public static final int VERSION = 2;
    private final int _port;
    private final GUID _guid;

    UDPConnectBackVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_GTKG_VENDOR_ID, 7, version, payload);
        try {
            payload = this.getPayload();
            switch (this.getVersion()) {
                case 1: {
                    if (payload.length != 18) {
                        throw new BadPacketException("invalid version1 payload");
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(payload);
                    this._port = ByteOrder.ushort2int(ByteOrder.leb2short(bais));
                    byte[] guidBytes = new byte[16];
                    int bytesRead = bais.read(guidBytes, 0, guidBytes.length);
                    this._guid = new GUID(guidBytes);
                    break;
                }
                case 2: {
                    if (payload.length != 2) {
                        throw new BadPacketException("invalid version2 payload");
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(payload);
                    this._port = ByteOrder.ushort2int(ByteOrder.leb2short(bais));
                    this._guid = new GUID(super.getGUID());
                    break;
                }
                default: {
                    throw new BadPacketException("Unsupported Version");
                }
            }
            if (!NetworkUtils.isValidPort(this._port)) {
                throw new BadPacketException("invalid connectback port.");
            }
        }
        catch (IOException ioe) {
            throw new BadPacketException("Couldn't read from a ByteStream!!!");
        }
    }

    public UDPConnectBackVendorMessage(int port, GUID guid) {
        super(F_GTKG_VENDOR_ID, 7, 1, UDPConnectBackVendorMessage.derivePayload(port, guid));
        this._port = port;
        this._guid = guid;
    }

    public int getConnectBackPort() {
        return this._port;
    }

    public GUID getConnectBackGUID() {
        return this._guid;
    }

    private static byte[] derivePayload(int port, GUID guid) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteOrder.short2leb((short)port, baos);
            baos.write(guid.bytes());
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
        SentMessageStatHandler.TCP_UDP_CONNECTBACK.addMessage(this);
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

