/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.ASFParser;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.VideoMetaData;
import com.limegroup.gnutella.metadata.WMAMetaData;
import com.limegroup.gnutella.metadata.WMVMetaData;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MetaData {
    private static final Log LOG = LogFactory.getLog(MetaData.class);

    protected MetaData() {
    }

    public static MetaData parse(File f) throws IOException {
        try {
            if (LimeXMLUtils.isSupportedAudioFormat(f)) {
                return AudioMetaData.parseAudioFile(f);
            }
            if (LimeXMLUtils.isSupportedVideoFormat(f)) {
                return VideoMetaData.parseVideoMetaData(f);
            }
            if (LimeXMLUtils.isSupportedMultipleFormat(f)) {
                return MetaData.parseMultipleFormat(f);
            }
        }
        catch (OutOfMemoryError e) {
            LOG.warn("Ran out of memory while parsing.", e);
        }
        return null;
    }

    private static MetaData parseMultipleFormat(File f) throws IOException {
        if (LimeXMLUtils.isASFFile(f)) {
            ASFParser p = new ASFParser(f);
            if (p.hasVideo()) {
                return new WMVMetaData(p);
            }
            if (p.hasAudio()) {
                return new WMAMetaData(p);
            }
        }
        return null;
    }

    public abstract boolean isComplete();

    public abstract List toNameValueList();

    public abstract String getSchemaURI();

    protected abstract void parseFile(File var1) throws IOException;
}

