/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.SpamManager;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SearchResultHandler {
    private static final Log LOG = LogFactory.getLog(SearchResultHandler.class);
    private static final int QUERY_EXPIRE_TIME = 30000;
    public static final int REPORT_INTERVAL = 15;
    public static final int MAX_RESULTS = 65535;
    private final List GUID_COUNTS = new Vector();

    public void addQuery(QueryRequest qr) {
        LOG.trace("entered SearchResultHandler.addQuery(QueryRequest)");
        if (!qr.isBrowseHostQuery() && !qr.isWhatIsNewRequest()) {
            SpamManager.instance().startedQuery(qr);
        }
        GuidCount gc = new GuidCount(qr);
        this.GUID_COUNTS.add(gc);
    }

    public void removeQuery(GUID guid) {
        LOG.trace("entered SearchResultHandler.removeQuery(GUID)");
        GuidCount gc = this.removeQueryInternal(guid);
        if (gc != null && !gc.isFinished()) {
            QueryStatusResponse stat = new QueryStatusResponse(guid, 65535);
            RouterService.getConnectionManager().updateQueryStatus(stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getQueriesToReSend() {
        LOG.trace("entered SearchResultHandler.getQueriesToSend()");
        LinkedList<QueryRequest> reSend = null;
        List list = this.GUID_COUNTS;
        synchronized (list) {
            long now = System.currentTimeMillis();
            Iterator iter = this.GUID_COUNTS.iterator();
            while (iter.hasNext()) {
                GuidCount currGC = (GuidCount)iter.next();
                if (!this.isQueryStillValid(currGC, now)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("adding " + currGC + " to list of queries to resend");
                }
                if (reSend == null) {
                    reSend = new LinkedList<QueryRequest>();
                }
                reSend.add(currGC.getQueryRequest());
            }
        }
        if (reSend == null) {
            return Collections.EMPTY_LIST;
        }
        return reSend;
    }

    public int getNumResultsForQuery(GUID guid) {
        GuidCount gc = this.retrieveGuidCount(guid);
        if (gc != null) {
            return gc.getNumResults();
        }
        return -1;
    }

    public void handleQueryReply(QueryReply qr) {
        HostData data;
        try {
            data = qr.getHostData();
        }
        catch (BadPacketException bpe) {
            LOG.debug("bad packet reading qr", bpe);
            return;
        }
        if (!data.isReplyToMulticastQuery() && !qr.isBrowseHostReply()) {
            if (data.getQuality() < SearchSettings.MINIMUM_SEARCH_QUALITY.getValue()) {
                LOG.debug("Ignoring because low quality");
                return;
            }
            if (data.getSpeed() < SearchSettings.MINIMUM_SEARCH_SPEED.getValue()) {
                LOG.debug("Ignoring because low speed");
                return;
            }
            if (!(!data.isFirewalled() || NetworkUtils.isVeryCloseIP(qr.getIPBytes()) || RouterService.acceptedIncomingConnection() && !NetworkUtils.isPrivateAddress(RouterService.getAddress()) || UDPService.instance().canDoFWT() && qr.getSupportsFWTransfer())) {
                LOG.debug("Ignoring from firewall funkiness");
                return;
            }
        }
        List results = null;
        try {
            results = qr.getResultsAsList();
        }
        catch (BadPacketException e) {
            LOG.debug("Error gettig results", e);
            return;
        }
        int secureStatus = qr.getSecureStatus();
        if (secureStatus == 1) {
            return;
        }
        boolean skipSpam = this.isWhatIsNew(qr) || qr.isBrowseHostReply();
        int numGoodSentToFrontEnd = 0;
        double numBadSentToFrontEnd = 0.0;
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            Response response = (Response)iter.next();
            if (!qr.isBrowseHostReply() && secureStatus != 2 && (!RouterService.matchesType(data.getMessageGUID(), response) || !RouterService.matchesQuery(data.getMessageGUID(), response)) || RouterService.isMandragoreWorm(data.getMessageGUID(), response)) continue;
            LimeXMLDocument doc = response.getDocument();
            if (ApplicationSettings.USE_SECURE_RESULTS.getValue() && doc != null && !"".equals(doc.getAction()) && secureStatus != 2) continue;
            RemoteFileDesc rfd = response.toRemoteFileDesc(data);
            rfd.setSecureStatus(secureStatus);
            Set alts = response.getLocations();
            RouterService.getCallback().handleQueryResult(rfd, data, alts);
            if (skipSpam || !SpamManager.instance().isSpam(rfd)) {
                ++numGoodSentToFrontEnd;
                continue;
            }
            numBadSentToFrontEnd += 1.0;
        }
        numBadSentToFrontEnd = Math.ceil(numBadSentToFrontEnd * (double)SearchSettings.SPAM_RESULT_RATIO.getValue());
        this.accountAndUpdateDynamicQueriers(qr, numGoodSentToFrontEnd + (int)numBadSentToFrontEnd);
    }

    private void accountAndUpdateDynamicQueriers(QueryReply qr, int numGoodSentToFrontEnd) {
        LOG.trace("SRH.accountAndUpdateDynamicQueriers(): entered.");
        if (numGoodSentToFrontEnd > 0) {
            GuidCount gc = this.retrieveGuidCount(new GUID(qr.getGUID()));
            if (gc == null) {
                return;
            }
            LOG.trace("SRH.accountAndUpdateDynamicQueriers(): incrementing.");
            gc.increment(numGoodSentToFrontEnd);
            if (RouterService.isShieldedLeaf() && !gc.isFinished() && gc.getNumResults() > gc.getNextReportNum()) {
                LOG.trace("SRH.accountAndUpdateDynamicQueriers(): telling UPs.");
                gc.tallyReport();
                if (gc.getNumResults() > 150) {
                    gc.markAsFinished();
                }
                int numResultsToReport = gc.isFinished() ? 65535 : gc.getNumResults() / 4;
                QueryStatusResponse stat = new QueryStatusResponse(gc.getGUID(), numResultsToReport);
                RouterService.getConnectionManager().updateQueryStatus(stat);
            }
        }
        LOG.trace("SRH.accountAndUpdateDynamicQueriers(): returning.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidCount removeQueryInternal(GUID guid) {
        List list = this.GUID_COUNTS;
        synchronized (list) {
            Iterator iter = this.GUID_COUNTS.iterator();
            while (iter.hasNext()) {
                GuidCount currGC = (GuidCount)iter.next();
                if (!currGC.getGUID().equals(guid)) continue;
                iter.remove();
                return currGC;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidCount retrieveGuidCount(GUID guid) {
        List list = this.GUID_COUNTS;
        synchronized (list) {
            Iterator iter = this.GUID_COUNTS.iterator();
            while (iter.hasNext()) {
                GuidCount currGC = (GuidCount)iter.next();
                if (!currGC.getGUID().equals(guid)) continue;
                return currGC;
            }
        }
        return null;
    }

    private boolean isWhatIsNew(QueryReply reply) {
        GuidCount gc = this.retrieveGuidCount(new GUID(reply.getGUID()));
        return gc != null && gc.getQueryRequest().isWhatIsNewRequest();
    }

    private boolean isQueryStillValid(GuidCount gc, long now) {
        LOG.trace("entered SearchResultHandler.isQueryStillValid(GuidCount)");
        return now < gc.getTime() + 30000L && gc.getNumResults() < 150;
    }

    private static class GuidCount {
        private final long _time;
        private final GUID _guid;
        private final QueryRequest _qr;
        private int _numGoodResults;
        private int _nextReportNum = 15;
        private boolean markAsFinished = false;

        public GuidCount(QueryRequest qr) {
            this._qr = qr;
            this._guid = new GUID(qr.getGUID());
            this._time = System.currentTimeMillis();
        }

        public GUID getGUID() {
            return this._guid;
        }

        public int getNumResults() {
            return this._numGoodResults;
        }

        public int getNextReportNum() {
            return this._nextReportNum;
        }

        public long getTime() {
            return this._time;
        }

        public QueryRequest getQueryRequest() {
            return this._qr;
        }

        public boolean isFinished() {
            return this.markAsFinished;
        }

        public void tallyReport() {
            this._nextReportNum = this._numGoodResults + 15;
        }

        public void increment(int good) {
            this._numGoodResults += good;
        }

        public void markAsFinished() {
            this.markAsFinished = true;
        }

        public String toString() {
            return "" + this._guid + ":" + this._numGoodResults + ":" + this._nextReportNum;
        }
    }
}

