/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignatureVerifier {
    private static final Log LOG = LogFactory.getLog(SignatureVerifier.class);
    private final byte[] plainText;
    private final byte[] signature;
    private final PublicKey publicKey;
    private final String algorithm;
    private final String digAlg;

    public SignatureVerifier(byte[] pText, byte[] sigBytes, PublicKey key, String algorithm) {
        this(pText, sigBytes, key, algorithm, null);
    }

    public SignatureVerifier(byte[] pText, byte[] sigBytes, PublicKey key, String algorithm, String digAlg) {
        this.plainText = pText;
        this.signature = sigBytes;
        this.publicKey = key;
        this.algorithm = algorithm;
        this.digAlg = digAlg;
    }

    public String toString() {
        return "text: " + new String(this.plainText) + ", sig: " + new String(this.signature) + ", key: " + this.publicKey + ", alg: " + this.algorithm + ", digAlg: " + this.digAlg;
    }

    public boolean verifySignature() {
        String alg = this.digAlg == null ? this.algorithm : this.digAlg + "with" + this.algorithm;
        try {
            Signature verifier = Signature.getInstance(alg);
            verifier.initVerify(this.publicKey);
            verifier.update(this.plainText, 0, this.plainText.length);
            return verifier.verify(this.signature);
        }
        catch (NoSuchAlgorithmException nsax) {
            LOG.error("No alg." + this, nsax);
            return false;
        }
        catch (InvalidKeyException ikx) {
            LOG.error("Invalid key. " + this, ikx);
            return false;
        }
        catch (SignatureException sx) {
            LOG.error("Bad sig." + this, sx);
            return false;
        }
        catch (ClassCastException ccx) {
            LOG.error("bad cast." + this, ccx);
            return false;
        }
    }

    public static String getVerifiedData(byte[] data, File keyFile, String alg, String dig) {
        PublicKey key = SignatureVerifier.readKey(keyFile, alg);
        byte[][] info = SignatureVerifier.parseData(data);
        return SignatureVerifier.verify(key, info, alg, dig);
    }

    public static String getVerifiedData(File source, File keyFile, String alg, String dig) {
        PublicKey key = SignatureVerifier.readKey(keyFile, alg);
        byte[][] info = SignatureVerifier.parseData(FileUtils.readFileFully(source));
        return SignatureVerifier.verify(key, info, alg, dig);
    }

    private static String verify(PublicKey key, byte[][] info, String alg, String dig) {
        if (key == null || info == null) {
            LOG.warn("No key or data to verify.");
            return null;
        }
        SignatureVerifier sv = new SignatureVerifier(info[1], info[0], key, alg, dig);
        if (sv.verifySignature()) {
            try {
                return new String(info[1], "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                return new String(info[1]);
            }
        }
        return null;
    }

    public static PublicKey readKey(File keyFile, String alg) {
        byte[] fileData = FileUtils.readFileFully(keyFile);
        if (fileData == null) {
            return null;
        }
        try {
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(Base32.decode(new String(fileData)));
            KeyFactory kf = KeyFactory.getInstance(alg);
            PublicKey key = kf.generatePublic(pubKeySpec);
            return key;
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error("Invalid algorithm: " + alg, nsae);
            return null;
        }
        catch (InvalidKeySpecException ikse) {
            LOG.error("Invalid keyspec: " + keyFile, ikse);
            return null;
        }
    }

    private static byte[][] parseData(byte[] data) {
        if (data == null) {
            LOG.warn("No data to parse.");
            return null;
        }
        int i = SignatureVerifier.findPipes(data);
        if (i == -1 || i >= data.length - 3) {
            LOG.warn("Couldn't find pipes.");
            return null;
        }
        byte[] sig = new byte[i];
        byte[] content = new byte[data.length - i - 2];
        System.arraycopy(data, 0, sig, 0, sig.length);
        System.arraycopy(data, i + 2, content, 0, content.length);
        return new byte[][]{Base32.decode(new String(sig)), content};
    }

    private static int findPipes(byte[] data) {
        for (int i = 0; i < data.length - 1; ++i) {
            if (data[i] != 124 || data[i + 1] != 124) continue;
            return i;
        }
        return -1;
    }
}

