/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.util.CommonUtils;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;

public class TigerTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    private static final int HASHSIZE = 24;
    private static final boolean USE_CRYPTIX = CommonUtils.isJaguarOrAbove();
    private static final byte[] MARKER;
    private final byte[] buffer = new byte[1024];
    private int bufferOffset = 0;
    private long byteCount = 0L;
    private MessageDigest tiger;
    private ArrayList nodes = new ArrayList();

    public TigerTree() {
        super("tigertree");
        if (USE_CRYPTIX) {
            try {
                this.tiger = MessageDigest.getInstance("Tiger", "CryptixCrypto");
            }
            catch (NoSuchAlgorithmException nsae) {
                this.tiger = new Tiger();
            }
            catch (NoSuchProviderException nspe) {
                this.tiger = new Tiger();
            }
        } else {
            this.tiger = new Tiger();
        }
    }

    protected int engineGetDigestLength() {
        return 24;
    }

    protected void engineUpdate(byte in) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = in;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    protected void engineUpdate(byte[] in, int offset, int length) {
        this.byteCount += (long)length;
        this.nodes.ensureCapacity(TigerTree.log2Ceil(this.byteCount / 1024L));
        if (this.bufferOffset > 0) {
            int remaining = 1024 - this.bufferOffset;
            System.arraycopy(in, offset, this.buffer, this.bufferOffset, remaining);
            this.blockUpdate();
            this.bufferOffset = 0;
            length -= remaining;
            offset += remaining;
        }
        while (length >= 1024) {
            this.blockUpdate(in, offset, 1024);
            length -= 1024;
            offset += 1024;
        }
        if (length > 0) {
            System.arraycopy(in, offset, this.buffer, 0, length);
            this.bufferOffset = length;
        }
    }

    protected byte[] engineDigest() {
        byte[] hash = new byte[24];
        try {
            this.engineDigest(hash, 0, 24);
        }
        catch (DigestException e) {
            return null;
        }
        return hash;
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 24) {
            throw new DigestException();
        }
        this.blockUpdate();
        byte[] ret = this.collapse();
        Assert.that(ret != MARKER);
        System.arraycopy(ret, 0, buf, offset, 24);
        this.engineReset();
        return 24;
    }

    private byte[] collapse() {
        byte[] last = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            byte[] current = (byte[])this.nodes.get(i);
            if (current == MARKER) continue;
            if (last == null) {
                last = current;
            } else {
                this.tiger.reset();
                this.tiger.update((byte)1);
                this.tiger.update(current);
                this.tiger.update(last);
                last = this.tiger.digest();
            }
            this.nodes.set(i, MARKER);
        }
        Assert.that(last != null);
        return last;
    }

    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes = new ArrayList();
        this.tiger.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.blockUpdate(this.buffer, 0, this.bufferOffset);
    }

    protected void blockUpdate(byte[] buf, int pos, int len) {
        this.tiger.reset();
        this.tiger.update((byte)0);
        this.tiger.update(buf, pos, len);
        if (len == 0 && this.nodes.size() > 0) {
            return;
        }
        byte[] digest = this.tiger.digest();
        this.push(digest);
    }

    private void push(byte[] data) {
        if (!this.nodes.isEmpty()) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                byte[] node = (byte[])this.nodes.get(i);
                if (node == MARKER) {
                    this.nodes.set(i, data);
                    return;
                }
                this.tiger.reset();
                this.tiger.update((byte)1);
                this.tiger.update(node);
                this.tiger.update(data);
                data = this.tiger.digest();
                this.nodes.set(i, MARKER);
            }
        }
        this.nodes.add(data);
    }

    public static int log2Ceil(long number) {
        int n = 0;
        while (number > 1L) {
            ++number;
            number >>>= 1;
            ++n;
        }
        return n;
    }

    static {
        if (USE_CRYPTIX) {
            try {
                Class<?> clazz = Class.forName("cryptix.jce.provider.CryptixCrypto");
                Object o = clazz.newInstance();
                Security.addProvider((Provider)o);
            }
            catch (ClassNotFoundException e) {
                ErrorService.error(e);
            }
            catch (IllegalAccessException e) {
                ErrorService.error(e);
            }
            catch (InstantiationException e) {
                ErrorService.error(e);
            }
            catch (ExceptionInInitializerError e) {
                ErrorService.error(e);
            }
            catch (SecurityException e) {
                ErrorService.error(e);
            }
            catch (ClassCastException e) {
                ErrorService.error(e);
            }
        }
        MARKER = new byte[0];
    }
}

