/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.AbstractNumberSetting;
import java.util.Properties;

public final class FloatSetting
extends AbstractNumberSetting {
    private float value;

    FloatSetting(Properties defaultProps, Properties props, String key, float defaultFloat) {
        super(defaultProps, props, key, String.valueOf(defaultFloat), null, null, null);
    }

    FloatSetting(Properties defaultProps, Properties props, String key, float defaultFloat, String simppKey, float min, float max) {
        super(defaultProps, props, key, String.valueOf(defaultFloat), simppKey, new Float(min), new Float(max));
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        super.setValue(String.valueOf(value));
    }

    protected void loadValue(String sValue) {
        try {
            this.value = Float.valueOf(sValue.trim()).floatValue();
        }
        catch (NumberFormatException nfe) {
            this.revertToDefault();
        }
    }

    protected Comparable convertToComparable(String value) {
        return new Float(value);
    }
}

