/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import java.util.Properties;

public abstract class Setting {
    protected final Properties DEFAULT_PROPS;
    protected final Properties PROPS;
    protected final String KEY;
    protected final String DEFAULT_VALUE;
    private boolean _alwaysSave = false;
    private boolean _isPrivate = false;
    private final String SIMPP_KEY;

    protected Setting(Properties defaultProps, Properties props, String key, String defaultValue, String simppKey) {
        this.DEFAULT_PROPS = defaultProps;
        this.PROPS = props;
        this.KEY = key;
        this.SIMPP_KEY = simppKey;
        this.DEFAULT_VALUE = defaultValue;
        if (this.DEFAULT_PROPS.containsKey(key)) {
            throw new IllegalArgumentException("duplicate setting key: " + key);
        }
        this.DEFAULT_PROPS.put(this.KEY, defaultValue);
        this.loadValue(defaultValue);
    }

    public void reload() {
        String value = this.PROPS.getProperty(this.KEY);
        if (value == null) {
            value = this.DEFAULT_VALUE;
        }
        this.loadValue(value);
    }

    public void revertToDefault() {
        this.setValue(this.DEFAULT_VALUE);
    }

    public boolean shouldAlwaysSave() {
        return this._alwaysSave;
    }

    public Setting setAlwaysSave(boolean save) {
        this._alwaysSave = save;
        return this;
    }

    public Setting setPrivate(boolean priv) {
        this._isPrivate = priv;
        return this;
    }

    public boolean isPrivate() {
        return this._isPrivate;
    }

    public boolean isDefault() {
        String value = this.PROPS.getProperty(this.KEY);
        if (value == null) {
            return false;
        }
        return value.equals(this.DEFAULT_PROPS.getProperty(this.KEY));
    }

    public String getKey() {
        return this.KEY;
    }

    public String getValueAsString() {
        return this.PROPS.getProperty(this.KEY);
    }

    protected void setValue(String value) {
        this.PROPS.put(this.KEY, value);
        this.loadValue(value);
    }

    public boolean isSimppEnabled() {
        return this.SIMPP_KEY != null;
    }

    protected abstract void loadValue(String var1);
}

