/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TigerTreeCache {
    private static TigerTreeCache instance = null;
    private static final ProcessingQueue QUEUE = new ProcessingQueue("TreeHashTread");
    private static final Log LOG = LogFactory.getLog(TigerTreeCache.class);
    private static final Object BUSH = new Object();
    private static Map TREE_MAP;
    private static final File CACHE_FILE;
    private static boolean dirty;

    public static synchronized TigerTreeCache instance() {
        if (instance == null) {
            instance = new TigerTreeCache();
        }
        return instance;
    }

    public synchronized HashTree getHashTree(FileDesc fd) {
        Object obj = TREE_MAP.get(fd.getSHA1Urn());
        if (obj != null && obj.equals(BUSH)) {
            return null;
        }
        HashTree tree = (HashTree)obj;
        if (tree == null) {
            TREE_MAP.put(fd.getSHA1Urn(), BUSH);
            QUEUE.add(new HashRunner(fd));
        }
        return tree;
    }

    public synchronized HashTree getHashTree(URN sha1) {
        Object tree = TREE_MAP.get(sha1);
        if (tree != null && tree.equals(BUSH)) {
            return null;
        }
        return (HashTree)tree;
    }

    public synchronized void purgeTree(URN sha1) {
        if (TREE_MAP.remove(sha1) != null) {
            dirty = true;
        }
    }

    public static synchronized void addHashTree(URN sha1, HashTree tree) {
        if (tree.isGoodDepth()) {
            TREE_MAP.put(sha1, tree);
            dirty = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("added hashtree for urn " + sha1 + ";" + tree.getRootHash());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("hashtree for urn " + sha1 + " had bad depth");
        }
    }

    private TigerTreeCache() {
        TREE_MAP = TigerTreeCache.createMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map createMap() {
        Map map;
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(CACHE_FILE)));
                Map map2 = (Map)ois.readObject();
                if (map2 != null) {
                    Iterator i = map2.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry next = i.next();
                        Object key = next.getKey();
                        Object value = next.getValue();
                        if (key instanceof URN && value instanceof HashTree) continue;
                        i.remove();
                    }
                }
                map = map2;
                Object var7_8 = null;
                if (ois == null) return map;
            }
            catch (Throwable t) {
                LOG.error("Can't read tiger trees", t);
                HashMap hashMap = new HashMap();
                Object var7_9 = null;
                if (ois == null) return hashMap;
                try {
                    ois.close();
                    return hashMap;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (ois == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            ois.close();
            throw throwable;
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return map;
        }
        ois.close();
        return map;
    }

    private static void removeOldEntries(Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            URN sha1 = (URN)iter.next();
            if (map.get(sha1) != BUSH && (RouterService.getFileManager().getFileDescForUrn(sha1) != null || RouterService.getDownloadManager().getIncompleteFileManager().getFileForUrn(sha1) != null || Math.random() > (double)(map.size() / 200))) continue;
            iter.remove();
            dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void persistCache() {
        block12: {
            if (!TigerTreeCache.dirty) {
                return;
            }
            TigerTreeCache.removeOldEntries(TigerTreeCache.TREE_MAP);
            oos = null;
            try {
                oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(TigerTreeCache.CACHE_FILE)));
                oos.writeObject(TigerTreeCache.TREE_MAP);
                var4_2 = null;
                ** if (oos == null) goto lbl-1000
            }
            catch (Throwable var3_9) {
                var4_4 = null;
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                throw var3_9;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    oos.close();
                }
                catch (IOException ignored) {}
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (IOException e) {
                    ErrorService.error(e);
                    var4_3 = null;
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
        }
        TigerTreeCache.dirty = true;
    }

    static {
        CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttree.cache");
        dirty = false;
    }

    private static class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fd) {
            this.FD = fd;
        }

        public void run() {
            try {
                URN sha1 = this.FD.getSHA1Urn();
                if (TigerTreeCache.instance().getHashTree(sha1) == null) {
                    HashTree tree = HashTree.createHashTree(this.FD);
                    TigerTreeCache.addHashTree(sha1, tree);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

