/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileNotFoundUploadState
extends UploadState {
    private static final Log LOG = LogFactory.getLog(FileNotFoundUploadState.class);
    private static final byte[] ERROR_MESSAGE = "File not found on server.".getBytes();

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        LOG.debug("writing message headers");
        String str = "HTTP/1.1 404 Not Found\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: text/plain\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: " + ERROR_MESSAGE.length + "\r\n";
        ostream.write(str.getBytes());
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        LOG.debug("writing message body");
        ostream.write(ERROR_MESSAGE);
    }

    public boolean getCloseConnection() {
        return false;
    }
}

