/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.ThrottledOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class THEXUploadState
extends UploadState {
    private final HashTree TREE;
    private final StalledUploadWatchdog WATCHDOG;
    private static final Log LOG = LogFactory.getLog(THEXUploadState.class);
    private static final BandwidthThrottle THROTTLE = new BandwidthThrottle(UploadSettings.THEX_UPLOAD_SPEED.getValue());

    public THEXUploadState(HTTPUploader uploader, StalledUploadWatchdog dog) {
        super(uploader);
        LOG.debug("creating thex upload state");
        this.TREE = this.FILE_DESC.getHashTree();
        if (this.TREE == null) {
            throw new NullPointerException("null TREE in THEXUploadState");
        }
        this.WATCHDOG = dog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageHeaders(OutputStream network) throws IOException {
        LOG.debug("writing thex headers");
        StringWriter os = new StringWriter();
        os.write("HTTP/1.1 200 OK\r\n");
        HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, (Writer)os);
        HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)this.FILE_DESC.getSHA1Urn(), (Writer)os);
        HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_LENGTH, this.TREE.getOutputLength(), (Writer)os);
        HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_TYPE, this.TREE.getOutputType(), (Writer)os);
        os.write("\r\n");
        this.WATCHDOG.activate(network);
        try {
            network.write(os.toString().getBytes());
        }
        finally {
            this.WATCHDOG.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageBody(OutputStream os) throws IOException {
        LOG.debug("writing message body");
        THROTTLE.setRate(UploadSettings.THEX_UPLOAD_SPEED.getValue());
        ThrottledOutputStream slowStream = new ThrottledOutputStream(os, THROTTLE);
        this.WATCHDOG.activate(os);
        try {
            this.TREE.write(slowStream);
        }
        finally {
            this.WATCHDOG.deactivate();
        }
    }

    public boolean getCloseConnection() {
        return false;
    }
}

