/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.I18NConvert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class CommonUtils {
    private static final String LIMEWIRE_VERSION = "4.12.6";
    private static String testVersion = null;
    private static final int _majorVersionNumber = CommonUtils.getMajorVersionNumberInternal("4.12.6");
    private static final int _minorVersionNumber = CommonUtils.getMinorVersionNumberInternal("4.12.6");
    private static final int _serviceVersionNumber = CommonUtils.getServiceVersionNumberInternal("4.12.6");
    private static final int _guessMajorVersionNumber = 0;
    private static final int _guessMinorVersionNumber = 1;
    private static final int _upMajorVersionNumber = 0;
    private static final int _upMinorVersionNumber = 1;
    public static final String QHD_VENDOR_NAME = "LIME";
    private static final Properties PROPS = System.getProperties();
    private static boolean _isWindows = false;
    private static boolean _isWindowsNT = false;
    private static boolean _isWindowsXP = false;
    private static boolean _isWindowsNTor2000orXP = false;
    private static boolean _isWindows2000orXP = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _isWindowsMe = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;
    private static boolean _isOS2 = false;
    private static final char[] ILLEGAL_CHARS_ANY_OS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f'};
    private static final char[] ILLEGAL_CHARS_UNIX = new char[]{'`'};
    private static final char[] ILLEGAL_CHARS_WINDOWS = new char[]{'?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final char[] ILLEGAL_CHARS_MACOS = new char[]{':'};
    private static final String HTTP_SERVER;
    private static final String LIMEWIRE_PREFS_DIR_NAME = ".limewire";
    private static final File CURRENT_DIRECTORY;
    private static boolean _isPro;
    static File SETTINGS_DIRECTORY;
    private static boolean _windowsFilesMoved;
    private static boolean _xmlFilesMoved;
    private static final String[] USER_FILES;

    private CommonUtils() {
    }

    private static void setOperatingSystems() {
        _isWindows = false;
        _isWindowsNTor2000orXP = false;
        _isWindows2000orXP = false;
        _isWindowsNT = false;
        _isWindowsXP = false;
        _isWindows95 = false;
        _isWindows98 = false;
        _isWindowsMe = false;
        _isSolaris = false;
        _isLinux = false;
        _isOS2 = false;
        _isMacOSX = false;
        String os = System.getProperty("os.name").toLowerCase(Locale.US);
        boolean bl = _isWindows = os.indexOf("windows") != -1;
        if (os.indexOf("windows nt") != -1 || os.indexOf("windows 2000") != -1 || os.indexOf("windows xp") != -1) {
            _isWindowsNTor2000orXP = true;
        }
        if (os.indexOf("windows 2000") != -1 || os.indexOf("windows xp") != -1) {
            _isWindows2000orXP = true;
        }
        if (os.indexOf("windows nt") != -1) {
            _isWindowsNT = true;
        }
        if (os.indexOf("windows xp") != -1) {
            _isWindowsXP = true;
        }
        if (os.indexOf("windows 95") != -1) {
            _isWindows95 = true;
        }
        if (os.indexOf("windows 98") != -1) {
            _isWindows98 = true;
        }
        if (os.indexOf("windows me") != -1) {
            _isWindowsMe = true;
        }
        _isSolaris = os.indexOf("solaris") != -1;
        _isLinux = os.indexOf("linux") != -1;
        boolean bl2 = _isOS2 = os.indexOf("os/2") != -1;
        if (_isWindows || _isLinux) {
            _supportsTray = true;
        }
        if (os.startsWith("mac os") && os.endsWith("x")) {
            _isMacOSX = true;
        }
    }

    public static int getGUESSMajorVersionNumber() {
        return 0;
    }

    public static int getGUESSMinorVersionNumber() {
        return 1;
    }

    public static int getUPMajorVersionNumber() {
        return 0;
    }

    public static int getUPMinorVersionNumber() {
        return 1;
    }

    public static String getLimeWireVersion() {
        if (testVersion == null) {
            return LIMEWIRE_VERSION;
        }
        return testVersion;
    }

    public static int getMajorVersionNumber() {
        return _majorVersionNumber;
    }

    public static int getMinorVersionNumber() {
        return _minorVersionNumber;
    }

    public static int getServiceVersionNumber() {
        return _serviceVersionNumber;
    }

    static int getMajorVersionNumberInternal(String version) {
        if (!version.equals("@version@")) {
            try {
                int firstDot = version.indexOf(".");
                String majorStr = version.substring(0, firstDot);
                return new Integer(majorStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2;
    }

    public static boolean isPro() {
        return _isPro;
    }

    public static boolean isTestingVersion() {
        return LIMEWIRE_VERSION.equals("@version@");
    }

    static int getMinorVersionNumberInternal(String version) {
        if (!version.equals("@version@")) {
            try {
                int firstDot = version.indexOf(".");
                String minusMajor = version.substring(firstDot + 1);
                int secondDot = minusMajor.indexOf(".");
                String minorStr = minusMajor.substring(0, secondDot);
                return new Integer(minorStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 7;
    }

    static int getServiceVersionNumberInternal(String version) {
        if (!version.equals("@version@")) {
            try {
                int p;
                int q;
                int firstDot = version.indexOf(".");
                int secondDot = version.indexOf(".", firstDot + 1);
                for (q = p = secondDot + 1; q < version.length() && Character.isDigit(version.charAt(q)); ++q) {
                }
                if (p != q) {
                    String service = version.substring(p, q);
                    return new Integer(service);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static String getVendor() {
        return "LimeWire 4.12.6";
    }

    public static String getHttpServer() {
        return HTTP_SERVER;
    }

    public static String getJavaVersion() {
        return PROPS.getProperty("java.version");
    }

    public static String getOS() {
        return PROPS.getProperty("os.name");
    }

    public static String getOSVersion() {
        return PROPS.getProperty("os.version");
    }

    public static File getCurrentDirectory() {
        return CURRENT_DIRECTORY;
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isUltrapeerOS() {
        return !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isWindowsNT;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsNTor2000orXP() {
        return _isWindowsNTor2000orXP;
    }

    public static boolean isWindows2000orXP() {
        return _isWindows2000orXP;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isOS2() {
        return _isOS2;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isJaguarOrAbove() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        return CommonUtils.getOSVersion().startsWith("10.2");
    }

    public static boolean isPantherOrAbove() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        return CommonUtils.getOSVersion().startsWith("10.3");
    }

    public static boolean isCocoaFoundationAvailable() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        try {
            Class.forName("com.apple.cocoa.foundation.NSUserDefaults");
            Class.forName("com.apple.cocoa.foundation.NSMutableDictionary");
            Class.forName("com.apple.cocoa.foundation.NSMutableArray");
            Class.forName("com.apple.cocoa.foundation.NSObject");
            Class.forName("com.apple.cocoa.foundation.NSSystem");
            return true;
        }
        catch (ClassNotFoundException error) {
            return false;
        }
        catch (NoClassDefFoundError error) {
            return false;
        }
    }

    public static boolean isAnyMac() {
        return _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    public static boolean isPOSIX() {
        return _isLinux || _isSolaris || _isMacOSX;
    }

    public static boolean isJava14OrLater() {
        String version = CommonUtils.getJavaVersion();
        return !version.startsWith("1.3") && !version.startsWith("1.2") && !version.startsWith("1.1") && !version.startsWith("1.0");
    }

    public static boolean isJava142OrLater() {
        String version = CommonUtils.getJavaVersion();
        return !version.startsWith("1.4.1") && !version.startsWith("1.4.0") && CommonUtils.isJava14OrLater();
    }

    public static boolean isJava15OrLater() {
        String version = CommonUtils.getJavaVersion();
        return !version.startsWith("1.4") && !version.startsWith("1.3") && !version.startsWith("1.2") && !version.startsWith("1.1") && !version.startsWith("1.0");
    }

    public static boolean isJavaOutOfDate() {
        return CommonUtils.isWindows() && !CommonUtils.isSpecificJRE() && (CommonUtils.getJavaVersion().startsWith("1.3") || CommonUtils.getJavaVersion().startsWith("1.4.0"));
    }

    public static boolean isSpecificJRE() {
        return new File(".", "jre").isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int copy(File src, int amount, File dst) {
        int amountToRead;
        block24: {
            IOException e222;
            OutputStream out;
            BufferedInputStream in;
            block21: {
                int read;
                int BUFFER_SIZE = 1024;
                in = null;
                out = null;
                in = new BufferedInputStream(new FileInputStream(src));
                out = new BufferedOutputStream(new FileOutputStream(dst));
                byte[] buf = new byte[1024];
                for (amountToRead = amount; amountToRead > 0 && (read = ((InputStream)in).read(buf, 0, Math.min(1024, amountToRead))) != -1; amountToRead -= read) {
                    out.write(buf, 0, read);
                }
                Object var10_10 = null;
                if (in == null) break block21;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.flush();
                }
                catch (IOException e222) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (IOException e222) {}
            }
            break block24;
            {
                catch (IOException e3) {
                    IOException e222;
                    Object var10_11 = null;
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (out == null) break block24;
                    try {
                        out.flush();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e222) {}
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var10_12 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.flush();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return amount - amountToRead;
    }

    public static boolean copy(File src, File dst) {
        long length = src.length();
        return (long)CommonUtils.copy(src, (int)length, dst) == length;
    }

    public static File getUserHomeDir() {
        return new File(PROPS.getProperty("user.home"));
    }

    public static String getUserName() {
        return PROPS.getProperty("user.name");
    }

    private static synchronized void setUserSettingsDir(File settingsDir) throws IOException, SecurityException {
        if (!(settingsDir = settingsDir.getAbsoluteFile()).isDirectory()) {
            settingsDir.delete();
            if (!settingsDir.mkdirs()) {
                String msg = "could not create preferences directory: " + settingsDir;
                throw new IOException(msg);
            }
        }
        if (!settingsDir.canWrite()) {
            throw new IOException("settings dir not writable");
        }
        if (!settingsDir.canRead()) {
            throw new IOException("settings dir not readable");
        }
        CommonUtils.moveWindowsFiles(settingsDir);
        CommonUtils.moveXMLFiles(settingsDir);
        SETTINGS_DIRECTORY = settingsDir;
    }

    public static synchronized File getUserSettingsDir() {
        if (SETTINGS_DIRECTORY != null) {
            return SETTINGS_DIRECTORY;
        }
        File settingsDir = new File(CommonUtils.getUserHomeDir(), LIMEWIRE_PREFS_DIR_NAME);
        if (CommonUtils.isWindows()) {
            File tempSettingsDir;
            String appdata = null;
            appdata = CommonUtils.isJava15OrLater() ? System.getProperty("LIMEWIRE_PREFS_DIR", System.getenv("APPDATA")) : System.getProperty("LIMEWIRE_PREFS_DIR", null);
            if ("%APPDATA%".equals(appdata)) {
                appdata = null;
            }
            if (appdata != null && appdata.length() > 0 && ((tempSettingsDir = new File(appdata, "LimeWire")).isDirectory() || !settingsDir.exists())) {
                try {
                    CommonUtils.setUserSettingsDir(tempSettingsDir);
                    return tempSettingsDir;
                }
                catch (IOException e) {
                }
                catch (SecurityException securityException) {}
            }
        } else if (CommonUtils.isMacOSX()) {
            settingsDir = new File(CommonUtils.getUserHomeDir(), "Library/Preferences/LimeWire");
        }
        try {
            CommonUtils.setUserSettingsDir(settingsDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return settingsDir;
    }

    private static synchronized void moveWindowsFiles(File settingsDir) {
        if (!CommonUtils.isWindows()) {
            return;
        }
        if (_windowsFilesMoved) {
            return;
        }
        File currentDir = CommonUtils.getCurrentDirectory();
        for (int i = 0; i < USER_FILES.length; ++i) {
            File curUserFile = new File(settingsDir, USER_FILES[i]);
            File curDirFile = new File(currentDir, USER_FILES[i]);
            if (curUserFile.isFile() || CommonUtils.copy(curDirFile, curUserFile)) continue;
            throw new RuntimeException();
        }
        _windowsFilesMoved = true;
    }

    private static synchronized void moveXMLFiles(File settingsDir) {
        if (_xmlFilesMoved) {
            return;
        }
        File currentDir = new File(CommonUtils.getCurrentDirectory().getPath() + "/lib/xml/data");
        settingsDir = new File(settingsDir.getPath() + "/xml/data");
        settingsDir.mkdirs();
        String[] filesToMove = currentDir.list();
        if (filesToMove != null) {
            for (int i = 0; i < filesToMove.length; ++i) {
                File curUserFile = new File(settingsDir, filesToMove[i]);
                File curDirFile = new File(currentDir, filesToMove[i]);
                if (curUserFile.isFile()) continue;
                CommonUtils.copy(curDirFile, curUserFile);
            }
        }
        _xmlFilesMoved = true;
    }

    public static File getResourceFile(String location) {
        ClassLoader cl = CommonUtils.class.getClassLoader();
        URL resource = null;
        resource = cl == null ? ClassLoader.getSystemResource(location) : cl.getResource(location);
        if (resource == null) {
            return new File(location);
        }
        return new File(CommonUtils.decode(resource.getFile()));
    }

    public static InputStream getResourceStream(String location) throws IOException {
        ClassLoader cl = CommonUtils.class.getClassLoader();
        URL resource = null;
        resource = cl == null ? ClassLoader.getSystemResource(location) : cl.getResource(location);
        if (resource == null) {
            throw new IOException("null resource: " + location);
        }
        return resource.openStream();
    }

    public static String decode(String s) {
        StringBuffer sb = new StringBuffer();
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block8;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(s);
                    }
                    i += 2;
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String result = sb.toString();
        try {
            byte[] inputBytes = result.getBytes("8859_1");
            result = new String(inputBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static void copyResourceFile(String fileName) {
        CommonUtils.copyResourceFile(fileName, null);
    }

    public static void copyResourceFile(String fileName, File newFile) {
        CommonUtils.copyResourceFile(fileName, newFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void copyResourceFile(String fileName, File newFile, boolean forceOverwrite) {
        block25: {
            IOException ignored222;
            FilterOutputStream bos;
            BufferedInputStream bis;
            block23: {
                URL resource;
                if (newFile == null) {
                    newFile = new File(".", fileName);
                }
                if (!forceOverwrite && newFile.exists()) {
                    return;
                }
                String parentString = newFile.getParent();
                if (parentString == null) {
                    return;
                }
                File parentFile = new File(parentString);
                if (!parentFile.isDirectory()) {
                    parentFile.mkdirs();
                }
                ClassLoader cl = CommonUtils.class.getClassLoader();
                bis = null;
                bos = null;
                URL uRL = resource = cl != null ? cl.getResource(fileName) : ClassLoader.getSystemResource(fileName);
                if (resource == null) {
                    throw new NullPointerException("resource: " + fileName + " doesn't exist.");
                }
                InputStream is = resource.openStream();
                int bufferSize = 2048;
                bis = new BufferedInputStream(is, 2048);
                bos = new BufferedOutputStream(new FileOutputStream(newFile), 2048);
                byte[] buffer = new byte[2048];
                int c = 0;
                do {
                    if ((c = bis.read(buffer, 0, 2048)) <= 0) continue;
                    ((BufferedOutputStream)bos).write(buffer, 0, c);
                } while (c == 2048);
                Object var14_14 = null;
                if (bis == null) break block23;
                try {
                    bis.close();
                }
                catch (IOException ignored222) {
                    // empty catch block
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ignored222) {}
            }
            break block25;
            {
                catch (IOException e) {
                    IOException ignored222;
                    newFile.delete();
                    Object var14_15 = null;
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException ignored222) {
                            // empty catch block
                        }
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ignored222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ignored222;
                Object var14_16 = null;
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException ignored222) {
                        // empty catch block
                    }
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ignored222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static String convertFileName(String name) {
        block8: {
            int i;
            block9: {
                block7: {
                    name = I18NConvert.instance().compose(name);
                    if (name.length() > 180) {
                        int extStart = name.lastIndexOf(46);
                        if (extStart == -1) {
                            name = name.substring(0, 180);
                        } else {
                            int extLength = name.length() - extStart;
                            int extEnd = extLength > 11 ? extStart + 11 : name.length();
                            name = name.substring(0, 180 - extLength) + name.substring(extStart, extEnd);
                        }
                    }
                    for (i = 0; i < ILLEGAL_CHARS_ANY_OS.length; ++i) {
                        name = name.replace(ILLEGAL_CHARS_ANY_OS[i], '_');
                    }
                    if (!_isWindows && !_isOS2) break block7;
                    for (i = 0; i < ILLEGAL_CHARS_WINDOWS.length; ++i) {
                        name = name.replace(ILLEGAL_CHARS_WINDOWS[i], '_');
                    }
                    break block8;
                }
                if (!_isLinux && !_isSolaris) break block9;
                for (i = 0; i < ILLEGAL_CHARS_UNIX.length; ++i) {
                    name = name.replace(ILLEGAL_CHARS_UNIX[i], '_');
                }
                break block8;
            }
            if (!_isMacOSX) break block8;
            for (i = 0; i < ILLEGAL_CHARS_MACOS.length; ++i) {
                name = name.replace(ILLEGAL_CHARS_MACOS[i], '_');
            }
        }
        return name;
    }

    public static String seconds2time(int seconds) {
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        minutes -= hours * 60;
        int days = hours / 24;
        hours -= days * 24;
        StringBuffer time = new StringBuffer();
        if (days != 0) {
            time.append(Integer.toString(days));
            time.append(":");
            if (hours < 10) {
                time.append("0");
            }
        }
        if (days != 0 || hours != 0) {
            time.append(Integer.toString(hours));
            time.append(":");
            if (minutes < 10) {
                time.append("0");
            }
        }
        time.append(Integer.toString(minutes));
        time.append(":");
        if (seconds < 10) {
            time.append("0");
        }
        time.append(Integer.toString(seconds));
        return time.toString();
    }

    public static String getAllStackTraces() {
        if (!CommonUtils.isJava15OrLater()) {
            return "";
        }
        try {
            Method m = Thread.class.getDeclaredMethod("getAllStackTraces", new Class[0]);
            Map map = (Map)m.invoke(null, new Object[0]);
            ArrayList sorted = new ArrayList(map.entrySet());
            Collections.sort(sorted, new Comparator(){

                public int compare(Object a, Object b) {
                    Thread threadA = (Thread)((Map.Entry)a).getKey();
                    Thread threadB = (Thread)((Map.Entry)b).getKey();
                    return threadA.getName().compareTo(threadB.getName());
                }
            });
            StringBuffer buffer = new StringBuffer();
            Iterator it = sorted.iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                Thread key = (Thread)entry.getKey();
                StackTraceElement[] value = (StackTraceElement[])entry.getValue();
                buffer.append(key.getName()).append("\n");
                for (int i = 0; i < value.length; ++i) {
                    buffer.append("    ").append(value[i]).append("\n");
                }
                buffer.append("\n");
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            return buffer.toString();
        }
        catch (Exception err) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("An error occured during getting the StackTraces of all active Threads");
            err.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }
    }

    static {
        CURRENT_DIRECTORY = new File(PROPS.getProperty("user.dir"));
        _isPro = false;
        SETTINGS_DIRECTORY = null;
        CommonUtils.setOperatingSystems();
        if (!LIMEWIRE_VERSION.endsWith("Pro")) {
            HTTP_SERVER = "LimeWire/4.12.6";
        } else {
            HTTP_SERVER = "LimeWire/" + LIMEWIRE_VERSION.substring(0, LIMEWIRE_VERSION.length() - 4) + " (Pro)";
            _isPro = true;
        }
        _windowsFilesMoved = false;
        _xmlFilesMoved = false;
        USER_FILES = new String[]{"limewire.props", "gnutella.net", "fileurns.cache"};
    }
}

