/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.IpPort;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class IpPortImpl
implements IpPort {
    private final InetAddress addr;
    private final String addrString;
    private final int port;

    public IpPortImpl(InetSocketAddress addr) {
        this(addr.getAddress(), addr.getHostName(), addr.getPort());
    }

    public IpPortImpl(InetAddress addr, String host, int port) {
        this.addr = addr;
        this.addrString = host;
        this.port = port;
    }

    public IpPortImpl(String host, int port) throws UnknownHostException {
        this(InetAddress.getByName(host), host, port);
    }

    public IpPortImpl(String hostport) throws UnknownHostException {
        int colonIdx = hostport.indexOf(":");
        if (colonIdx == hostport.length() - 1) {
            throw new UnknownHostException("invalid hostport: " + hostport);
        }
        String host = hostport;
        int port = 80;
        if (colonIdx != -1) {
            host = hostport.substring(0, colonIdx);
            try {
                port = Integer.parseInt(hostport.substring(colonIdx + 1).trim());
            }
            catch (NumberFormatException nfe) {
                throw new UnknownHostException("invalid hostport: " + hostport);
            }
        }
        this.addr = InetAddress.getByName(host);
        this.addrString = host;
        this.port = port;
    }

    public InetAddress getInetAddress() {
        return this.addr;
    }

    public String getAddress() {
        return this.addrString;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "host: " + this.getAddress() + ", port: " + this.getPort();
    }
}

