/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.apple.cocoa.foundation.NSDictionary;
import com.apple.cocoa.foundation.NSMutableArray;
import com.apple.cocoa.foundation.NSMutableDictionary;
import com.apple.cocoa.foundation.NSObject;
import com.apple.cocoa.foundation.NSSystem;
import com.apple.cocoa.foundation.NSUserDefaults;
import com.limegroup.gnutella.util.CommonUtils;
import java.util.Enumeration;

public class MacOSXUtils {
    private static final String LOGIN_DOMAIN = "loginwindow";
    private static final String DICTIONARY = "AutoLaunchedApplicationDictionary";
    private static final String HIDE = "Hide";
    private static final String PATH = "Path";
    private static final String APP_NAME = "LimeWire At Login.app";

    private MacOSXUtils() {
    }

    private static Object createMutableClone(Object a) throws CloneNotSupportedException {
        if (a == null) {
            throw new CloneNotSupportedException();
        }
        if (!(a instanceof NSObject)) {
            throw new CloneNotSupportedException();
        }
        return ((NSObject)a).mutableClone();
    }

    public static void setLoginStatus(boolean allow) {
        NSUserDefaults defaults = NSUserDefaults.standardUserDefaults();
        Object temp = defaults.persistentDomainForName(LOGIN_DOMAIN);
        if (temp == null) {
            temp = new NSMutableDictionary();
            ((NSMutableDictionary)temp).setObjectForKey((Object)new NSMutableArray(), (Object)DICTIONARY);
        } else if (!(temp instanceof NSMutableDictionary)) {
            return;
        }
        NSMutableDictionary logins = null;
        try {
            logins = (NSMutableDictionary)MacOSXUtils.createMutableClone(temp);
        }
        catch (CloneNotSupportedException cnso) {
            return;
        }
        temp = logins.objectForKey((Object)DICTIONARY);
        if (temp == null) {
            temp = new NSMutableArray();
        } else if (!(temp instanceof NSMutableArray)) {
            return;
        }
        NSMutableArray allApps = null;
        try {
            allApps = (NSMutableArray)MacOSXUtils.createMutableClone(temp);
        }
        catch (CloneNotSupportedException cnso) {
            return;
        }
        Enumeration items = allApps.objectEnumerator();
        boolean found = false;
        while (items.hasMoreElements()) {
            String itemPath;
            temp = items.nextElement();
            if (!(temp instanceof NSMutableDictionary)) continue;
            NSMutableDictionary itemInfo = null;
            try {
                itemInfo = (NSMutableDictionary)MacOSXUtils.createMutableClone(temp);
            }
            catch (CloneNotSupportedException cnse) {
                continue;
            }
            Object path = itemInfo.objectForKey((Object)PATH);
            if (!(path instanceof String) || (itemPath = (String)path).indexOf(APP_NAME) == -1) continue;
            found = true;
            if (!allow) {
                allApps.removeIdenticalObject(temp);
                break;
            }
            itemInfo.setObjectForKey((Object)MacOSXUtils.getAppDir(), (Object)PATH);
            break;
        }
        if (!found) {
            if (!allow) {
                return;
            }
            NSMutableDictionary newItem = new NSMutableDictionary();
            newItem.setObjectForKey((Object)new Integer(0), (Object)HIDE);
            newItem.setObjectForKey((Object)MacOSXUtils.getAppDir(), (Object)PATH);
            allApps.addObject((Object)newItem);
        }
        logins.setObjectForKey((Object)allApps, (Object)DICTIONARY);
        defaults.setPersistentDomainForName((NSDictionary)logins, LOGIN_DOMAIN);
        defaults.synchronize();
    }

    public static String getUserName() {
        return NSSystem.currentFullUserName();
    }

    private static String getAppDir() {
        String appDir = "/Applications/LimeWire/";
        String path = CommonUtils.getCurrentDirectory().getPath();
        int app = path.indexOf("LimeWire.app");
        if (app != -1) {
            appDir = path.substring(0, app);
        }
        return appDir + APP_NAME;
    }
}

