/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.util.Expand;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;

public class PackagedMediaFileUtils {
    public static File preparePMFFile(String fname) {
        File lfile = null;
        String home = System.getProperty("user.home");
        String temp = home + File.separator + ".temp";
        File ftemp = new File(temp);
        ftemp.mkdir();
        File ffname = new File(fname);
        if (!ffname.exists()) {
            return lfile;
        }
        String file = temp + File.separator + PackagedMediaFileUtils.getUnpackDirectory(ffname);
        File ffile = new File(file);
        ffile.mkdir();
        try {
            lfile = PackagedMediaFileUtils.createIndexFileHandle(ffile);
            if (!lfile.exists()) {
                lfile = null;
                Expand.expandFile(ffname, ffile);
                lfile = PackagedMediaFileUtils.createIndexFileHandle(ffile);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return lfile;
    }

    private static File createIndexFileHandle(File dir) {
        File lfile = new File(dir, "index.html");
        if (!lfile.exists()) {
            lfile = new File(dir, "index.htm");
        }
        return lfile;
    }

    private static String getUnpackDirectory(File pmfFile) {
        String hash;
        try {
            byte[] hbytes = LimeXMLUtils.hashFile(pmfFile);
            if (hbytes == null || hbytes.length <= 0) {
                throw new Exception();
            }
            hash = Base32.encode(hbytes);
            hash = hash.substring(0, 6);
        }
        catch (Exception hashFailed) {
            hash = "";
        }
        String fullname = pmfFile.getName();
        if (fullname.length() > 24) {
            fullname = fullname.substring(0, 24);
        }
        return fullname + hash;
    }
}

