/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ProxyUtils {
    private static final Log LOG = LogFactory.getLog(ProxyUtils.class);

    private ProxyUtils() {
    }

    static int getProxyType(InetAddress address) {
        boolean valid;
        int connectionType = ConnectionSettings.CONNECTION_METHOD.getValue();
        boolean bl = valid = connectionType != 0 && (!NetworkUtils.isPrivateAddress(address) || ConnectionSettings.USE_PROXY_FOR_PRIVATE.getValue());
        if (valid) {
            return connectionType;
        }
        return 0;
    }

    static Socket establishProxy(int type, Socket proxySocket, InetSocketAddress addr, int timeout) throws IOException {
        switch (type) {
            case 1: {
                return ProxyUtils.establishHTTPProxy(proxySocket, addr, timeout);
            }
            case 4: {
                return ProxyUtils.establishSocksV4(proxySocket, addr, timeout);
            }
            case 5: {
                return ProxyUtils.establishSocksV5(proxySocket, addr, timeout);
            }
        }
        throw new IOException("Unknown proxy type.");
    }

    private static Socket establishSocksV4(Socket proxySocket, InetSocketAddress addr, int timeout) throws IOException {
        byte[] hostBytes = addr.getAddress().getAddress();
        int port = addr.getPort();
        byte[] portBytes = new byte[]{(byte)(port >> 8), (byte)port};
        OutputStream os = proxySocket.getOutputStream();
        InputStream in = proxySocket.getInputStream();
        proxySocket.setSoTimeout(timeout);
        os.write(4);
        os.write(1);
        os.write(portBytes);
        os.write(hostBytes);
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
            os.write(ConnectionSettings.PROXY_USERNAME.getValue().getBytes());
        }
        os.write(0);
        os.flush();
        int version = in.read();
        if (version != 0 && version != 4) {
            throw new IOException("Invalid version from socks proxy: " + version + " expected 0 or 4");
        }
        int status = in.read();
        if (status != 90) {
            throw new IOException("Request rejected with status: " + status);
        }
        byte[] connectedHostPort = new byte[2];
        byte[] connectedHostAddress = new byte[4];
        if (in.read(connectedHostPort) == -1 || in.read(connectedHostAddress) == -1) {
            throw new IOException("Connection failed");
        }
        proxySocket.setSoTimeout(0);
        return proxySocket;
    }

    private static Socket establishSocksV5(Socket proxySocket, InetSocketAddress addr, int timeout) throws IOException {
        byte[] hostBytes = addr.getAddress().getAddress();
        int port = addr.getPort();
        byte[] portBytes = new byte[]{(byte)(port >> 8), (byte)port};
        OutputStream os = proxySocket.getOutputStream();
        InputStream in = proxySocket.getInputStream();
        proxySocket.setSoTimeout(timeout);
        os.write(5);
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
            os.write(2);
            os.write(0);
            os.write(2);
        } else {
            os.write(1);
            os.write(0);
        }
        os.flush();
        int version = in.read();
        if (version != 5) {
            throw new IOException("Invalid version from socks proxy: " + version + " expected 5");
        }
        int auth_method = in.read();
        if (auth_method != 0 && auth_method == 2) {
            String username = ConnectionSettings.PROXY_USERNAME.getValue();
            String password = ConnectionSettings.PROXY_PASS.getValue();
            os.write(1);
            os.write((byte)username.length());
            os.write(username.getBytes());
            os.write((byte)password.length());
            os.write(password.getBytes());
            os.flush();
            version = in.read();
            if (version != 1) {
                throw new IOException("Invalid version for authentication: " + version + " expected 1");
            }
            int status = in.read();
            if (status != 0) {
                throw new IOException("Authentication failed with status: " + status);
            }
        }
        os.write(5);
        os.write(1);
        os.write(0);
        os.write(1);
        os.write(hostBytes);
        os.write(portBytes);
        os.flush();
        version = in.read();
        if (version != 5) {
            throw new IOException("Invalid version from socks proxy: " + version + " expected 5");
        }
        int status = in.read();
        if (status != 0) {
            throw new IOException("Request rejected with status: " + status);
        }
        in.read();
        int addrType = in.read();
        int bytesToSkip = 0;
        if (addrType == 1) {
            bytesToSkip = 6;
        } else if (addrType == 3) {
            bytesToSkip = in.read() + 2;
        } else if (addrType == 4) {
            bytesToSkip = 18;
        }
        for (int i = 0; i < bytesToSkip; ++i) {
            if (in.read() != -1) continue;
            throw new IOException("Connection failed");
        }
        proxySocket.setSoTimeout(0);
        return proxySocket;
    }

    private static Socket establishHTTPProxy(Socket proxySocket, InetSocketAddress addr, int timeout) throws IOException {
        proxySocket.setSoTimeout(timeout);
        OutputStream os = proxySocket.getOutputStream();
        InputStream in = proxySocket.getInputStream();
        String connectString = "CONNECT " + addr.getAddress().getHostAddress() + ":" + addr.getPort() + " HTTP/1.0\r\n\r\n";
        os.write(connectString.getBytes());
        os.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        if (line == null || line.indexOf("200") == -1) {
            throw new IOException("HTTP connection failed");
        }
        while (!line.equals("")) {
            line = reader.readLine();
            if (line != null) continue;
            throw new IOException("end of stream");
        }
        proxySocket.setSoTimeout(0);
        return proxySocket;
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }

    static class ProxyConnector
    implements ConnectObserver {
        private final int proxyType;
        private final ConnectObserver delegate;
        private final InetSocketAddress addr;
        private final int timeout;

        ProxyConnector(int type, ConnectObserver observer, InetSocketAddress host, int tout) {
            this.proxyType = type;
            this.delegate = observer;
            this.addr = host;
            this.timeout = tout;
        }

        public void handleConnect(Socket s) throws IOException {
            ThreadFactory.startThread(new Runnable(this, s){
                private final /* synthetic */ Socket val$s;
                private final /* synthetic */ ProxyConnector this$0;
                {
                    this.this$0 = this$0;
                    this.val$s = val$s;
                }

                public void run() {
                    try {
                        ProxyUtils.establishProxy(ProxyConnector.access$000(this.this$0), this.val$s, ProxyConnector.access$100(this.this$0), ProxyConnector.access$200(this.this$0));
                    }
                    catch (IOException iox) {
                        ProxyUtils.access$300().warn("Error establishing proxy connection", iox);
                        IOUtils.close(this.val$s);
                        this.this$0.shutdown();
                        return;
                    }
                    try {
                        ProxyConnector.access$400(this.this$0).handleConnect(this.val$s);
                    }
                    catch (IOException iox) {
                        ProxyUtils.access$300().warn("Delegate IOX", iox);
                        IOUtils.close(this.val$s);
                    }
                }
            }, "ProxyConnector");
        }

        public void shutdown() {
            this.delegate.shutdown();
        }

        public void handleIOException(IOException iox) {
        }

        public ConnectObserver getDelegateObserver() {
            return this.delegate;
        }

        static /* synthetic */ int access$000(ProxyConnector x0) {
            return x0.proxyType;
        }

        static /* synthetic */ InetSocketAddress access$100(ProxyConnector x0) {
            return x0.addr;
        }

        static /* synthetic */ int access$200(ProxyConnector x0) {
            return x0.timeout;
        }

        static /* synthetic */ ConnectObserver access$400(ProxyConnector x0) {
            return x0.delegate;
        }
    }
}

