/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.NBSocket;
import com.limegroup.gnutella.io.SocketFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.ProxyUtils;
import com.limegroup.gnutella.util.SocketController;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

class SimpleSocketController
implements SocketController {
    SimpleSocketController() {
    }

    public Socket connect(InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        int proxyType = ProxyUtils.getProxyType(addr.getAddress());
        if (proxyType != 0) {
            return this.connectProxy(proxyType, addr, timeout, observer);
        }
        return this.connectPlain(addr, timeout, observer);
    }

    public int getNumAllowedSockets() {
        return Integer.MAX_VALUE;
    }

    public boolean removeConnectObserver(ConnectObserver observer) {
        return false;
    }

    public int getNumWaitingSockets() {
        return 0;
    }

    protected Socket connectPlain(InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        NBSocket socket = SocketFactory.newSocket();
        if (observer == null) {
            socket.connect(addr, timeout);
        } else {
            socket.connect(addr, timeout, observer);
        }
        return socket;
    }

    protected Socket connectProxy(int type, InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        String proxyHost = ConnectionSettings.PROXY_HOST.getValue();
        int proxyPort = ConnectionSettings.PROXY_PORT.getValue();
        InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, proxyPort);
        if (observer != null) {
            return this.connectPlain(proxyAddr, timeout, new ProxyUtils.ProxyConnector(type, observer, addr, timeout));
        }
        Socket proxySocket = this.connectPlain(proxyAddr, timeout, null);
        try {
            return ProxyUtils.establishProxy(type, proxySocket, addr, timeout);
        }
        catch (IOException iox) {
            try {
                proxySocket.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw iox;
        }
    }
}

