/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.version.OS;
import com.limegroup.gnutella.version.UpdateData;
import com.limegroup.gnutella.version.Version;
import com.limegroup.gnutella.version.VersionFormatException;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class UpdateCollection {
    private static final Log LOG = LogFactory.getLog(UpdateCollection.class);
    private int collectionId = Integer.MIN_VALUE;
    private long collectionTimestamp = -1L;
    private List updateDataList = new LinkedList();
    private List downloadDataList = new LinkedList();

    private UpdateCollection() {
    }

    public String toString() {
        return "Update Collection, id: " + this.collectionId + ", timestamp: " + this.collectionTimestamp + ", data: " + this.updateDataList;
    }

    int getId() {
        return this.collectionId;
    }

    long getTimestamp() {
        return this.collectionTimestamp;
    }

    List getUpdateData() {
        return this.updateDataList;
    }

    List getUpdatesWithDownloadInformation() {
        return Collections.unmodifiableList(this.downloadDataList);
    }

    UpdateData getUpdateDataFor(Version currentV, String lang, boolean currentPro, int currentStyle, Version currentJava) {
        UpdateData englishMatch = null;
        UpdateData exactMatch = null;
        Iterator i = this.updateDataList.iterator();
        while (i.hasNext()) {
            UpdateData next = (UpdateData)i.next();
            if (!next.isAllowed(currentV, currentPro, currentStyle, currentJava)) continue;
            if (lang.equals(next.getLanguage())) {
                exactMatch = next;
                break;
            }
            if (!"en".equals(next.getLanguage()) || englishMatch != null) continue;
            englishMatch = next;
        }
        if (exactMatch == null) {
            return englishMatch;
        }
        return exactMatch;
    }

    static UpdateCollection create(String xml) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Parsing Update XML: " + xml);
        }
        UpdateCollection collection = new UpdateCollection();
        collection.parse(xml);
        return collection;
    }

    private void parse(String xml) {
        DOMParser parser = new DOMParser();
        InputSource is = new InputSource(new StringReader(xml));
        try {
            parser.parse(is);
        }
        catch (IOException ioe) {
            LOG.error("Unable to parse: " + xml, ioe);
            return;
        }
        catch (SAXException sax) {
            LOG.error("Unable to parse: " + xml, sax);
            return;
        }
        this.parseDocumentElement(parser.getDocument().getDocumentElement());
    }

    private void parseDocumentElement(Node doc) {
        if (!"update".equals(doc.getNodeName())) {
            return;
        }
        NamedNodeMap attr = doc.getAttributes();
        String idText = this.getAttributeText(attr, "id");
        if (idText == null) {
            LOG.error("No id attribute.");
            return;
        }
        try {
            this.collectionId = Integer.parseInt(idText);
        }
        catch (NumberFormatException nfe) {
            LOG.error("Couldn't get collection id from: " + idText, nfe);
            return;
        }
        String timestampText = this.getAttributeText(attr, "timestamp");
        if (timestampText != null) {
            try {
                this.collectionTimestamp = Long.parseLong(timestampText);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Couldn't get timestamp from: " + timestampText, nfe);
            }
        }
        NodeList children = doc.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"msg".equals(child.getNodeName())) continue;
            this.parseMsgItem(child);
        }
    }

    private void parseMsgItem(Node msg) {
        UpdateData data = new UpdateData();
        NamedNodeMap attr = msg.getAttributes();
        String fromV = this.getAttributeText(attr, "from");
        String toV = this.getAttributeText(attr, "to");
        String forV = this.getAttributeText(attr, "for");
        String pro = this.getAttributeText(attr, "pro");
        String free = this.getAttributeText(attr, "free");
        String url = this.getAttributeText(attr, "url");
        String style = this.getAttributeText(attr, "style");
        String javaFrom = this.getAttributeText(attr, "javafrom");
        String javaTo = this.getAttributeText(attr, "javato");
        String os = this.getAttributeText(attr, "os");
        String updateURN = this.getAttributeText(attr, "urn");
        String updateCommand = this.getAttributeText(attr, "ucommand");
        String updateName = this.getAttributeText(attr, "uname");
        String fileSize = this.getAttributeText(attr, "size");
        if (updateURN != null) {
            try {
                URN urn = URN.createSHA1Urn(updateURN);
                String tt = URN.getTigerTreeRoot(updateURN);
                data.setUpdateURN(urn);
                data.setUpdateTTRoot(tt);
            }
            catch (IOException ignored) {
                LOG.warn("Invalid bitprint urn: " + updateURN, ignored);
            }
        }
        data.setUpdateCommand(updateCommand);
        data.setUpdateFileName(updateName);
        if (fileSize != null) {
            try {
                data.setUpdateSize(Integer.parseInt(fileSize));
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Invalid size: " + fileSize);
            }
        }
        if (data.getUpdateURN() != null && data.getUpdateFileName() != null && data.getSize() != 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding new download data item: " + data);
            }
            this.downloadDataList.add(data);
        }
        if (forV == null || url == null || style == null) {
            LOG.error("Missing required for, url, or style.");
            return;
        }
        if (fromV == null) {
            fromV = "0.0.0";
        }
        if (toV == null) {
            toV = forV;
        }
        try {
            data.setFromVersion(new Version(fromV));
            data.setToVersion(new Version(toV));
            data.setForVersion(new Version(forV));
            if (javaFrom != null) {
                data.setFromJava(new Version(javaFrom));
            }
            if (javaTo != null) {
                data.setToJava(new Version(javaTo));
            }
        }
        catch (VersionFormatException vfe) {
            LOG.error("Invalid version", vfe);
            return;
        }
        if (pro == null && free == null) {
            data.setPro(true);
            data.setFree(true);
        } else {
            data.setPro(pro != null);
            data.setFree(free != null);
        }
        url = url.indexOf(63) == -1 ? url + "?" : url + "&";
        url = url + "pro=" + CommonUtils.isPro() + "&lang=" + this.encode(ApplicationSettings.getLanguage()) + "&lv=" + this.encode(CommonUtils.getLimeWireVersion()) + "&jv=" + this.encode(CommonUtils.getJavaVersion()) + "&os=" + this.encode(CommonUtils.getOS()) + "&osv=" + this.encode(CommonUtils.getOSVersion());
        data.setUpdateURL(url);
        try {
            data.setStyle(Integer.parseInt(style));
        }
        catch (NumberFormatException nfe) {
            LOG.error("Invalid style", nfe);
            return;
        }
        if (os == null) {
            os = "*";
        }
        data.setOSList(OS.createFromList(os));
        NodeList children = msg.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"lang".equals(child.getNodeName())) continue;
            this.parseLangItem((UpdateData)data.clone(), child);
        }
    }

    private void parseLangItem(UpdateData data, Node lang) {
        NamedNodeMap attr = lang.getAttributes();
        String id = this.getAttributeText(attr, "id");
        String button1 = this.getAttributeText(attr, "button1");
        String button2 = this.getAttributeText(attr, "button2");
        String title = this.getAttributeText(attr, "title");
        String msg = LimeXMLUtils.getTextContent(lang);
        if (id == null || msg == null || msg.equals("")) {
            LOG.error("Missing id or message.");
            return;
        }
        data.setLanguage(id);
        data.setButton1Text(button1);
        data.setButton2Text(button2);
        data.setUpdateText(msg);
        data.setUpdateTitle(title);
        this.updateDataList.add(data);
    }

    private String getAttributeText(NamedNodeMap map, String attr) {
        Node node = map.getNamedItem(attr);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private String encode(String unencoded) {
        return URLEncoder.encode(unencoded);
    }
}

