/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.security.SignatureVerifier;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.UpdateSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.version.Clock;
import com.limegroup.gnutella.version.DownloadInformation;
import com.limegroup.gnutella.version.UpdateCollection;
import com.limegroup.gnutella.version.UpdateData;
import com.limegroup.gnutella.version.UpdateInformation;
import com.limegroup.gnutella.version.Version;
import com.limegroup.gnutella.version.VersionFormatException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateHandler {
    private static final Log LOG = LogFactory.getLog(UpdateHandler.class);
    private static final long THREE_DAYS = 259200000L;
    private static final String FILENAME = "version.xml";
    private static final String KEY = "version.key";
    private static final Random RANDOM = new Random();
    private static Clock clock = new Clock();
    private static final UpdateHandler INSTANCE = new UpdateHandler();
    private final ProcessingQueue QUEUE = new ProcessingQueue("UpdateHandler");
    private volatile UpdateInformation _updateInfo;
    private volatile List _updatesToDownload;
    private volatile int _lastId;
    private volatile byte[] _lastBytes;
    private long _lastTimestamp;
    private long _nextDownloadTime;
    private boolean _killingObsoleteNecessary;

    private UpdateHandler() {
        this.initialize();
    }

    public static UpdateHandler instance() {
        return INSTANCE;
    }

    private void initialize() {
        LOG.trace("Initializing UpdateHandler");
        this.QUEUE.add(new Runnable(){

            public void run() {
                UpdateHandler.this.handleDataInternal(FileUtils.readFileFully(UpdateHandler.this.getStoredFile()), true);
            }
        });
        RouterService.schedule(new Runnable(){

            public void run() {
                UpdateHandler.this.QUEUE.add(new Poller());
            }
        }, UpdateSettings.UPDATE_RETRY_DELAY.getValue(), 0L);
    }

    public void tryToDownloadUpdates() {
        this.QUEUE.add(new Runnable(){

            public void run() {
                UpdateInformation updateInfo = UpdateHandler.this._updateInfo;
                if (updateInfo != null && updateInfo.getUpdateURN() != null && UpdateHandler.isMyUpdateDownloaded(updateInfo)) {
                    RouterService.getCallback().updateAvailable(updateInfo);
                }
                UpdateHandler.this.downloadUpdates(UpdateHandler.this._updatesToDownload, null);
            }
        });
    }

    public void handleUpdateAvailable(final ReplyHandler rh, final int version) {
        if (version == this._lastId) {
            this.QUEUE.add(new Runnable(){

                public void run() {
                    UpdateHandler.this.addSourceIfIdMatches(rh, version);
                }
            });
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Another version from rh: " + rh + ", them: " + version + ", me: " + this._lastId);
        }
    }

    public void handleNewData(final byte[] data) {
        if (data != null) {
            this.QUEUE.add(new Runnable(){

                public void run() {
                    LOG.trace("Parsing new data...");
                    UpdateHandler.this.handleDataInternal(data, false);
                }
            });
        }
    }

    public int getLatestId() {
        return this._lastId;
    }

    public byte[] getLatestBytes() {
        return this._lastBytes;
    }

    private void handleDataInternal(byte[] data, boolean fromDisk) {
        if (data != null) {
            String xml = SignatureVerifier.getVerifiedData(data, this.getKeyFile(), "DSA", "SHA1");
            if (xml != null) {
                UpdateCollection uc = UpdateCollection.create(xml);
                if (uc.getId() > this._lastId) {
                    this.storeAndUpdate(data, uc, fromDisk);
                }
            } else {
                LOG.warn("Couldn't verify signature on data.");
            }
        } else {
            LOG.warn("No data to handle.");
        }
    }

    private void storeAndUpdate(byte[] data, UpdateCollection uc, boolean fromDisk) {
        Version limeV;
        LOG.trace("Retrieved new data, storing & updating.");
        this._lastId = uc.getId();
        this._lastTimestamp = uc.getTimestamp();
        long delay = UpdateSettings.UPDATE_DOWNLOAD_DELAY.getValue();
        long random = Math.abs(RANDOM.nextLong() % delay);
        this._nextDownloadTime = this._lastTimestamp + random;
        this._lastBytes = data;
        if (!fromDisk) {
            FileUtils.verySafeSave(CommonUtils.getUserSettingsDir(), FILENAME, data);
            CapabilitiesVM.reconstructInstance();
            RouterService.getConnectionManager().sendUpdatedCapabilities();
        }
        try {
            limeV = new Version(CommonUtils.getLimeWireVersion());
        }
        catch (VersionFormatException vfe) {
            LOG.warn("Invalid LimeWire version", vfe);
            return;
        }
        Version javaV = null;
        try {
            javaV = new Version(CommonUtils.getJavaVersion());
        }
        catch (VersionFormatException vfe) {
            LOG.warn("Invalid java version", vfe);
        }
        int style = Math.min(2, UpdateSettings.UPDATE_STYLE.getValue());
        UpdateData updateInfo = uc.getUpdateDataFor(limeV, ApplicationSettings.getLanguage(), CommonUtils.isPro(), style, javaV);
        LinkedList<UpdateData> updatesToDownload = uc.getUpdatesWithDownloadInformation();
        this._killingObsoleteNecessary = true;
        if (updateInfo != null && updateInfo.getUpdateURN() != null) {
            UpdateHandler.prepareUpdateCommand(updateInfo);
            updatesToDownload = new LinkedList<UpdateData>(updatesToDownload);
            updatesToDownload.add(0, updateInfo);
        }
        this._updateInfo = updateInfo;
        this._updatesToDownload = updatesToDownload;
        this.downloadUpdates(updatesToDownload, null);
        if (updateInfo == null) {
            LOG.warn("No relevant update info to notify about.");
            return;
        }
        if (updateInfo.getUpdateURN() == null || UpdateHandler.isHopeless(updateInfo)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("we have an update, but it doesn't need a download.  or all our updates are hopeles. Scheduling URL notification...");
            }
            updateInfo.setUpdateCommand(null);
            RouterService.schedule(new NotificationFailover(this._lastId), UpdateHandler.delay(clock.now(), uc.getTimestamp()), 0L);
        } else if (UpdateHandler.isMyUpdateDownloaded(updateInfo)) {
            LOG.debug("there is an update for me, but I happen to have it on disk");
            RouterService.getCallback().updateAvailable(updateInfo);
        } else {
            LOG.debug("we have an update, it needs a download.  Rely on callbacks");
        }
    }

    private static void prepareUpdateCommand(UpdateData info) {
        if (info == null || info.getUpdateCommand() == null) {
            return;
        }
        File path = FileManager.PREFERENCE_SHARE.getAbsoluteFile();
        String name = info.getUpdateFileName();
        try {
            path = FileUtils.getCanonicalFile(path);
        }
        catch (IOException bad) {
            // empty catch block
        }
        String command = info.getUpdateCommand();
        command = StringUtils.replace(command, "$", path.getPath() + File.separator);
        command = StringUtils.replace(command, "%", name);
        info.setUpdateCommand(command);
    }

    private static boolean isHopeless(DownloadInformation info) {
        return UpdateSettings.FAILED_UPDATES.contains(info.getUpdateURN().httpStringValue());
    }

    private void addSourceIfIdMatches(ReplyHandler rh, int version) {
        if (version == this._lastId) {
            this.downloadUpdates(this._updatesToDownload, rh);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Another version? Me: " + version + ", here: " + this._lastId);
        }
    }

    private void downloadUpdates(List toDownload, ReplyHandler source) {
        if (toDownload == null) {
            toDownload = Collections.EMPTY_LIST;
        }
        this.killObsoleteUpdates(toDownload);
        Iterator i = toDownload.iterator();
        while (i.hasNext()) {
            DownloadInformation next = (DownloadInformation)i.next();
            if (UpdateHandler.isHopeless(next)) continue;
            DownloadManager dm = RouterService.getDownloadManager();
            FileManager fm = RouterService.getFileManager();
            if (!dm.isGUIInitd() || !fm.isLoadFinished()) continue;
            FileDesc shared = fm.getFileDescForUrn(next.getUpdateURN());
            ManagedDownloader md = dm.getDownloaderForURN(next.getUpdateURN());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Looking for: " + next + ", got: " + shared);
            }
            if (shared != null && shared.getClass() == (class$com$limegroup$gnutella$FileDesc == null ? UpdateHandler.class$("com.limegroup.gnutella.FileDesc") : class$com$limegroup$gnutella$FileDesc)) {
                if (md == null) continue;
                md.stop();
                continue;
            }
            if (md == null && !dm.hasInNetworkDownload() && this.canStartDownload()) {
                LOG.debug("Starting a new InNetwork Download");
                try {
                    md = (ManagedDownloader)dm.download(next, clock.now());
                }
                catch (SaveLocationException sle) {
                    LOG.error("Unable to construct download", sle);
                }
            }
            if (md == null) continue;
            if (source != null) {
                md.addDownload(this.rfd(source, next), false);
                continue;
            }
            this.addCurrentDownloadSources(md, next);
        }
    }

    private void killObsoleteUpdates(List toDownload) {
        DownloadManager dm = RouterService.getDownloadManager();
        FileManager fm = RouterService.getFileManager();
        if (!dm.isGUIInitd() || !fm.isLoadFinished()) {
            return;
        }
        if (this._killingObsoleteNecessary) {
            this._killingObsoleteNecessary = false;
            dm.killDownloadersNotListed(toDownload);
            HashSet<URN> urns = new HashSet<URN>(toDownload.size());
            Iterator iter = toDownload.iterator();
            while (iter.hasNext()) {
                UpdateData data = (UpdateData)iter.next();
                urns.add(data.getUpdateURN());
            }
            FileDesc[] shared = fm.getSharedFileDescriptors(FileManager.PREFERENCE_SHARE);
            for (int i = 0; i < shared.length; ++i) {
                if (shared[i].getSHA1Urn() == null || urns.contains(shared[i].getSHA1Urn())) continue;
                fm.removeFileIfShared(shared[i].getFile());
                shared[i].getFile().delete();
            }
        }
    }

    private void addCurrentDownloadSources(ManagedDownloader md, DownloadInformation info) {
        List connections = RouterService.getConnectionManager().getConnections();
        Iterator i = connections.iterator();
        while (i.hasNext()) {
            ManagedConnection mc = (ManagedConnection)i.next();
            if (mc.getRemoteHostUpdateVersion() == this._lastId) {
                LOG.debug("Adding source: " + mc);
                md.addDownload(this.rfd(mc, info), false);
                continue;
            }
            LOG.debug("Not adding source because bad id: " + mc.getRemoteHostUpdateVersion() + ", us: " + this._lastId);
        }
    }

    private RemoteFileDesc rfd(ReplyHandler rh, DownloadInformation info) {
        HashSet<URN> urns = new HashSet<URN>(1);
        urns.add(info.getUpdateURN());
        return new RemoteFileDesc(rh.getAddress(), rh.getPort(), Integer.MAX_VALUE, info.getUpdateFileName(), (int)info.getSize(), rh.getClientGUID(), 0, false, 2, false, null, urns, false, false, "LIME", System.currentTimeMillis(), Collections.EMPTY_SET, 0L, 0);
    }

    private boolean canStartDownload() {
        long now = clock.now();
        if (LOG.isDebugEnabled()) {
            LOG.debug("now is " + now + " next time is " + this._nextDownloadTime);
        }
        return now > this._nextDownloadTime;
    }

    private void notifyAboutInfo(int id) {
        if (id != this._lastId) {
            return;
        }
        UpdateInformation update = this._updateInfo;
        Assert.that(update != null);
        RouterService.getCallback().updateAvailable(update);
    }

    private static long delay(long now, long timestamp) {
        if (timestamp - now > 259200000L) {
            return 0L;
        }
        long delay = UpdateSettings.UPDATE_DELAY.getValue();
        long random = Math.abs(new Random().nextLong() % delay);
        long then = timestamp + random;
        if (LOG.isInfoEnabled()) {
            LOG.info("Delaying Update.\nNow    : " + now + "\nStamp  : " + timestamp + "\nDelay  : " + delay + "\nRandom : " + random + "\nThen   : " + then + "\nDiff   : " + (then - now));
        }
        return Math.max(0L, then - now);
    }

    public void inNetworkDownloadFinished(final URN urn, final boolean good) {
        Runnable r = new Runnable(){

            public void run() {
                UpdateData updateInfo;
                if (!good) {
                    UpdateSettings.FAILED_UPDATES.add(urn.httpStringValue());
                }
                if ((updateInfo = (UpdateData)UpdateHandler.this._updateInfo) != null && updateInfo.getUpdateURN() != null && updateInfo.getUpdateURN().equals(urn)) {
                    if (!good) {
                        updateInfo.setUpdateCommand(null);
                        long delay = UpdateHandler.delay(clock.now(), UpdateHandler.this._lastTimestamp);
                        RouterService.schedule(new NotificationFailover(UpdateHandler.this._lastId), delay, 0L);
                    } else {
                        RouterService.getCallback().updateAvailable(updateInfo);
                    }
                }
            }
        };
        this.QUEUE.add(r);
    }

    private static void killHopelessUpdates(List updates) {
        if (updates == null) {
            return;
        }
        DownloadManager dm = RouterService.getDownloadManager();
        if (!dm.hasInNetworkDownload()) {
            return;
        }
        long now = clock.now();
        Iterator iter = updates.iterator();
        while (iter.hasNext()) {
            InNetworkDownloader iDownloader;
            DownloadInformation info = (DownloadInformation)iter.next();
            ManagedDownloader downloader = dm.getDownloaderForURN(info.getUpdateURN());
            if (downloader == null || !(downloader instanceof InNetworkDownloader) || !UpdateHandler.isHopeless(iDownloader = (InNetworkDownloader)downloader, now)) continue;
            iDownloader.stop();
        }
    }

    private static boolean isHopeless(InNetworkDownloader downloader, long now) {
        if (now - downloader.getStartTime() < (long)UpdateSettings.UPDATE_GIVEUP_FACTOR.getValue() * UpdateSettings.UPDATE_DOWNLOAD_DELAY.getValue()) {
            return false;
        }
        return downloader.getNumAttempts() >= UpdateSettings.UPDATE_MIN_ATTEMPTS.getValue();
    }

    private static boolean isMyUpdateDownloaded(UpdateInformation myInfo) {
        FileManager fm = RouterService.getFileManager();
        if (!fm.isLoadFinished()) {
            return false;
        }
        URN myUrn = myInfo.getUpdateURN();
        if (myUrn == null) {
            return true;
        }
        FileDesc desc = fm.getFileDescForUrn(myUrn);
        if (desc == null) {
            return false;
        }
        return desc.getClass() == FileDesc.class;
    }

    private File getStoredFile() {
        return new File(CommonUtils.getUserSettingsDir(), FILENAME);
    }

    private File getKeyFile() {
        return new File(CommonUtils.getUserSettingsDir(), KEY);
    }

    private class NotificationFailover
    implements Runnable {
        private final int id;
        private boolean shown;

        NotificationFailover(int id) {
            this.id = id;
        }

        public void run() {
            if (this.shown) {
                return;
            }
            this.shown = true;
            UpdateHandler.this.notifyAboutInfo(this.id);
        }
    }

    private class Poller
    implements Runnable {
        private Poller() {
        }

        public void run() {
            UpdateHandler.this.downloadUpdates(UpdateHandler.this._updatesToDownload, null);
            UpdateHandler.killHopelessUpdates(UpdateHandler.this._updatesToDownload);
            RouterService.schedule(new Runnable(this){
                private final /* synthetic */ Poller this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    UpdateHandler.access$300(Poller.access$1500(this.this$1)).add(Poller.access$1500(this.this$1).new Poller());
                }
            }, UpdateSettings.UPDATE_RETRY_DELAY.getValue(), 0L);
        }

        static /* synthetic */ UpdateHandler access$1500(Poller x0) {
            return x0.UpdateHandler.this;
        }
    }
}

