/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LimeXMLUtils {
    private static final double MATCHING_RATE = 0.9;
    private static final String C_HEADER_BEGIN = "{";
    private static final String C_HEADER_END = "}";
    private static final String C_HEADER_NONE_VAL = "plaintext";
    private static final String C_HEADER_ZLIB_VAL = "deflate";
    private static final String C_HEADER_GZIP_VAL = "gzip";
    private static final String COMPRESS_HEADER_ZLIB = "{deflate}";
    private static final String COMPRESS_HEADER_GZIP = "{gzip}";
    private static final String COMPRESS_HEADER_NONE = "{}";
    private static final int NONE = 0;
    private static final int GZIP = 1;
    private static final int ZLIB = 2;
    private static final int NUM_BYTES_TO_HASH = 100;
    private static final int NUM_TOTAL_HASH = 300;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputSource getInputSource(File file) throws IOException {
        StringBuffer sb = new StringBuffer();
        String line = "";
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            while (line != null) {
                line = br.readLine();
                if (line == null) continue;
                sb.append(line + "\n");
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return new InputSource(new StringReader(sb.toString()));
    }

    public static String getTextContent(Node node) {
        return LimeXMLUtils.getText(node.getChildNodes());
    }

    public static String getText(NodeList nodeList) {
        StringBuffer buffer = new StringBuffer();
        block4: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    buffer.append(node.getNodeValue());
                    continue block4;
                }
                case 5: {
                    if (node.getNodeName().equals("amp")) {
                        buffer.append('&');
                        continue block4;
                    }
                    if (node.getNodeName().equals("lt")) {
                        buffer.append('<');
                        continue block4;
                    }
                    if (node.getNodeName().equals("gt")) {
                        buffer.append('>');
                        continue block4;
                    }
                    if (node.getNodeName().equals("apos")) {
                        buffer.append('\'');
                        continue block4;
                    }
                    if (!node.getNodeName().equals("quot")) continue block4;
                    buffer.append('\"');
                    continue block4;
                }
            }
        }
        return buffer.toString();
    }

    public static void writeEscapedString(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c == '>') {
                writer.write("&gt;");
                continue;
            }
            if (c == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c == '\'') {
                writer.write("&apos;");
                continue;
            }
            if (c == '\"') {
                writer.write("&quot;");
                continue;
            }
            writer.write(c);
        }
    }

    public static byte[] readFully(InputStream in) throws IOException {
        int bytesRead;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) != -1) {
            byteArray.write(buffer, 0, bytesRead);
        }
        return byteArray.toByteArray();
    }

    public static boolean match(LimeXMLDocument replyDoc, LimeXMLDocument queryDoc, boolean allowAllNulls) {
        if (queryDoc == null || replyDoc == null) {
            throw new NullPointerException("querying with null doc.");
        }
        Set queryNameValues = queryDoc.getNameValueSet();
        int size = queryNameValues.size();
        int matchCount = 0;
        int nullCount = 0;
        boolean matchedBitrate = false;
        Iterator i = queryNameValues.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String currFieldName = (String)entry.getKey();
            String queryValue = (String)entry.getValue();
            Assert.that(queryValue != null, "null value");
            if (queryValue.equals("")) continue;
            String replyDocValue = replyDoc.getValue(currFieldName);
            if (currFieldName.endsWith("license_type__") && queryValue.length() > 0 && (replyDocValue == null || !replyDocValue.startsWith(queryValue))) {
                return false;
            }
            if (replyDocValue == null || replyDocValue.equals("")) {
                ++nullCount;
                continue;
            }
            try {
                double qVD;
                double rDVD = new Double(replyDocValue);
                if (rDVD != (qVD = new Double(queryValue).doubleValue())) continue;
                ++matchCount;
                if (!currFieldName.equals("audios__audio__bitrate__")) continue;
                matchedBitrate = true;
            }
            catch (NumberFormatException nfe) {
                String queryValueLC = queryValue.toLowerCase(Locale.US);
                String replyDocValueLC = I18NConvert.instance().getNorm(replyDocValue);
                if (!replyDocValueLC.startsWith(queryValueLC) && replyDocValueLC.indexOf(" " + queryValueLC) < 0) continue;
                ++matchCount;
            }
        }
        double sizeD = size;
        double matchCountD = matchCount;
        double nullCountD = nullCount;
        if (size > 1) {
            if (matchedBitrate) {
                sizeD -= 1.0;
                matchCountD -= 1.0;
                --matchCount;
            }
            if ((nullCountD + matchCountD) / sizeD < 0.9) {
                return false;
            }
            return allowAllNulls || matchCount > 0;
        }
        if (size == 1) {
            if (allowAllNulls && nullCount == 1) {
                return true;
            }
            return !(matchCountD / sizeD < 1.0);
        }
        return false;
    }

    public static boolean isMP3File(File in) {
        return LimeXMLUtils.isMP3File(in.getName());
    }

    public static boolean isMP3File(String in) {
        return in.toLowerCase(Locale.US).endsWith(".mp3");
    }

    public static boolean isRIFFFile(File f) {
        return LimeXMLUtils.isRIFFFile(f.getName());
    }

    public static boolean isRIFFFile(String in) {
        return in.toLowerCase(Locale.US).endsWith(".avi");
    }

    public static boolean isOGMFile(File f) {
        return LimeXMLUtils.isOGMFile(f.getName());
    }

    public static boolean isOGMFile(String in) {
        return in.toLowerCase(Locale.US).endsWith(".ogm");
    }

    public static boolean isOGGFile(File in) {
        return LimeXMLUtils.isOGGFile(in.getName());
    }

    public static boolean isOGGFile(String in) {
        return in.toLowerCase(Locale.US).endsWith(".ogg");
    }

    public static boolean isFLACFile(File in) {
        return LimeXMLUtils.isFLACFile(in.getName());
    }

    public static boolean isFLACFile(String in) {
        return (in = in.toLowerCase(Locale.US)).endsWith(".flac") || in.endsWith(".fla");
    }

    public static boolean isM4AFile(File in) {
        return LimeXMLUtils.isM4AFile(in.getName());
    }

    public static boolean isM4AFile(String in) {
        return (in = in.toLowerCase(Locale.US)).endsWith(".m4a") || in.endsWith(".m4p");
    }

    public static boolean isWMAFile(File f) {
        return LimeXMLUtils.isWMAFile(f.getName());
    }

    public static boolean isWMAFile(String in) {
        return in.toLowerCase(Locale.US).endsWith(".wma");
    }

    public static boolean isWMVFile(File f) {
        return LimeXMLUtils.isWMVFile(f.getName());
    }

    public static boolean isWMVFile(String in) {
        return in.toLowerCase(Locale.US).endsWith(".wmv");
    }

    public static boolean isASFFile(File f) {
        return LimeXMLUtils.isASFFile(f.getName());
    }

    public static boolean isASFFile(String in) {
        return (in = in.toLowerCase(Locale.US)).endsWith(".asf") || in.endsWith(".wm");
    }

    public static boolean isSupportedAudioFormat(File file) {
        return LimeXMLUtils.isSupportedAudioFormat(file.getName());
    }

    public static boolean isSupportedAudioFormat(String file) {
        return LimeXMLUtils.isMP3File(file) || LimeXMLUtils.isOGGFile(file) || LimeXMLUtils.isM4AFile(file) || LimeXMLUtils.isWMAFile(file) || LimeXMLUtils.isFLACFile(file);
    }

    public static boolean isSupportedVideoFormat(File file) {
        return LimeXMLUtils.isSupportedVideoFormat(file.getName());
    }

    public static boolean isSupportedVideoFormat(String file) {
        return LimeXMLUtils.isRIFFFile(file) || LimeXMLUtils.isOGMFile(file) || LimeXMLUtils.isWMVFile(file);
    }

    public static boolean isSupportedMultipleFormat(File file) {
        return LimeXMLUtils.isSupportedMultipleFormat(file.getName());
    }

    public static boolean isSupportedMultipleFormat(String file) {
        return LimeXMLUtils.isASFFile(file);
    }

    public static boolean isSupportedFormat(File file) {
        return LimeXMLUtils.isSupportedFormat(file.getName());
    }

    public static boolean isSupportedFormat(String file) {
        return LimeXMLUtils.isSupportedAudioFormat(file) || LimeXMLUtils.isSupportedVideoFormat(file) || LimeXMLUtils.isSupportedMultipleFormat(file);
    }

    public static boolean isEditableFormat(File file) {
        return LimeXMLUtils.isEditableFormat(file.getName());
    }

    public static boolean isEditableFormat(String file) {
        return LimeXMLUtils.isMP3File(file) || LimeXMLUtils.isOGGFile(file);
    }

    public static boolean isSupportedFormatForSchema(File file, String schemaURI) {
        if (LimeXMLUtils.isSupportedMultipleFormat(file)) {
            return true;
        }
        if ("http://www.limewire.com/schemas/audio.xsd".equals(schemaURI)) {
            return LimeXMLUtils.isSupportedAudioFormat(file);
        }
        if ("http://www.limewire.com/schemas/video.xsd".equals(schemaURI)) {
            return LimeXMLUtils.isSupportedVideoFormat(file);
        }
        return false;
    }

    public static boolean isFilePublishable(String file) {
        return LimeXMLUtils.isMP3File(file) || LimeXMLUtils.isOGGFile(file);
    }

    public static String encodeXML(String inData) {
        if (inData == null) {
            return null;
        }
        if (inData.indexOf(38) == -1 && inData.indexOf(60) == -1 && inData.indexOf(62) == -1 && inData.indexOf(39) == -1 && inData.indexOf(34) == -1) {
            return inData;
        }
        int length = inData.length();
        StringBuffer buffer = new StringBuffer(2 * length);
        for (int i = 0; i < length; ++i) {
            char charToCompare = inData.charAt(i);
            if (charToCompare == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (charToCompare == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (charToCompare == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (charToCompare == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (charToCompare == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(charToCompare);
        }
        return buffer.toString();
    }

    public static byte[] compress(byte[] data) {
        byte[] compressedData = null;
        if (LimeXMLUtils.shouldCompress(data)) {
            compressedData = LimeXMLUtils.compressZLIB(data);
        }
        byte[] retBytes = null;
        if (compressedData != null) {
            retBytes = new byte[COMPRESS_HEADER_ZLIB.length() + compressedData.length];
            System.arraycopy(COMPRESS_HEADER_ZLIB.getBytes(), 0, retBytes, 0, COMPRESS_HEADER_ZLIB.length());
            System.arraycopy(compressedData, 0, retBytes, COMPRESS_HEADER_ZLIB.length(), compressedData.length);
        } else {
            retBytes = new byte[COMPRESS_HEADER_NONE.length() + data.length];
            System.arraycopy(COMPRESS_HEADER_NONE.getBytes(), 0, retBytes, 0, COMPRESS_HEADER_NONE.length());
            System.arraycopy(data, 0, retBytes, COMPRESS_HEADER_NONE.length(), data.length);
        }
        return retBytes;
    }

    private static boolean shouldCompress(byte[] data) {
        return data.length >= 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] compressZLIB(byte[] data) {
        byte[] byArray;
        DeflaterOutputStream gos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            gos = new DeflaterOutputStream(baos);
            gos.write(data, 0, data.length);
            gos.flush();
            gos.close();
            byArray = baos.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                Assert.that(false, "Couldn't write to byte stream");
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(gos);
                throw throwable;
            }
            IOUtils.close(gos);
            return byArray2;
        }
        IOUtils.close(gos);
        return byArray;
    }

    public static byte[] uncompress(byte[] data) throws IOException {
        byte[] retBytes = new byte[]{};
        String headerFragment = new String(data, 0, C_HEADER_BEGIN.length());
        if (headerFragment.equals(C_HEADER_BEGIN)) {
            int i;
            boolean found = false;
            for (i = 0; i < data.length && !found; ++i) {
                if (data[i] != 125) continue;
                found = true;
            }
            headerFragment = new String(data, 1, i - 1 - 1);
            int comp = LimeXMLUtils.getCompressionType(headerFragment);
            if (comp == 0) {
                retBytes = new byte[data.length - (headerFragment.length() + 2)];
                System.arraycopy(data, i, retBytes, 0, data.length - (headerFragment.length() + 2));
            } else if (comp == 1) {
                retBytes = new byte[data.length - COMPRESS_HEADER_GZIP.length()];
                System.arraycopy(data, COMPRESS_HEADER_GZIP.length(), retBytes, 0, data.length - COMPRESS_HEADER_GZIP.length());
                retBytes = LimeXMLUtils.uncompressGZIP(retBytes);
            } else if (comp == 2) {
                retBytes = new byte[data.length - COMPRESS_HEADER_ZLIB.length()];
                System.arraycopy(data, COMPRESS_HEADER_ZLIB.length(), retBytes, 0, data.length - COMPRESS_HEADER_ZLIB.length());
                retBytes = LimeXMLUtils.uncompressZLIB(retBytes);
            }
        } else {
            return data;
        }
        return retBytes;
    }

    private static int getCompressionType(String header) {
        String s = header.trim();
        if (s.equals("") || s.equalsIgnoreCase(C_HEADER_NONE_VAL)) {
            return 0;
        }
        if (s.equalsIgnoreCase(C_HEADER_GZIP_VAL)) {
            return 1;
        }
        if (s.equalsIgnoreCase(C_HEADER_ZLIB_VAL)) {
            return 2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] uncompressGZIP(byte[] data) throws IOException {
        byte[] byArray;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        GZIPInputStream gis = null;
        try {
            int b;
            gis = new GZIPInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = gis.read()) != -1) {
                baos.write(b);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.close(gis);
            throw throwable;
        }
        IOUtils.close(gis);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] uncompressZLIB(byte[] data) throws IOException {
        byte[] byArray;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        InflaterInputStream gis = null;
        try {
            int b;
            gis = new InflaterInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = gis.read()) != -1) {
                baos.write(b);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.close(gis);
            throw throwable;
        }
        IOUtils.close(gis);
        return byArray;
    }

    private static void clearHashBytes(byte[] hashBytes) {
        for (int i = 0; i < 100; ++i) {
            hashBytes[i] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hashFile(File toHash) throws IOException {
        byte[] retBytes = null;
        FileInputStream fis = null;
        byte[] hashBytes = new byte[100];
        try {
            fis = new FileInputStream(toHash);
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException nsae) {
                Assert.that(false, "no sha algorithm.");
            }
            long fileLength = toHash.length();
            if (fileLength < 300L) {
                int numRead = 0;
                do {
                    LimeXMLUtils.clearHashBytes(hashBytes);
                    numRead = fis.read(hashBytes);
                    md.update(hashBytes);
                    if (toHash.length() == fileLength) continue;
                    throw new IOException("invalid length");
                } while (numRead == 100);
            } else {
                long thirds = fileLength / 3L;
                LimeXMLUtils.clearHashBytes(hashBytes);
                fis.read(hashBytes);
                md.update(hashBytes);
                if (toHash.length() != fileLength) {
                    throw new IOException("invalid length");
                }
                LimeXMLUtils.clearHashBytes(hashBytes);
                fis.skip(thirds - 100L);
                fis.read(hashBytes);
                md.update(hashBytes);
                if (toHash.length() != fileLength) {
                    throw new IOException("invalid length");
                }
                LimeXMLUtils.clearHashBytes(hashBytes);
                fis.skip(toHash.length() - (thirds + 100L) - 100L);
                fis.read(hashBytes);
                md.update(hashBytes);
                if (toHash.length() != fileLength) {
                    throw new IOException("invalid length");
                }
            }
            retBytes = md.digest();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return retBytes;
    }
}

