/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.ErrorService;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParsingUtils {
    private static final Log LOG = LogFactory.getLog(XMLParsingUtils.class);
    private static final String XML_START = "<?xml";
    private static ThreadLocal _parserContainer = new ThreadLocal(){

        protected Object initialValue() {
            return new LimeParser();
        }
    };

    public static ParseResult parse(String xml, int responseCount) throws IOException, SAXException {
        return XMLParsingUtils.parse(new InputSource(new StringReader(xml)), responseCount);
    }

    public static ParseResult parse(InputSource inputSource) throws IOException, SAXException {
        return XMLParsingUtils.parse(inputSource, 8);
    }

    public static ParseResult parse(InputSource inputSource, int responseCount) throws IOException, SAXException {
        ParseResult result = new ParseResult(responseCount);
        LimeParser parser = (LimeParser)_parserContainer.get();
        parser.parse(result, inputSource);
        return result;
    }

    public static List split(String aggregatedXmlDocuments) {
        ArrayList<String> results = new ArrayList<String>();
        int begin = aggregatedXmlDocuments.indexOf(XML_START);
        int end = aggregatedXmlDocuments.indexOf(XML_START, begin + 1);
        while (end != -1) {
            results.add(aggregatedXmlDocuments.substring(begin, end));
            begin = end;
            end = aggregatedXmlDocuments.indexOf(XML_START, begin + 1);
        }
        if (begin != -1) {
            results.add(aggregatedXmlDocuments.substring(begin));
        }
        return results;
    }

    private static class LimeParser
    extends DefaultHandler {
        private final XMLReader _reader;
        private ParseResult _result;
        boolean _isFirstElement = true;

        LimeParser() {
            SAXParser reader;
            try {
                reader = new SAXParser();
                reader.setContentHandler(this);
                reader.setFeature("http://xml.org/sax/features/namespaces", false);
            }
            catch (SAXException bad) {
                ErrorService.error(bad);
                reader = null;
            }
            this._reader = reader;
        }

        public void parse(ParseResult dest, InputSource input) throws SAXException, IOException {
            if (this._reader == null) {
                return;
            }
            this._isFirstElement = true;
            this._result = dest;
            this._reader.parse(input);
        }

        public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) {
            int attributesLength;
            if (this._isFirstElement) {
                this._isFirstElement = false;
                this._result.canonicalKeyPrefix = qualifiedName;
                return;
            }
            if (this._result.type == null) {
                this._result.type = qualifiedName;
                this._result.schemaURI = "http://www.limewire.com/schemas/" + this._result.type + ".xsd";
                this._result.canonicalKeyPrefix = this._result.canonicalKeyPrefix + "__" + qualifiedName + "__";
            }
            if ((attributesLength = attributes.getLength()) > 0) {
                HashMap<String, String> attributeMap = new HashMap<String, String>(attributesLength);
                for (int i = 0; i < attributesLength; ++i) {
                    attributeMap.put(this._result.canonicalKeyPrefix + attributes.getQName(i) + "__", attributes.getValue(i).trim());
                }
                this._result.add(attributeMap);
            } else {
                this._result.add(Collections.EMPTY_MAP);
            }
        }
    }

    public static class ParseResult
    extends ArrayList {
        public String schemaURI;
        public String type;
        public String canonicalKeyPrefix;

        public ParseResult(int size) {
            super(size * 2 / 3);
        }
    }
}

