/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.chunks.ByteChunk;
import de.kapsi.net.daap.chunks.Chunk;
import de.kapsi.net.daap.chunks.ChunkFactory;
import de.kapsi.net.daap.chunks.ContainerChunk;
import de.kapsi.net.daap.chunks.DateChunk;
import de.kapsi.net.daap.chunks.IntChunk;
import de.kapsi.net.daap.chunks.LongChunk;
import de.kapsi.net.daap.chunks.ShortChunk;
import de.kapsi.net.daap.chunks.StringChunk;
import de.kapsi.net.daap.chunks.VersionChunk;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapInputStream
extends FilterInputStream {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$DaapInputStream == null ? (class$de$kapsi$net$daap$DaapInputStream = DaapInputStream.class$("de.kapsi.net.daap.DaapInputStream")) : class$de$kapsi$net$daap$DaapInputStream));
    private ChunkFactory factory = null;
    static /* synthetic */ Class class$de$kapsi$net$daap$DaapInputStream;

    public DaapInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int b = super.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    public int read(int length) throws IOException {
        this.skip(length - 1);
        return this.read();
    }

    public int readShort(int length) throws IOException {
        this.skip(length - 2);
        return this.read() << 8 | this.read();
    }

    public int readInt(int length) throws IOException {
        this.skip(length - 4);
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    public long readLong(int length) throws IOException {
        this.skip(length - 8);
        return this.read() << 54 | this.read() << 48 | this.read() << 40 | this.read() << 32 | this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    public String readString(int length) throws IOException {
        if (length == 0) {
            return null;
        }
        byte[] b = new byte[length];
        this.read(b, 0, b.length);
        return new String(b, "UTF-8");
    }

    public int readContentCode() throws IOException {
        return this.readInt(4);
    }

    public int readLength() throws IOException {
        return this.readInt(4);
    }

    public Chunk readChunk() throws IOException {
        int contentCode = this.readContentCode();
        int length = this.readLength();
        if (this.factory == null) {
            this.factory = new ChunkFactory();
        }
        Chunk chunk = this.factory.newChunk(contentCode);
        if (length > 0) {
            if (chunk instanceof ByteChunk) {
                DaapInputStream.checkLength(chunk, 1, length);
                ((ByteChunk)chunk).setValue(this.read(length));
            } else if (chunk instanceof ShortChunk) {
                DaapInputStream.checkLength(chunk, 2, length);
                ((ShortChunk)chunk).setValue(this.readShort(length));
            } else if (chunk instanceof IntChunk) {
                DaapInputStream.checkLength(chunk, 4, length);
                ((IntChunk)chunk).setValue(this.readInt(length));
            } else if (chunk instanceof LongChunk) {
                DaapInputStream.checkLength(chunk, 8, length);
                ((LongChunk)chunk).setValue(this.readLong(length));
            } else if (chunk instanceof StringChunk) {
                ((StringChunk)chunk).setValue(this.readString(length));
            } else if (chunk instanceof DateChunk) {
                DaapInputStream.checkLength(chunk, 4, length);
                ((DateChunk)chunk).setValue(this.readInt(length));
            } else if (chunk instanceof VersionChunk) {
                DaapInputStream.checkLength(chunk, 4, length);
                ((VersionChunk)chunk).setValue(this.readInt(length));
            } else if (chunk instanceof ContainerChunk) {
                byte[] b = new byte[length];
                this.read(b, 0, b.length);
                DaapInputStream in = new DaapInputStream(new ByteArrayInputStream(b));
                while (in.available() > 0) {
                    ((ContainerChunk)chunk).add(in.readChunk());
                }
                in.close();
            } else {
                throw new IOException("Unknown Chunk Type: " + chunk);
            }
        }
        return chunk;
    }

    private static void checkLength(Chunk chunk, int expected, int length) throws IOException {
        if (expected != length && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Expected a chunk with length " + expected + " but got " + length + " (" + chunk.getContentCodeString() + ")"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

