/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.chunks.BooleanChunk;
import de.kapsi.net.daap.chunks.ByteChunk;
import de.kapsi.net.daap.chunks.Chunk;
import de.kapsi.net.daap.chunks.ContainerChunk;
import de.kapsi.net.daap.chunks.DateChunk;
import de.kapsi.net.daap.chunks.IntChunk;
import de.kapsi.net.daap.chunks.LongChunk;
import de.kapsi.net.daap.chunks.ShortChunk;
import de.kapsi.net.daap.chunks.StringChunk;
import de.kapsi.net.daap.chunks.VersionChunk;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class DaapOutputStream
extends FilterOutputStream {
    public DaapOutputStream(OutputStream out) {
        super(out);
    }

    public void writeShort(int i) throws IOException {
        this.write(i >> 8 & 0xFF);
        this.write(i & 0xFF);
    }

    public void writeInt(int i) throws IOException {
        this.write(i >> 24 & 0xFF);
        this.write(i >> 16 & 0xFF);
        this.write(i >> 8 & 0xFF);
        this.write(i & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l >> 56 & 0xFFL));
        this.write((int)(l >> 48 & 0xFFL));
        this.write((int)(l >> 40 & 0xFFL));
        this.write((int)(l >> 32 & 0xFFL));
        this.write((int)(l >> 24 & 0xFFL));
        this.write((int)(l >> 16 & 0xFFL));
        this.write((int)(l >> 8 & 0xFFL));
        this.write((int)(l & 0xFFL));
    }

    public void writeContentCode(int contentCode) throws IOException {
        this.writeInt(contentCode);
    }

    public void writeLength(int length) throws IOException {
        this.writeInt(length);
    }

    public void writeByteChunk(ByteChunk chunk) throws IOException {
        int value = chunk.getValue();
        if (value == 0 && chunk instanceof BooleanChunk) {
            return;
        }
        this.writeContentCode(chunk.getContentCode());
        this.writeLength(1);
        this.write(value);
    }

    public void writeShortChunk(ShortChunk chunk) throws IOException {
        int value = chunk.getValue();
        this.writeContentCode(chunk.getContentCode());
        this.writeLength(2);
        this.writeShort(value);
    }

    public void writeIntChunk(IntChunk chunk) throws IOException {
        int value = chunk.getValue();
        this.writeContentCode(chunk.getContentCode());
        this.writeLength(4);
        this.writeInt(value);
    }

    public void writeLongChunk(LongChunk chunk) throws IOException {
        long value = chunk.getValue();
        this.writeContentCode(chunk.getContentCode());
        this.writeLength(8);
        this.writeLong(value);
    }

    public void writeStringChunk(StringChunk chunk) throws IOException {
        byte[] value = chunk.getBytes();
        this.writeContentCode(chunk.getContentCode());
        this.writeLength(value.length);
        this.write(value, 0, value.length);
    }

    public void writeDateChunk(DateChunk chunk) throws IOException {
        int value = (int)(chunk.getValue() & 0xFFFFFFFFFFFFFFFFL);
        this.writeContentCode(chunk.getContentCode());
        this.writeLength(4);
        this.writeInt(value);
    }

    public void writeVersionChunk(VersionChunk chunk) throws IOException {
        int value = (int)(chunk.getValue() & 0xFFFFFFFFFFFFFFFFL);
        this.writeContentCode(chunk.getContentCode());
        this.writeLength(4);
        this.writeInt(value);
    }

    public void writeContainerChunk(ContainerChunk chunk) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DaapOutputStream out = new DaapOutputStream(buffer);
        Iterator it = chunk.iterator();
        while (it.hasNext()) {
            out.writeChunk((Chunk)it.next());
        }
        out.close();
        byte[] b = buffer.toByteArray();
        this.writeContentCode(chunk.getContentCode());
        this.writeLength(b.length);
        this.write(b, 0, b.length);
    }

    public void writeChunk(Chunk chunk) throws IOException {
        if (chunk == null) {
            throw new NullPointerException("Cannot write null Chunk");
        }
        if (chunk instanceof ByteChunk) {
            this.writeByteChunk((ByteChunk)chunk);
        } else if (chunk instanceof ShortChunk) {
            this.writeShortChunk((ShortChunk)chunk);
        } else if (chunk instanceof IntChunk) {
            this.writeIntChunk((IntChunk)chunk);
        } else if (chunk instanceof LongChunk) {
            this.writeLongChunk((LongChunk)chunk);
        } else if (chunk instanceof StringChunk) {
            this.writeStringChunk((StringChunk)chunk);
        } else if (chunk instanceof DateChunk) {
            this.writeDateChunk((DateChunk)chunk);
        } else if (chunk instanceof VersionChunk) {
            this.writeVersionChunk((VersionChunk)chunk);
        } else if (chunk instanceof ContainerChunk) {
            this.writeContainerChunk((ContainerChunk)chunk);
        } else {
            throw new RuntimeException("Unknown Chunk Type: " + chunk + ", " + chunk.getClass());
        }
    }
}

