/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.bio;

import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapThreadFactory;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.SessionId;
import de.kapsi.net.daap.bio.DaapConnectionBIO;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapServerBIO
extends DaapServer {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$bio$DaapServerBIO == null ? (class$de$kapsi$net$daap$bio$DaapServerBIO = DaapServerBIO.class$("de.kapsi.net.daap.bio.DaapServerBIO")) : class$de$kapsi$net$daap$bio$DaapServerBIO));
    private int threadNo = 0;
    private DaapThreadFactory threadFactory = new DaapThreadFactoryImpl();
    private ServerSocket ssocket;
    static /* synthetic */ Class class$de$kapsi$net$daap$bio$DaapServerBIO;

    public DaapServerBIO(Library library) {
        this(library, new DaapConfig());
    }

    public DaapServerBIO(Library library, DaapConfig config) {
        super(library, config);
    }

    public synchronized void setThreadFactory(DaapThreadFactory factory) {
        this.threadFactory = factory == null ? new DaapThreadFactoryImpl() : factory;
    }

    public synchronized void bind() throws IOException {
        if (this.isRunning()) {
            return;
        }
        InetSocketAddress bindAddr = this.config.getInetSocketAddress();
        int backlog = this.config.getBacklog();
        this.ssocket = new ServerSocket();
        this.ssocket.bind(bindAddr, backlog);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("DaapServerBIO bound to " + bindAddr));
        }
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.running = false;
        try {
            if (this.ssocket != null) {
                this.ssocket.close();
            }
        }
        catch (IOException err) {
            LOG.error((Object)err);
        }
        this.disconnectAll();
    }

    public synchronized void disconnectAll() {
        Iterator it = this.pending.iterator();
        while (it.hasNext()) {
            ((DaapConnectionBIO)it.next()).disconnect();
        }
        it = this.streams.iterator();
        while (it.hasNext()) {
            ((DaapConnectionBIO)it.next()).disconnect();
        }
        it = this.connections.iterator();
        while (it.hasNext()) {
            ((DaapConnectionBIO)it.next()).disconnect();
        }
        this.clear();
    }

    protected synchronized void update() {
        Iterator it = this.connections.iterator();
        while (it.hasNext()) {
            DaapConnectionBIO conn = (DaapConnectionBIO)it.next();
            for (int i = 0; i < this.libraryQueue.size(); ++i) {
                conn.enqueueLibrary((Library)this.libraryQueue.get(i));
            }
            try {
                conn.update();
            }
            catch (IOException err) {
                LOG.error((Object)err);
            }
        }
        this.libraryQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.threadNo = 0;
        this.running = true;
        try {
            while (this.running) {
                Socket socket = this.ssocket.accept();
                try {
                    DaapServerBIO daapServerBIO = this;
                    synchronized (daapServerBIO) {
                        if (this.running && this.accept(socket.getInetAddress())) {
                            socket.setSoTimeout(3000);
                            DaapConnectionBIO connection = new DaapConnectionBIO(this, socket);
                            this.addPendingConnection(connection);
                            Thread connThread = this.threadFactory.createDaapThread(connection, "DaapConnectionThread-" + ++this.threadNo);
                            connThread.start();
                        } else {
                            socket.close();
                        }
                    }
                }
                catch (IOException err) {
                    LOG.error((Object)err);
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException err) {
            LOG.error((Object)err);
        }
        catch (SocketException err) {
            if (this.running) {
                LOG.error((Object)err);
            }
        }
        catch (IOException err) {
            LOG.error((Object)err);
        }
        finally {
            this.stop();
        }
    }

    protected synchronized DaapConnection getAudioConnection(SessionId sessionId) {
        return super.getAudioConnection(sessionId);
    }

    protected synchronized DaapConnection getDaapConnection(SessionId sessionId) {
        return super.getDaapConnection(sessionId);
    }

    protected synchronized boolean isSessionIdValid(SessionId sessionId) {
        return super.isSessionIdValid(sessionId);
    }

    protected synchronized void removeConnection(DaapConnection connection) {
        super.removeConnection(connection);
    }

    protected synchronized boolean updateConnection(DaapConnection connection) {
        if (!this.isRunning()) {
            return false;
        }
        return super.updateConnection(connection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DaapThreadFactoryImpl
    implements DaapThreadFactory {
        private DaapThreadFactoryImpl() {
        }

        public Thread createDaapThread(Runnable runnable, String name) {
            Thread thread = new Thread(runnable, name);
            thread.setDaemon(true);
            return thread;
        }
    }
}

