/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.chunks.AbstractChunk;
import de.kapsi.net.daap.chunks.Chunk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ContainerChunk
extends AbstractChunk {
    protected Collection collection;

    protected ContainerChunk(String type, String name) {
        this(type, name, new ArrayList());
    }

    protected ContainerChunk(String type, String name, Collection collection) {
        super(type, name);
        this.collection = collection;
    }

    public void add(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException();
        }
        this.collection.add(chunk);
    }

    public Iterator iterator() {
        return Collections.unmodifiableCollection(this.collection).iterator();
    }

    public int size() {
        return this.collection.size();
    }

    public int getType() {
        return 12;
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(ContainerChunk.indent(indent));
        buffer.append(this.name).append("(").append(this.getContentCodeString()).append("; container)\n");
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            AbstractChunk chunk = (AbstractChunk)it.next();
            buffer.append(chunk.toString(indent + 4));
            if (it.hasNext()) {
                buffer.append("\n");
            }
            ++i;
        }
        return buffer.toString();
    }
}

