/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import de.kapsi.net.daap.DaapAudioResponse;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapStreamException;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.nio.DaapConnectionNIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class DaapAudioResponseNIO
extends DaapAudioResponse {
    private ByteBuffer headerBuffer;
    private FileChannel fileChannel;
    private DaapConnectionNIO connection;

    public DaapAudioResponseNIO(DaapRequest request, Song song, File file, long pos, long end) throws IOException {
        this(request, song, new FileInputStream(file), pos, end);
    }

    public DaapAudioResponseNIO(DaapRequest request, Song song, FileInputStream in, long pos, long end) throws IOException {
        super(request, song, in, pos, end);
        this.headerBuffer = ByteBuffer.wrap(this.header);
        this.connection = (DaapConnectionNIO)request.getConnection();
        this.fileChannel = in.getChannel();
    }

    public boolean hasRemaining() {
        if (this.headerBuffer.hasRemaining()) {
            return true;
        }
        return this.pos < this.end;
    }

    public boolean write() throws IOException {
        if (this.headerBuffer.hasRemaining()) {
            try {
                this.connection.getWriteChannel().write(this.headerBuffer);
                if (this.headerBuffer.hasRemaining()) {
                    return false;
                }
            }
            catch (IOException err) {
                this.close();
                throw err;
            }
        }
        try {
            return this.stream();
        }
        catch (IOException err) {
            throw new DaapStreamException(err);
        }
    }

    private boolean stream() throws IOException {
        if (this.pos < this.end) {
            if (!this.connection.getWriteChannel().isOpen()) {
                this.close();
                return true;
            }
            try {
                DaapConfig config = this.request.getServer().getConfig();
                this.pos += this.fileChannel.transferTo(this.pos, config.getBufferSize(), this.connection.getWriteChannel());
                if (this.pos >= this.end) {
                    this.close();
                    return true;
                }
                return false;
            }
            catch (IOException err) {
                this.close();
                throw err;
            }
        }
        return true;
    }

    protected void close() throws IOException {
        super.close();
        this.fileChannel.close();
    }
}

