/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import com.sun.star.wiki.Helper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings {
    private XComponentContext m_xContext;
    private int lastUsedWikiServer = 0;
    private static Settings m_instance;
    private Vector<Hashtable<String, String>> m_WikiConnections = new Vector();
    private Vector<Hashtable<String, Object>> m_aWikiDocs = new Vector();

    private Settings(XComponentContext xComponentContext) {
        this.m_xContext = xComponentContext;
        this.loadConfiguration();
    }

    public static synchronized Settings getSettings(XComponentContext xComponentContext) {
        if (m_instance == null) {
            m_instance = new Settings(xComponentContext);
        }
        return m_instance;
    }

    public void addWikiCon(Hashtable<String, String> hashtable) {
        this.m_WikiConnections.add(hashtable);
    }

    public Vector<Hashtable<String, String>> getWikiCons() {
        return this.m_WikiConnections;
    }

    public String getWikiConUrlByNumber(int n) {
        String string = "";
        if (n >= 0 && n < this.m_WikiConnections.size()) {
            Hashtable<String, String> hashtable = this.m_WikiConnections.get(n);
            string = hashtable.get("Url");
        }
        return string;
    }

    public void addWikiDoc(Hashtable<String, Object> hashtable) {
        String string = (String)hashtable.get("CompleteUrl");
        Hashtable hashtable2 = this.getDocByCompleteUrl(string);
        if (hashtable2 != null) {
            this.m_aWikiDocs.remove(hashtable2);
        } else if (this.m_aWikiDocs.size() > 10) {
            this.m_aWikiDocs.remove(0);
        }
        this.m_aWikiDocs.add(hashtable);
    }

    public Vector<Hashtable<String, Object>> getWikiDocs() {
        return this.m_aWikiDocs;
    }

    public Object[] getWikiDocList(int n, int n2) {
        String string = this.getWikiConUrlByNumber(n);
        Vector<String> vector = new Vector<String>();
        String[] stringArray = new String[]{};
        for (int i = 0; i < this.m_aWikiDocs.size(); ++i) {
            Hashtable<String, Object> hashtable = this.m_aWikiDocs.get(i);
            String string2 = (String)hashtable.get("Url");
            if (!string2.equals(string)) continue;
            vector.add((String)hashtable.get("Doc"));
        }
        return vector.toArray(stringArray);
    }

    public int getLastUsedWikiServer() {
        return this.lastUsedWikiServer;
    }

    public void setLastUsedWikiServer(int n) {
        this.lastUsedWikiServer = n;
    }

    public String[] getWikiURLs() {
        String[] stringArray = new String[this.m_WikiConnections.size()];
        for (int i = 0; i < this.m_WikiConnections.size(); ++i) {
            Hashtable<String, String> hashtable = this.m_WikiConnections.get(i);
            stringArray[i] = hashtable.get("Url");
        }
        return stringArray;
    }

    public Hashtable<String, String> getSettingByUrl(String string) {
        Hashtable<String, String> hashtable = null;
        for (int i = 0; i < this.m_WikiConnections.size(); ++i) {
            Hashtable<String, String> hashtable2 = this.m_WikiConnections.get(i);
            String string2 = hashtable2.get("Url");
            if (!string2.equals(string)) continue;
            hashtable = hashtable2;
            try {
                String[] stringArray;
                String string3 = hashtable.get("Username");
                String string4 = hashtable.get("Password");
                if (string3 == null || string3.length() <= 0 || string4 != null && string4.length() != 0 || (stringArray = Helper.GetPasswordsForURLAndUser(this.m_xContext, string, string3)) == null || stringArray.length <= 0) break;
                hashtable.put("Password", stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break;
        }
        return hashtable;
    }

    public Hashtable getDocByCompleteUrl(String string) {
        Hashtable<String, Object> hashtable = null;
        for (int i = 0; i < this.m_aWikiDocs.size(); ++i) {
            Hashtable<String, Object> hashtable2 = this.m_aWikiDocs.get(i);
            String string2 = (String)hashtable2.get("CompleteUrl");
            if (!string2.equals(string)) continue;
            hashtable = hashtable2;
        }
        return hashtable;
    }

    public void removeSettingByUrl(String string) {
        Object var2_2 = null;
        for (int i = 0; i < this.m_WikiConnections.size(); ++i) {
            Hashtable<String, String> hashtable = this.m_WikiConnections.get(i);
            String string2 = hashtable.get("Url");
            if (!string2.equals(string)) continue;
            this.m_WikiConnections.remove(i);
        }
    }

    public void storeConfiguration() {
        try {
            String[] stringArray;
            Object object;
            XNameContainer xNameContainer = Helper.GetConfigNameContainer(this.m_xContext, "org.openoffice.Office.Custom.WikiExtension/ConnectionList");
            String[] stringArray2 = xNameContainer.getElementNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                xNameContainer.removeByName(stringArray2[i]);
            }
            XSingleServiceFactory xSingleServiceFactory = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)xNameContainer);
            for (int i = 0; i < this.m_WikiConnections.size(); ++i) {
                object = xSingleServiceFactory.createInstance();
                stringArray = this.m_WikiConnections.get(i);
                XNameReplace xNameReplace = (XNameReplace)UnoRuntime.queryInterface(XNameReplace.class, (Object)object);
                if (xNameReplace != null) {
                    xNameReplace.replaceByName("UserName", stringArray.get("Username"));
                }
                xNameContainer.insertByName((String)stringArray.get("Url"), (Object)xNameReplace);
            }
            XChangesBatch xChangesBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)xNameContainer);
            xChangesBatch.commitChanges();
            object = Helper.GetConfigNameContainer(this.m_xContext, "org.openoffice.Office.Custom.WikiExtension/RecentDocs");
            stringArray = object.getElementNames();
            for (int i = 0; i < stringArray.length; ++i) {
                object.removeByName(stringArray[i]);
            }
            XSingleServiceFactory xSingleServiceFactory2 = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)object);
            for (int i = 0; i < this.m_aWikiDocs.size(); ++i) {
                Hashtable<String, Object> hashtable = this.m_aWikiDocs.get(i);
                Object object2 = xSingleServiceFactory2.createInstance();
                XNameReplace xNameReplace = (XNameReplace)UnoRuntime.queryInterface(XNameReplace.class, (Object)object2);
                Enumeration<String> enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    xNameReplace.replaceByName(string, hashtable.get(string));
                }
                object.insertByName("d" + i, (Object)xNameReplace);
            }
            XChangesBatch xChangesBatch2 = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)object);
            xChangesBatch2.commitChanges();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadConfiguration() {
        block7: {
            this.m_WikiConnections.clear();
            try {
                XPropertySet xPropertySet;
                XNameAccess xNameAccess;
                XNameAccess xNameAccess2 = Helper.GetConfigNameAccess(this.m_xContext, "org.openoffice.Office.Custom.WikiExtension");
                if (xNameAccess2 == null) break block7;
                Object object = xNameAccess2.getByName("ConnectionList");
                XNameAccess xNameAccess3 = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
                String[] stringArray = xNameAccess3.getElementNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    xNameAccess = new Hashtable();
                    xNameAccess.put("Url", stringArray[i]);
                    xNameAccess.put("Username", "");
                    xNameAccess.put("Password", "");
                    try {
                        String string;
                        xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xNameAccess3.getByName(stringArray[i]));
                        if (xPropertySet != null && (string = AnyConverter.toString((Object)xPropertySet.getPropertyValue("UserName"))) != null && string.length() > 0) {
                            xNameAccess.put("Username", string);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.addWikiCon((Hashtable<String, String>)xNameAccess);
                }
                Object object2 = xNameAccess2.getByName("RecentDocs");
                xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object2);
                xPropertySet = xNameAccess.getElementNames();
                for (int i = 0; i < ((String[])xPropertySet).length; ++i) {
                    Object object3 = xNameAccess.getByName(xPropertySet[i]);
                    XNameAccess xNameAccess4 = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object3);
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    hashtable.put("Url", xNameAccess4.getByName("Url"));
                    hashtable.put("CompleteUrl", xNameAccess4.getByName("CompleteUrl"));
                    hashtable.put("Doc", xNameAccess4.getByName("Doc"));
                    this.addWikiDoc(hashtable);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

