/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.xslt;

import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.MergeException;
import org.openoffice.xmerge.converter.xml.xslt.GenericOfficeDocument;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.diff.IteratorLCSAlgorithm;
import org.openoffice.xmerge.merger.diff.ParaNodeIterator;
import org.openoffice.xmerge.merger.merge.CharacterBaseParagraphMerge;
import org.openoffice.xmerge.merger.merge.DocumentMerge;
import org.openoffice.xmerge.util.Debug;

public class DocumentMergerImpl
implements DocumentMerger {
    private ConverterCapabilities cc_;
    private Document orig = null;

    public DocumentMergerImpl(Document document, ConverterCapabilities converterCapabilities) {
        this.cc_ = converterCapabilities;
        this.orig = document;
    }

    public void merge(Document document) throws MergeException {
        GenericOfficeDocument genericOfficeDocument = (GenericOfficeDocument)this.orig;
        GenericOfficeDocument genericOfficeDocument2 = (GenericOfficeDocument)document;
        org.w3c.dom.Document document2 = genericOfficeDocument.getContentDOM();
        org.w3c.dom.Document document3 = genericOfficeDocument2.getContentDOM();
        ParaNodeIterator paraNodeIterator = new ParaNodeIterator(this.cc_, document2.getDocumentElement());
        ParaNodeIterator paraNodeIterator2 = new ParaNodeIterator(this.cc_, document3.getDocumentElement());
        IteratorLCSAlgorithm iteratorLCSAlgorithm = new IteratorLCSAlgorithm();
        Difference[] differenceArray = iteratorLCSAlgorithm.computeDiffs(paraNodeIterator, paraNodeIterator2);
        if (Debug.isFlagSet(1)) {
            Debug.log(1, "Diff Result: ");
            for (int i = 0; i < differenceArray.length; ++i) {
                Debug.log(1, differenceArray[i].debug());
            }
        }
        CharacterBaseParagraphMerge characterBaseParagraphMerge = new CharacterBaseParagraphMerge();
        DocumentMerge documentMerge = new DocumentMerge(this.cc_, characterBaseParagraphMerge);
        documentMerge.applyDifference(paraNodeIterator, paraNodeIterator2, differenceArray);
    }
}

