/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.knowledge;

import net.adaptivebox.encode.IEncodeEngine;
import net.adaptivebox.global.OutputMethods;
import net.adaptivebox.space.BasicPoint;

public class SearchPoint
extends BasicPoint
implements IEncodeEngine {
    private double[] encodeInfo = new double[2];
    private double objectiveValue;

    public SearchPoint(int n) {
        super(n);
        for (int i = 0; i < this.encodeInfo.length; ++i) {
            this.encodeInfo[i] = 1.0E308;
        }
    }

    public double[] getEncodeInfo() {
        return this.encodeInfo;
    }

    private void importEncodeInfo(double[] dArray) {
        for (int i = 0; i < this.encodeInfo.length; ++i) {
            this.encodeInfo[i] = dArray[i];
        }
    }

    private void importEncodeInfo(IEncodeEngine iEncodeEngine) {
        this.importEncodeInfo(iEncodeEngine.getEncodeInfo());
    }

    public void importPoint(SearchPoint searchPoint) {
        this.importLocation(searchPoint);
        this.importEncodeInfo(searchPoint);
        this.setObjectiveValue(searchPoint.getObjectiveValue());
    }

    public double getObjectiveValue() {
        return this.objectiveValue;
    }

    public void setObjectiveValue(double d) {
        this.objectiveValue = d;
    }

    public boolean isFeasible() {
        return this.encodeInfo[0] == 0.0;
    }

    public void outputSelf() {
        System.out.println("#--> Location:");
        OutputMethods.outputVector(this.getLocation());
        System.out.println("#--> (CON & OPTIM):");
        OutputMethods.outputVector(this.getEncodeInfo());
    }
}

