/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver;

import com.sun.star.comp.Calc.NLPSolver.BaseEvolutionarySolver;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.XComponentContext;
import net.adaptivebox.global.IUpdateCycleEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.sco.SCAgent;

public final class SCOSolverImpl
extends BaseEvolutionarySolver
implements XServiceInfo {
    private static final String m_implementationName = SCOSolverImpl.class.getName();
    private static final String[] m_serviceNames = new String[]{"com.sun.star.sheet.Solver", "com.sun.star.beans.PropertySet"};
    private SCAgent[] m_agents;

    public SCOSolverImpl(XComponentContext xComponentContext) {
        super(xComponentContext, "SCO Evolutionary Algorithm");
        this.registerProperty(this.m_librarySize);
    }

    public static XSingleComponentFactory __getComponentFactory(String string) {
        XSingleComponentFactory xSingleComponentFactory = null;
        if (string.equals(m_implementationName)) {
            xSingleComponentFactory = Factory.createComponentFactory(SCOSolverImpl.class, (String[])m_serviceNames);
        }
        return xSingleComponentFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey xRegistryKey) {
        return Factory.writeRegistryServiceInfo((String)m_implementationName, (String[])m_serviceNames, (XRegistryKey)xRegistryKey);
    }

    public String getImplementationName() {
        return m_implementationName;
    }

    public boolean supportsService(String string) {
        int n = m_serviceNames.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public void solve() {
        int n;
        this.initializeSolve();
        int n2 = (Integer)this.m_swarmSize.getValue();
        this.m_agents = new SCAgent[n2];
        for (n = 0; n < n2; ++n) {
            this.m_agents[n] = new SCAgent();
            this.m_agents[n].setProblemEncoder(this.m_problemEncoder);
            this.m_agents[n].setSpecComparator(this.m_specCompareEngine);
            this.m_agents[n].setExternalLib(this.m_library);
        }
        this.m_solverStatusDialog.setVisible(true);
        n = (Integer)this.m_learningCycles.getValue();
        this.m_solverStatusDialog.setMaxIterations(n);
        this.m_solverStatusDialog.setMaxStagnation((Integer)this.m_required.getValue());
        int n3 = 1;
        long l = 0L;
        do {
            long l2 = System.nanoTime();
            if (n3 >= (Integer)this.m_learningCycles.getValue()) {
                n3 = 1;
            }
            if (this.m_solverStatusDialog.getUserState() == 2) {
                this.lockDocument();
            }
            this.m_toleratedCount = 0;
            this.m_toleratedMin = -1.0 * (Double)this.m_tolerance.getValue();
            this.m_toleratedMax = (Double)this.m_tolerance.getValue();
            while (n3 <= n && this.m_toleratedCount < (Integer)this.m_required.getValue() && this.m_solverStatusDialog.getUserState() != 3) {
                int n4;
                for (n4 = 0; n4 < n2; ++n4) {
                    boolean bl;
                    SearchPoint searchPoint = this.m_agents[n4].generatePoint();
                    boolean bl2 = bl = searchPoint.getObjectiveValue() >= this.m_toleratedMin && searchPoint.getObjectiveValue() <= this.m_toleratedMax;
                    if (!Library.replace(this.m_envCompareEngine, searchPoint, this.m_totalBestPoint)) continue;
                    this.m_solverStatusDialog.setBestSolution(this.m_totalBestPoint.getObjectiveValue(), this.m_totalBestPoint.isFeasible());
                    if (bl) continue;
                    this.m_toleratedMin = searchPoint.getObjectiveValue() - (Double)this.m_tolerance.getValue();
                    this.m_toleratedMax = searchPoint.getObjectiveValue() + (Double)this.m_tolerance.getValue();
                    this.m_toleratedCount = 0;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    this.m_agents[n4].updateInfo();
                }
                if (this.m_specCompareEngine instanceof IUpdateCycleEngine) {
                    ((IUpdateCycleEngine)((Object)this.m_specCompareEngine)).updateCycle(n3);
                }
                this.m_solverStatusDialog.setIteration(n3);
                this.m_solverStatusDialog.setStagnation(this.m_toleratedCount);
                this.m_solverStatusDialog.setRuntime(l + (System.nanoTime() - l2));
                this.m_xReschedule.reschedule();
                ++n3;
            }
            this.applySolution();
            this.unlockDocument();
            this.m_solverStatusDialog.setRuntime(l += System.nanoTime() - l2);
        } while (this.m_solverStatusDialog.waitForUser() == 2);
        this.lockDocument();
        this.finalizeSolve();
    }
}

