/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class CodePage
implements BIFFRecord {
    private byte[] codepage = new byte[2];
    private byte[] unknown1 = new byte[2];
    private byte[] unknown2 = new byte[2];
    private byte unknown3;

    public CodePage() {
        this.codepage = new byte[]{-28, 4};
        this.unknown1 = new byte[]{-116, 1};
        this.unknown2 = new byte[]{0, 1};
        this.unknown3 = 0;
    }

    public CodePage(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public short getBiffType() {
        return 66;
    }

    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.codepage);
        n += inputStream.read(this.unknown1);
        n += inputStream.read(this.unknown2);
        this.unknown3 = (byte)inputStream.read();
        Debug.log(4, "\tcodepage : " + EndianConverter.readShort(this.codepage) + " unknown1 : " + EndianConverter.readShort(this.unknown1) + " unknown2 : " + EndianConverter.readShort(this.unknown2) + " unknown3 : " + this.unknown3);
        return ++n;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.codepage);
        outputStream.write(this.unknown1);
        outputStream.write(this.unknown2);
        outputStream.write(this.unknown3);
        Debug.log(4, "Writing CodePage record");
    }
}

