/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XMultiPropertySet;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.Date;
import com.sun.star.util.DateTime;
import com.sun.star.util.XMacroExpander;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XNumberFormatter;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.PropertySetHelper;
import java.lang.reflect.Array;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helper {
    private static long DAY_IN_MILLIS = 86400000L;

    public static long convertUnoDatetoInteger(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(date.Year, date.Month, date.Day);
        java.util.Date date2 = calendar.getTime();
        long l = date2.getTime();
        return l / 86400000L;
    }

    public static void setUnoPropertyValue(Object object, String string, Object object2) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
            if (!xPropertySet.getPropertySetInfo().hasPropertyByName(string)) {
                Property[] propertyArray = xPropertySet.getPropertySetInfo().getProperties();
                throw new IllegalArgumentException("No Such Property: '" + string + "'");
            }
            xPropertySet.setPropertyValue(string, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static Object getUnoObjectbyName(Object object, String string) {
        try {
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
            if (xNameAccess.hasByName(string)) {
                return xNameAccess.getByName(string);
            }
            throw new RuntimeException();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static Object getPropertyValue(PropertyValue[] propertyValueArray, String string) {
        int n = propertyValueArray.length;
        for (int i = 0; i < n; ++i) {
            if (propertyValueArray[i] == null || !propertyValueArray[i].Name.equals(string)) continue;
            return propertyValueArray[i].Value;
        }
        throw new RuntimeException();
    }

    public static Object getUnoPropertyValue(Object object, String string, Class<?> clazz) {
        try {
            if (object != null) {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
                Object object2 = xPropertySet.getPropertyValue(string);
                if (AnyConverter.isVoid((Object)object2)) {
                    return null;
                }
                return AnyConverter.toObject((Type)new Type(clazz), (Object)object2);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static Object getPropertyValuefromAny(Object[] objectArray, String string) {
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                PropertyValue propertyValue;
                if (objectArray[i] == null || (propertyValue = (PropertyValue)objectArray[i]) == null || !propertyValue.Name.equals(string)) continue;
                return propertyValue.Value;
            }
        }
        return null;
    }

    public static Object getPropertyValuefromAny(Object[] objectArray, String string, Class<?> clazz) {
        try {
            if (objectArray != null) {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    PropertyValue propertyValue;
                    if (objectArray[i] == null || (propertyValue = (PropertyValue)objectArray[i]) == null || !propertyValue.Name.equals(string)) continue;
                    return AnyConverter.toObject((Type)new Type(clazz), (Object)propertyValue.Value);
                }
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static Object getUnoPropertyValue(Object object, String string) {
        try {
            if (object != null) {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
                return xPropertySet.getPropertyValue(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    public static Object getUnoArrayPropertyValue(Object object, String string) {
        try {
            XPropertySet xPropertySet;
            Object object2;
            if (object != null && AnyConverter.isArray((Object)(object2 = (xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object)).getPropertyValue(string)))) {
                return Helper.getArrayValue(object2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    public static Object getUnoStructValue(Object object, String string) {
        try {
            XPropertySet xPropertySet;
            if (object != null && (xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object)).getPropertySetInfo().hasPropertyByName(string)) {
                return xPropertySet.getPropertyValue(string);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static void setUnoPropertyValues(Object object, String[] stringArray, Object[] objectArray) {
        try {
            XMultiPropertySet xMultiPropertySet = (XMultiPropertySet)UnoRuntime.queryInterface(XMultiPropertySet.class, (Object)object);
            if (xMultiPropertySet != null) {
                xMultiPropertySet.setPropertyValues(stringArray, objectArray);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    Helper.setUnoPropertyValue(object, stringArray[i], objectArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static Object getArrayValue(Object object) {
        try {
            Object object2 = AnyConverter.toArray((Object)object);
            int n = Array.getLength(object2);
            if (n == 0) {
                return null;
            }
            return object2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static XComponentContext getComponentContext(XMultiServiceFactory xMultiServiceFactory) {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMultiServiceFactory);
        PropertySetHelper propertySetHelper = new PropertySetHelper(xPropertySet);
        Object object = propertySetHelper.getPropertyValueAsObject("DefaultContext");
        return (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)object);
    }

    public static XMacroExpander getMacroExpander(XMultiServiceFactory xMultiServiceFactory) {
        XComponentContext xComponentContext = Helper.getComponentContext(xMultiServiceFactory);
        Object object = xComponentContext.getValueByName("/singletons/com.sun.star.util.theMacroExpander");
        return (XMacroExpander)UnoRuntime.queryInterface(XMacroExpander.class, (Object)object);
    }

    public static class DateUtils {
        private long docNullTime;
        private XNumberFormatter formatter;
        private XNumberFormatsSupplier formatSupplier;
        private Calendar calendar;

        public DateUtils(XMultiServiceFactory xMultiServiceFactory, Object object) throws Exception {
            XMultiServiceFactory xMultiServiceFactory2 = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)object);
            Object object2 = xMultiServiceFactory2.createInstance("com.sun.star.text.Defaults");
            Locale locale = (Locale)Helper.getUnoStructValue(object2, "CharLocale");
            java.util.Locale locale2 = new java.util.Locale(locale.Language, locale.Country, locale.Variant);
            this.calendar = Calendar.getInstance(locale2);
            this.formatSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)object);
            XPropertySet xPropertySet = this.formatSupplier.getNumberFormatSettings();
            Date date = (Date)Helper.getUnoPropertyValue(xPropertySet, "NullDate");
            this.calendar.set(date.Year, date.Month - 1, date.Day);
            this.docNullTime = this.getTimeInMillis();
            this.formatter = NumberFormatter.createNumberFormatter(xMultiServiceFactory, this.formatSupplier);
        }

        public int getFormat(short s) {
            return NumberFormatter.getNumberFormatterKey(this.formatSupplier, s);
        }

        public XNumberFormatter getFormatter() {
            return this.formatter;
        }

        private long getTimeInMillis() {
            java.util.Date date = this.calendar.getTime();
            return date.getTime();
        }

        public synchronized double getDocumentDateAsDouble(int n) {
            this.calendar.clear();
            this.calendar.set(n / 10000, n % 10000 / 100 - 1, n % 100);
            long l = this.getTimeInMillis();
            return (l - this.docNullTime) / DAY_IN_MILLIS + 1L;
        }

        public double getDocumentDateAsDouble(DateTime dateTime) {
            return this.getDocumentDateAsDouble(dateTime.Year * 10000 + dateTime.Month * 100 + dateTime.Day);
        }

        public synchronized double getDocumentDateAsDouble(long l) {
            this.calendar.clear();
            JavaTools.setTimeInMillis(this.calendar, l);
            long l2 = this.getTimeInMillis();
            return (l2 - this.docNullTime) / DAY_IN_MILLIS + 1L;
        }

        public String format(int n, int n2) {
            return this.formatter.convertNumberToString(n, this.getDocumentDateAsDouble(n2));
        }

        public String format(int n, DateTime dateTime) {
            return this.formatter.convertNumberToString(n, this.getDocumentDateAsDouble(dateTime));
        }

        public String format(int n, long l) {
            return this.formatter.convertNumberToString(n, this.getDocumentDateAsDouble(l));
        }
    }
}

