/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel;

import java.io.IOException;
import java.util.ArrayList;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.ColumnRowInfo;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetEncoder;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PocketExcelEncoder
extends SpreadsheetEncoder {
    private Workbook wb;

    PocketExcelEncoder(String string) throws IOException {
        this.wb = new Workbook(string);
    }

    @Override
    public void createWorksheet(String string) throws IOException {
        this.wb.addWorksheet(string);
    }

    @Override
    public int getNumberOfSheets() {
        ArrayList<Object> arrayList = this.wb.getWorksheetNames();
        return arrayList.size();
    }

    public Workbook getWorkbook() throws IOException {
        return this.wb;
    }

    protected String parseFormula(String string) {
        Debug.log(4, "Strip Formula (Before) : " + string);
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = stringBuffer.length();
        block7: for (int i = 0; i < n; ++i) {
            switch (stringBuffer.charAt(i)) {
                case '[': {
                    Debug.log(4, "brace Found");
                    bl = true;
                    bl2 = true;
                    continue block7;
                }
                case ']': {
                    bl = false;
                    continue block7;
                }
                case '.': {
                    if (bl && (bl2 || bl3)) {
                        Debug.log(4, "dot Found and in brace");
                        bl2 = false;
                        bl3 = false;
                        continue block7;
                    }
                    if (bl3) {
                        bl3 = false;
                        continue block7;
                    }
                    stringBuffer2.append(stringBuffer.charAt(i));
                    continue block7;
                }
                case ':': {
                    bl3 = true;
                    stringBuffer2.append(stringBuffer.charAt(i));
                    continue block7;
                }
                case ';': {
                    stringBuffer2.append(',');
                    continue block7;
                }
                default: {
                    stringBuffer2.append(stringBuffer.charAt(i));
                    bl2 = false;
                }
            }
        }
        Debug.log(4, "Strip Formula (After) : " + stringBuffer2);
        return stringBuffer2.toString();
    }

    @Override
    public void addCell(int n, int n2, Format format, String string) throws IOException {
        if (string.startsWith("=")) {
            string = this.parseFormula(string);
            Debug.log(4, "Parsing Formula " + string);
        }
        this.wb.addCell(n, n2, format, string);
    }

    @Override
    public void setColumnRows(ArrayList<ColumnRowInfo> arrayList) throws IOException {
        this.wb.addColInfo(arrayList);
    }

    @Override
    public void setNameDefinition(NameDefinition nameDefinition) throws IOException {
        String string = nameDefinition.getDefinition();
        nameDefinition.setDefinition(this.parseFormula(string));
        this.wb.addNameDefinition(nameDefinition);
    }

    @Override
    public void addSettings(BookSettings bookSettings) throws IOException {
        this.wb.addSettings(bookSettings);
    }

    @Override
    public void setCellFormat(int n, int n2, Format format) {
        Debug.log(4, "bold : " + format.getAttribute(1) + ",Italic : " + format.getAttribute(2) + ",Underline : " + format.getAttribute(4));
    }

    @Override
    public String getSheetName(int n) {
        ArrayList<Object> arrayList = this.wb.getWorksheetNames();
        String string = (String)arrayList.get(n);
        return string;
    }
}

