/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver.dialogs;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XActionListener;
import com.sun.star.comp.Calc.NLPSolver.BaseNLPSolver;
import com.sun.star.comp.Calc.NLPSolver.ResourceManager;
import com.sun.star.comp.Calc.NLPSolver.dialogs.BaseDialog;
import com.sun.star.comp.Calc.NLPSolver.dialogs.IEvolutionarySolverStatusDialog;
import com.sun.star.comp.Calc.NLPSolver.dialogs.controls.Button;
import com.sun.star.comp.Calc.NLPSolver.dialogs.controls.Label;
import com.sun.star.comp.Calc.NLPSolver.dialogs.controls.ProgressBar;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.resource.MissingResourceException;
import com.sun.star.style.VerticalAlignment;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

public class EvolutionarySolverStatusUno
extends BaseDialog
implements IEvolutionarySolverStatusDialog,
XActionListener {
    private int userState;
    private Label lblSolution;
    private Label lblSolutionValue;
    private Label lblIteration;
    private ProgressBar pbIteration;
    private Label lblIterationValue;
    private Label lblStagnation;
    private ProgressBar pbStagnation;
    private Label lblStagnationValue;
    private Label lblRuntime;
    private Label lblRuntimeValue;
    private Button btnStop;
    private Button btnOK;
    private Button btnContinue;
    private int defaultTextColor;
    private int maxIterations;
    private int maxStagnation;
    private final ResourceManager resourceManager;
    private final int COLOR_RED = 0xFF0000;

    public EvolutionarySolverStatusUno(XComponentContext xComponentContext) {
        super(xComponentContext, "Solver Status", -1, -1, 170, 95);
        this.setCloseable(false);
        this.userState = 1;
        this.resourceManager = new ResourceManager(xComponentContext, "com.sun.star.comp.Calc.NLPSolver", "/locale", "NLPSolverStatusDialog");
        try {
            this.setProperty("Title", this.resourceManager.getLocalizedString("Dialog.Caption"));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        int n = 5;
        this.lblSolution = new Label(this, "lblSolution");
        this.lblSolution.setPosition(5, n);
        this.lblSolution.setSize(60, 10);
        this.lblSolution.setLabel(this.resourceManager.getLocalizedString("Controls.lblSolution", "Current Solution:"));
        this.lblSolution.setParentControl(this);
        this.lblSolutionValue = new Label(this, "lblSolutionValue");
        this.lblSolutionValue.setPosition(65, n);
        this.lblSolutionValue.setSize(100, 10);
        this.lblSolutionValue.setParentControl(this);
        this.defaultTextColor = this.lblSolutionValue.getTextColor();
        this.lblIteration = new Label(this, "lblIteration");
        this.lblIteration.setPosition(5, n += 15);
        this.lblIteration.setSize(60, 15);
        this.lblIteration.setLabel(this.resourceManager.getLocalizedString("Controls.lblIteration", "Iteration:"));
        this.lblIteration.setVerticalAlign(VerticalAlignment.MIDDLE);
        this.lblIteration.setParentControl(this);
        this.pbIteration = new ProgressBar(this, "pbIteration");
        this.pbIteration.setPosition(65, n);
        this.pbIteration.setSize(100, 15);
        this.pbIteration.setParentControl(this);
        this.lblIterationValue = new Label(this, "lblIterationValue");
        this.lblIterationValue.setPosition(65, n);
        this.lblIterationValue.setSize(100, 20);
        this.lblIterationValue.setVerticalAlign(VerticalAlignment.MIDDLE);
        this.lblIterationValue.setMultiLine(true);
        this.lblIterationValue.setParentControl(this);
        this.lblIterationValue.setVisible(false);
        this.lblStagnation = new Label(this, "lblStagnation");
        this.lblStagnation.setPosition(5, n += 20);
        this.lblStagnation.setSize(60, 15);
        this.lblStagnation.setLabel(this.resourceManager.getLocalizedString("Controls.lblStagnation", "Stagnation:"));
        this.lblStagnation.setVerticalAlign(VerticalAlignment.MIDDLE);
        this.lblStagnation.setParentControl(this);
        this.pbStagnation = new ProgressBar(this, "pbStagnation");
        this.pbStagnation.setPosition(65, n);
        this.pbStagnation.setSize(100, 15);
        this.pbStagnation.setParentControl(this);
        this.lblStagnationValue = new Label(this, "lblStagnationValue");
        this.lblStagnationValue.setPosition(65, n);
        this.lblStagnationValue.setSize(100, 20);
        this.lblStagnationValue.setVerticalAlign(VerticalAlignment.MIDDLE);
        this.lblStagnationValue.setMultiLine(true);
        this.lblStagnationValue.setParentControl(this);
        this.lblStagnationValue.setVisible(false);
        this.lblRuntime = new Label(this, "lblRuntime");
        this.lblRuntime.setPosition(5, n += 20);
        this.lblRuntime.setSize(60, 10);
        this.lblRuntime.setLabel(this.resourceManager.getLocalizedString("Controls.lblRuntime", "Runtime:"));
        this.lblRuntime.setParentControl(this);
        this.lblRuntimeValue = new Label(this, "lblRuntimeValue");
        this.lblRuntimeValue.setPosition(65, n);
        this.lblRuntimeValue.setSize(100, 10);
        this.lblRuntimeValue.setParentControl(this);
        this.btnStop = new Button(this, "btnStop");
        this.btnStop.setPosition(5, n += 15);
        this.btnStop.setSize(45, 15);
        this.btnStop.setLabel(this.resourceManager.getLocalizedString("Controls.btnStop", "Stop"));
        this.btnStop.setParentControl(this);
        this.btnStop.addActionListener(this);
        this.btnStop.setActionCommand("btnStopClick");
        this.btnOK = new Button(this, "btnOK");
        this.btnOK.setPosition(65, n);
        this.btnOK.setSize(40, 15);
        this.btnOK.setLabel(this.resourceManager.getLocalizedString("Controls.btnOK", "OK"));
        this.btnOK.setParentControl(this);
        this.btnOK.addActionListener(this);
        this.btnOK.setActionCommand("btnOKClick");
        this.btnOK.setEnabled(false);
        this.btnContinue = new Button(this, "btnContinue");
        this.btnContinue.setPosition(110, n);
        this.btnContinue.setSize(55, 15);
        this.btnContinue.setLabel(this.resourceManager.getLocalizedString("Controls.btnContinue", "Continue"));
        this.btnContinue.setParentControl(this);
        this.btnContinue.addActionListener(this);
        this.btnContinue.setActionCommand("btnContinueClick");
        this.btnContinue.setEnabled(false);
        n += 15;
    }

    public int getUserState() {
        return this.userState;
    }

    public void setBestSolution(double d, boolean bl) {
        this.lblSolutionValue.setLabel(String.format("%.2f", d));
        if (bl) {
            this.lblSolutionValue.setTextColor(this.defaultTextColor);
        } else {
            this.lblSolutionValue.setTextColor(0xFF0000);
        }
    }

    public void setMaxIterations(int n) {
        this.pbIteration.setRange(0, n);
        this.maxIterations = n;
    }

    public void setMaxStagnation(int n) {
        this.pbStagnation.setRange(0, n);
        this.maxStagnation = n;
    }

    public void setIteration(int n) {
        this.pbIteration.setValue(n);
    }

    public void setStagnation(int n) {
        this.pbStagnation.setValue(n);
    }

    public void setRuntime(long l) {
        this.lblRuntimeValue.setLabel(BaseNLPSolver.nanoTimeToString(this.resourceManager, l));
    }

    public int waitForUser() {
        this.btnStop.setEnabled(false);
        this.btnOK.setEnabled(true);
        this.btnContinue.setEnabled(true);
        if (this.pbIteration.getValue() >= this.maxIterations) {
            this.lblIteration.setTextColor(0xFF0000);
            if (this.userState != 3) {
                this.lblStagnationValue.setLabel(this.resourceManager.getLocalizedString("Message.StopIteration", "Maximum iterations reached."));
            }
        }
        if (this.pbStagnation.getValue() >= this.maxStagnation) {
            this.lblStagnation.setTextColor(0xFF0000);
            if (this.userState != 3) {
                this.lblStagnationValue.setLabel(this.resourceManager.getLocalizedString("Message.StopStagnation", "Process stopped due to stagnation."));
            }
        }
        this.lblIterationValue.setLabel(String.format(this.resourceManager.getLocalizedString("Message.CurrentIteration", "Process stopped at iteration %d of %d."), this.pbIteration.getValue(), this.maxIterations));
        if (this.userState == 3) {
            this.lblStagnationValue.setLabel(this.resourceManager.getLocalizedString("Message.StopUser", "Process stopped due to user interruption."));
        }
        this.pbIteration.setVisible(false);
        this.pbStagnation.setVisible(false);
        this.lblIterationValue.setVisible(true);
        this.lblStagnationValue.setVisible(true);
        this.repaint();
        this.userState = 0;
        this.xDialog.execute();
        this.lblIteration.setTextColor(this.defaultTextColor);
        this.lblStagnation.setTextColor(this.defaultTextColor);
        this.lblIterationValue.setVisible(false);
        this.lblStagnationValue.setVisible(false);
        this.pbIteration.setVisible(true);
        this.pbStagnation.setVisible(true);
        this.btnStop.setEnabled(true);
        this.btnOK.setEnabled(false);
        this.btnContinue.setEnabled(false);
        return this.userState;
    }

    public void setVisible(boolean bl) {
        this.xWindow.setVisible(bl);
    }

    public void dispose() {
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xDialog);
        xComponent.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.userState == 0) {
            this.xDialog.endExecute();
            this.setVisible(true);
        }
        if (actionEvent.ActionCommand.equals("btnStopClick")) {
            this.userState = 3;
        } else if (actionEvent.ActionCommand.equals("btnOKClick")) {
            this.userState = 1;
        } else if (actionEvent.ActionCommand.equals("btnContinueClick")) {
            this.userState = 2;
        }
    }

    public void disposing(EventObject eventObject) {
    }
}

